/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.mktcenter.api.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bizvane.mktcenter.api.domain.bo.SendActivityBO;
import com.bizvane.mktcenter.api.service.ApiMktActivityCommonService;
import com.bizvane.mktcenter.api.utils.ResponseUtil;
import com.bizvane.mktcenter.domain.domain.po.TMktActivity;
import com.bizvane.mktcenter.domain.domain.po.TMktActivitySendRecord;
import com.bizvane.mktcenter.domain.service.TMktActivitySendRecordService;
import com.bizvane.mktcenter.domain.service.TMktActivityService;
import com.bizvane.utils.responseinfo.ResponseData;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiMktActivityCommonServiceImpl
implements ApiMktActivityCommonService {
    private static final Logger log = LoggerFactory.getLogger(ApiMktActivityCommonServiceImpl.class);
    @Autowired
    private TMktActivityService tMktActivityService;
    @Autowired
    private TMktActivitySendRecordService tMktActivitySendRecordService;

    @Override
    public ResponseData<String> disableActivity(String mktActivityCode) {
        TMktActivity tMktActivity = (TMktActivity)this.tMktActivityService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivity::getMktActivityCode, (Object)mktActivityCode)).eq(TMktActivity::getValid, (Object)1));
        if (tMktActivity == null) {
            return ResponseUtil.getFailedMsg("\u4f1a\u5458\u6ce8\u518c\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        tMktActivity.setActivityStatus(Integer.valueOf(4));
        this.tMktActivityService.updateById((Object)tMktActivity);
        return ResponseUtil.getSuccessData("\u7981\u7528\u6210\u529f");
    }

    @Override
    public ResponseData<String> sendActivityBenefit(SendActivityBO sendActivityBO, List<String> memberCodeList) {
        List sendRecordList = this.tMktActivitySendRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktActivitySendRecord.class).eq(TMktActivitySendRecord::getMktActivityCode, (Object)sendActivityBO.getMktActivityCode())).eq(TMktActivitySendRecord::getValid, (Object)1)).in(TMktActivitySendRecord::getMbrMembersCode, memberCodeList)).eq(TMktActivitySendRecord::getBusinessCode, (Object)sendActivityBO.getBusinessCode())).between(TMktActivitySendRecord::getCreateDate, (Object)DateUtil.beginOfYear((Date)new Date()), (Object)DateUtil.endOfYear((Date)new Date())));
        if (CollUtil.isNotEmpty((Collection)sendRecordList)) {
            Set mbrMemberCodeSet = sendRecordList.stream().map(TMktActivitySendRecord::getMbrMembersCode).collect(Collectors.toSet());
            memberCodeList = memberCodeList.stream().filter(item -> !mbrMemberCodeSet.contains(item)).collect(Collectors.toList());
        }
        List tMktActivitySendRecordList = memberCodeList.stream().map(memberCode -> {
            TMktActivitySendRecord record = new TMktActivitySendRecord();
            record.setMktActivitySendRecordCode(IdUtil.fastSimpleUUID());
            record.setMktActivityCode(sendActivityBO.getMktActivityCode());
            record.setMbrMembersCode(memberCode);
            record.setActivityType(sendActivityBO.getActivityType());
            record.setSendDate(LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            record.setIntegral(sendActivityBO.getIntegral());
            record.setCouponCodeList(sendActivityBO.getCouponCodeList());
            record.setBusinessCode(sendActivityBO.getBusinessCode());
            record.setMktActivitySignInPrizeCode(sendActivityBO.getMktActivitySignInPrizeCode());
            record.setValid(Integer.valueOf(1));
            return record;
        }).collect(Collectors.toList());
        this.tMktActivitySendRecordService.saveBatch(tMktActivitySendRecordList);
        return ResponseUtil.getSuccessData("\u53d1\u9001\u6210\u529f");
    }
}

