/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.mktcenter.api.service.impl.mobile;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bizvane.mktcenter.api.controller.req.MbrSignInReqVO;
import com.bizvane.mktcenter.api.domain.bo.SendActivityBO;
import com.bizvane.mktcenter.api.service.ApiMktActivityCommonService;
import com.bizvane.mktcenter.api.service.MobileActivitySignInService;
import com.bizvane.mktcenter.api.utils.ResponseUtil;
import com.bizvane.mktcenter.domain.domain.po.TMktActivity;
import com.bizvane.mktcenter.domain.domain.po.TMktActivitySignInPrize;
import com.bizvane.mktcenter.domain.domain.po.TMktActivitySignInRecord;
import com.bizvane.mktcenter.domain.service.TMktActivityService;
import com.bizvane.mktcenter.domain.service.TMktActivitySignInPrizeService;
import com.bizvane.mktcenter.domain.service.TMktActivitySignInRecordService;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MobileActivitySignInServiceImpl
implements MobileActivitySignInService {
    private static final Logger log = LoggerFactory.getLogger(MobileActivitySignInServiceImpl.class);
    @Autowired
    private TMktActivitySignInPrizeService tMktActivitySignInPrizeService;
    @Autowired
    private TMktActivitySignInRecordService tMktActivitySignInRecordService;
    @Autowired
    private TMktActivityService tMktActivityService;
    @Autowired
    private ApiMktActivityCommonService apiMktActivityCommonService;

    @Override
    public ResponseData<String> mbrSignIn(MbrSignInReqVO reqVO) {
        String memberCode = reqVO.getMemberCode();
        TMktActivitySignInRecord todaySignIn = (TMktActivitySignInRecord)this.tMktActivitySignInRecordService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivitySignInRecord::getMbrMemberCode, (Object)memberCode)).between(TMktActivitySignInRecord::getSignInDate, (Object)Date.from(LocalDate.now().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()), (Object)Date.from(LocalDate.now().atTime(23, 59, 59).atZone(ZoneId.systemDefault()).toInstant()))).eq(TMktActivitySignInRecord::getValid, (Object)1));
        if (todaySignIn != null) {
            return ResponseUtil.getFailedMsg("\u4eca\u65e5\u5df2\u7b7e\u5230");
        }
        TMktActivitySignInRecord signInRecord = new TMktActivitySignInRecord();
        signInRecord.setMktActivitySignInRecordCode(IdUtil.fastSimpleUUID());
        signInRecord.setMbrMemberCode(memberCode);
        signInRecord.setSignInDate(new Date());
        signInRecord.setValid(Integer.valueOf(1));
        Integer continuousNum = 1;
        TMktActivitySignInRecord yesterdaySignIn = (TMktActivitySignInRecord)this.tMktActivitySignInRecordService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivitySignInRecord::getMbrMemberCode, (Object)memberCode)).between(TMktActivitySignInRecord::getSignInDate, (Object)Date.from(LocalDate.now().minusDays(1L).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()), (Object)Date.from(LocalDate.now().minusDays(1L).atTime(23, 59, 59).atZone(ZoneId.systemDefault()).toInstant()))).eq(TMktActivitySignInRecord::getValid, (Object)1));
        if (yesterdaySignIn != null) {
            continuousNum = yesterdaySignIn.getContinuousNum() + 1;
        }
        Integer accumulateNum = this.tMktActivitySignInRecordService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktActivitySignInRecord::getMbrMemberCode, (Object)memberCode)).eq(TMktActivitySignInRecord::getValid, (Object)1));
        accumulateNum = accumulateNum + 1;
        signInRecord.setContinuousNum(continuousNum);
        signInRecord.setAccumulateNum(accumulateNum);
        this.tMktActivitySignInRecordService.save((Object)signInRecord);
        TMktActivity tMktActivity = (TMktActivity)this.tMktActivityService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktActivity.class).eq(TMktActivity::getActivityType, (Object)5)).eq(TMktActivity::getActivityStatus, (Object)2)).eq(TMktActivity::getCheckStatus, (Object)3)).eq(TMktActivity::getValid, (Object)1));
        List signInPrizeList = this.tMktActivitySignInPrizeService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktActivitySignInPrize.class).eq(TMktActivitySignInPrize::getMktActivityCode, (Object)tMktActivity.getMktActivityCode())).eq(TMktActivitySignInPrize::getValid, (Object)1));
        log.info("signInPrizeList: {}", (Object)JacksonUtil.list2Json((List)signInPrizeList));
        if (CollUtil.isNotEmpty((Collection)signInPrizeList)) {
            for (TMktActivitySignInPrize tMktActivitySignInPrize : signInPrizeList) {
                Integer signInType = tMktActivitySignInPrize.getSignInType();
                if (!ObjUtil.equals((Object)1, (Object)signInType) && (!ObjUtil.equals((Object)2, (Object)signInType) || !ObjUtil.equals((Object)continuousNum, (Object)tMktActivitySignInPrize.getSignInDays())) && (!ObjUtil.equals((Object)3, (Object)signInType) || !ObjUtil.equals((Object)accumulateNum, (Object)tMktActivitySignInPrize.getSignInDays()))) continue;
                SendActivityBO sendActivityBO = new SendActivityBO();
                sendActivityBO.setActivityNo(tMktActivity.getActivityNo());
                sendActivityBO.setMktActivityCode(tMktActivity.getMktActivityCode());
                sendActivityBO.setIntegral(tMktActivity.getIntegral());
                sendActivityBO.setCouponCodeList(tMktActivity.getCouponCodeList());
                sendActivityBO.setBusinessCode(signInRecord.getMktActivitySignInRecordCode());
                sendActivityBO.setMktActivitySignInPrizeCode(tMktActivitySignInPrize.getMktActivitySignInPrizeCode());
                ResponseData<String> sentActivityResp = this.apiMktActivityCommonService.sendActivityBenefit(sendActivityBO, Arrays.asList(memberCode));
                log.info("sentActivityResp:{}", (Object)JacksonUtil.bean2Json(sentActivityResp));
            }
        }
        return ResponseUtil.getSuccessData("\u7b7e\u5230\u6210\u529f");
    }
}

