/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.mktcenter.api.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.mktcenter.api.service.ApiMktTaskCommonService;
import com.bizvane.mktcenter.api.service.ApiMktTaskImproveProfileService;
import com.bizvane.mktcenter.api.utils.ResponseUtil;
import com.bizvane.mktcenter.domain.domain.po.TMktTask;
import com.bizvane.mktcenter.domain.domain.po.TMktTaskImproveProfile;
import com.bizvane.mktcenter.domain.service.TMktTaskImproveProfileService;
import com.bizvane.mktcenter.domain.service.TMktTaskService;
import com.bizvane.mktcenter.feign.vo.req.AddOrUpdateMktTaskImproveProfileReqVO;
import com.bizvane.mktcenter.feign.vo.req.QueryTaskAnalysisPageReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryDetailTaskImproveProfileRespVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryTaskImproveProfileAnalysisPageRespVO;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiMktTaskImproveProfileServiceImpl
implements ApiMktTaskImproveProfileService {
    private static final Logger log = LoggerFactory.getLogger(ApiMktTaskImproveProfileServiceImpl.class);
    @Autowired
    private TMktTaskService tMktTaskService;
    @Autowired
    private TMktTaskImproveProfileService tMktTaskImproveProfileService;
    @Autowired
    private ApiMktTaskCommonService apiMktTaskCommonService;

    @Override
    public ResponseData<String> saveOrUpdate(AddOrUpdateMktTaskImproveProfileReqVO reqVO) {
        String mktTaskCode = reqVO.getMktTaskCode();
        TMktTask tMktTask = null;
        TMktTaskImproveProfile tMktTaskImproveProfile = null;
        if (StrUtil.isNotBlank((CharSequence)mktTaskCode)) {
            tMktTaskImproveProfile = (TMktTaskImproveProfile)this.tMktTaskImproveProfileService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTaskImproveProfile::getMktTaskCode, (Object)mktTaskCode)).eq(TMktTaskImproveProfile::getValid, (Object)1));
            if (tMktTaskImproveProfile == null) {
                return ResponseUtil.getFailedMsg("\u5b8c\u5584\u8d44\u6599\u4efb\u52a1\u4e0d\u5b58\u5728");
            }
            tMktTask = (TMktTask)this.tMktTaskService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTask::getMktTaskCode, (Object)mktTaskCode)).eq(TMktTask::getValid, (Object)1));
            if (tMktTask == null) {
                return ResponseUtil.getFailedMsg("\u5b8c\u5584\u8d44\u6599\u4efb\u52a1\u4e0d\u5b58\u5728");
            }
        } else {
            tMktTask = new TMktTask();
            tMktTaskImproveProfile = new TMktTaskImproveProfile();
            mktTaskCode = IdUtil.fastSimpleUUID();
            tMktTask.setMktTaskCode(mktTaskCode);
            tMktTask.setTaskNo(IdUtil.fastSimpleUUID());
            tMktTask.setTaskType(Integer.valueOf(2));
            tMktTask.setTaskStatus(Integer.valueOf(1));
            tMktTask.setCheckStatus(Integer.valueOf(1));
            tMktTask.setValid(Integer.valueOf(1));
            tMktTaskImproveProfile.setMktTaskCode(mktTaskCode);
            tMktTaskImproveProfile.setMktTaskImproveProfileCode(IdUtil.fastSimpleUUID());
            tMktTaskImproveProfile.setValid(Integer.valueOf(1));
        }
        BeanUtil.copyProperties((Object)reqVO, (Object)tMktTaskImproveProfile, (CopyOptions)CopyOptions.create().ignoreNullValue());
        BeanUtil.copyProperties((Object)reqVO, (Object)tMktTask, (CopyOptions)CopyOptions.create().ignoreNullValue());
        tMktTask.setCouponCodeList((String)Optional.ofNullable(reqVO.getCouponCodeList()).map(list -> String.join((CharSequence)",", list)).orElse(null));
        tMktTaskImproveProfile.setImproveProfileOptions((String)Optional.ofNullable(reqVO.getImproveProfileOptionList()).map(list -> String.join((CharSequence)",", list)).orElse(null));
        this.tMktTaskService.saveOrUpdate((Object)tMktTask);
        this.tMktTaskImproveProfileService.saveOrUpdate((Object)tMktTaskImproveProfile);
        return ResponseUtil.getSuccessData("\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public ResponseData<PageInfo<QueryTaskImproveProfileAnalysisPageRespVO>> analysisPageList(QueryTaskAnalysisPageReqVO reqVO) {
        Page page = (Page)((Page)this.tMktTaskService.page((IPage)new Page((long)reqVO.getPageNo().intValue(), (long)reqVO.getPageSize().intValue()), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTask::getTaskType, (Object)1)).eq(TMktTask::getValid, (Object)1)).eq(StrUtil.isNotBlank((CharSequence)reqVO.getTaskName()), TMktTask::getTaskName, (Object)reqVO.getTaskName())).eq(StrUtil.isNotBlank((CharSequence)reqVO.getTaskNo()), TMktTask::getTaskNo, (Object)reqVO.getTaskNo()))).convert(tMktTask -> (QueryTaskImproveProfileAnalysisPageRespVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)tMktTask), QueryTaskImproveProfileAnalysisPageRespVO.class));
        PageInfo pageInfo = new PageInfo((int)page.getCurrent(), (int)page.getSize(), page.getTotal(), page.getRecords());
        return ResponseUtil.getSuccessData(pageInfo);
    }

    @Override
    public ResponseData<QueryDetailTaskImproveProfileRespVO> getDetail(String mktTaskCode) {
        TMktTaskImproveProfile tMktTaskImproveProfile = (TMktTaskImproveProfile)this.tMktTaskImproveProfileService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTaskImproveProfile::getMktTaskCode, (Object)mktTaskCode)).eq(TMktTaskImproveProfile::getValid, (Object)1));
        if (tMktTaskImproveProfile == null) {
            return ResponseUtil.getFailedMsg("\u5b8c\u5584\u8d44\u6599\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        TMktTask tMktTask = (TMktTask)this.tMktTaskService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTask::getMktTaskCode, (Object)mktTaskCode)).eq(TMktTask::getValid, (Object)1));
        if (tMktTask == null) {
            return ResponseUtil.getFailedMsg("\u5b8c\u5584\u8d44\u6599\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        QueryDetailTaskImproveProfileRespVO respVO = new QueryDetailTaskImproveProfileRespVO();
        BeanUtil.copyProperties((Object)tMktTaskImproveProfile, (Object)respVO, (CopyOptions)CopyOptions.create().ignoreNullValue());
        BeanUtil.copyProperties((Object)tMktTask, (Object)respVO, (CopyOptions)CopyOptions.create().ignoreNullValue());
        respVO.setCouponCodeList((List)Optional.ofNullable(tMktTask.getCouponCodeList()).map(str -> Arrays.asList(str.split(","))).orElse(null));
        respVO.setImproveProfileOptionList((List)Optional.ofNullable(tMktTaskImproveProfile.getImproveProfileOptions()).map(str -> Arrays.asList(str.split(","))).orElse(null));
        return ResponseUtil.getSuccessData(respVO);
    }
}

