/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.mktcenter.api.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.mktcenter.api.domain.bo.SendTaskBO;
import com.bizvane.mktcenter.api.service.ApiMktTaskCommonService;
import com.bizvane.mktcenter.api.utils.ResponseUtil;
import com.bizvane.mktcenter.domain.domain.po.TMktTask;
import com.bizvane.mktcenter.domain.domain.po.TMktTaskSendRecord;
import com.bizvane.mktcenter.domain.service.TMktTaskSendRecordService;
import com.bizvane.mktcenter.domain.service.TMktTaskService;
import com.bizvane.mktcenter.feign.vo.req.QueryPageTaskPageReqVO;
import com.bizvane.mktcenter.feign.vo.resp.QueryTaskInviteRegisterPageRespVO;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiMktTaskCommonServiceImpl
implements ApiMktTaskCommonService {
    private static final Logger log = LoggerFactory.getLogger(ApiMktTaskCommonServiceImpl.class);
    @Autowired
    private TMktTaskService tMktTaskService;
    @Autowired
    private TMktTaskSendRecordService tMktTaskSendRecordService;

    @Override
    public ResponseData<PageInfo<QueryTaskInviteRegisterPageRespVO>> pageList(QueryPageTaskPageReqVO reqVO) {
        Page page = (Page)((Page)this.tMktTaskService.page((IPage)new Page((long)reqVO.getPageNo().intValue(), (long)reqVO.getPageSize().intValue()), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTask::getTaskType, (Object)1)).eq(TMktTask::getValid, (Object)1)).eq(StrUtil.isNotBlank((CharSequence)reqVO.getTaskName()), TMktTask::getTaskName, (Object)reqVO.getTaskName())).eq(StrUtil.isNotBlank((CharSequence)reqVO.getTaskNo()), TMktTask::getTaskNo, (Object)reqVO.getTaskNo())).eq(StrUtil.isNotBlank((CharSequence)reqVO.getCreateUserName()), TMktTask::getCreateUserName, (Object)reqVO.getCreateUserName())).eq(reqVO.getCheckStatus() != null, TMktTask::getCheckStatus, (Object)reqVO.getCheckStatus())).eq(reqVO.getTaskStatus() != null, TMktTask::getTaskStatus, (Object)reqVO.getTaskStatus()))).convert(tMktTask -> (QueryTaskInviteRegisterPageRespVO)JacksonUtil.json2Obj((String)JacksonUtil.bean2Json((Object)tMktTask), QueryTaskInviteRegisterPageRespVO.class));
        PageInfo pageInfo = new PageInfo((int)page.getCurrent(), (int)page.getSize(), page.getTotal(), page.getRecords());
        return ResponseUtil.getSuccessData(pageInfo);
    }

    @Override
    public ResponseData<String> disableTask(String mktTaskCode) {
        TMktTask tMktTask = (TMktTask)this.tMktTaskService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TMktTask::getMktTaskCode, (Object)mktTaskCode)).eq(TMktTask::getValid, (Object)1));
        if (tMktTask == null) {
            return ResponseUtil.getFailedMsg("\u8425\u9500\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        tMktTask.setTaskStatus(Integer.valueOf(4));
        this.tMktTaskService.updateById((Object)tMktTask);
        return ResponseUtil.getSuccessData("\u7981\u7528\u6210\u529f");
    }

    @Override
    public ResponseData<String> sendTaskBenefit(SendTaskBO sendTaskBO, List<String> memberCodeList) {
        List sendRecordList = this.tMktTaskSendRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(TMktTaskSendRecord.class).eq(TMktTaskSendRecord::getMktTaskCode, (Object)sendTaskBO.getMktTaskCode())).eq(TMktTaskSendRecord::getValid, (Object)1)).in(TMktTaskSendRecord::getMbrMembersCode, memberCodeList)).between(TMktTaskSendRecord::getSendDate, (Object)DateUtil.beginOfYear((Date)new Date()), (Object)DateUtil.endOfYear((Date)new Date())));
        if (CollUtil.isNotEmpty((Collection)sendRecordList)) {
            Set mbrMemberCodeSet = sendRecordList.stream().map(TMktTaskSendRecord::getMbrMembersCode).collect(Collectors.toSet());
            memberCodeList = memberCodeList.stream().filter(item -> !mbrMemberCodeSet.contains(item)).collect(Collectors.toList());
        }
        List tMktTaskSendRecordList = memberCodeList.stream().map(memberCode -> {
            TMktTaskSendRecord record = new TMktTaskSendRecord();
            record.setMktTaskSendRecordCode(IdUtil.fastSimpleUUID());
            record.setMktTaskCode(sendTaskBO.getMktTaskCode());
            record.setMbrMembersCode(memberCode);
            record.setTaskType(sendTaskBO.getTaskType());
            record.setSendDate(LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            record.setIntegral(sendTaskBO.getIntegral());
            record.setCouponCodeList(sendTaskBO.getCouponCodeList());
            record.setBusinessCode(sendTaskBO.getBusinessCode());
            record.setValid(Integer.valueOf(1));
            return record;
        }).collect(Collectors.toList());
        this.tMktTaskSendRecordService.saveBatch(tMktTaskSendRecordList);
        return ResponseUtil.getSuccessData("\u53d1\u9001\u6210\u529f");
    }
}

