/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.sms.rocketmq.consumer;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.message.mappers.MsgSmsRecordPoMapper;
import com.bizvane.message.mappers.SysSmsConfigPOMapper;
import com.bizvane.message.po.MsgSmsRecordPo;
import com.bizvane.messagebase.common.constants.ResponseData;
import com.bizvane.messagebase.common.constants.SysResponseEnum;
import com.bizvane.messagebase.model.po.MsgSmsLogPO;
import com.bizvane.messagebase.model.po.SysCodeValuePO;
import com.bizvane.messagebase.model.po.SysSmsConfigPOExample;
import com.bizvane.messagebase.model.vo.SysSmsConfigVO;
import com.bizvane.sms.baseProcess.MessageBaseProcess;
import com.bizvane.sms.mongo.BaseMongoDao;
import com.bizvane.sms.mongo.initCode.DictHelper;
import com.bizvane.sms.service.impl.SendBatchMessageImpl;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;

@RocketMQMessageListener(topic="public_bizvane_batch_message")
public class StandardBatchConsumer
extends MessageBaseProcess
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(StandardBatchConsumer.class);
    @Autowired
    private SysSmsConfigPOMapper sysSmsConfigPOMapper;
    @Autowired
    private SendBatchMessageImpl sendBatchMessage;
    @Autowired
    private MsgSmsRecordPoMapper msgSmsRecordPoMapper;
    @Autowired
    private BaseMongoDao<MsgSmsLogPO> msgSmsLogPOBaseMongoDao;

    public void onMessage(ConsumerMessage<String> message) {
        log.info("StandardBatchConsumer\u6d88\u8d39\u5230\u6d88\u606f:{},traceId:{}", message.getMessage(), (Object)MDC.get((String)"traceId"));
        super.send((String)message.getMessage());
    }

    public ResponseData<String> notNullCheck(String str) {
        return super.notNullCheckCommon(str);
    }

    public ResponseData<String> templateExistCheck(String str) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)str);
        return responseData;
    }

    public ResponseData<SysSmsConfigVO> channelExistCheck(String str) {
        ResponseData responseData = new ResponseData();
        JSONObject jsonObject = JSON.parseObject((String)str);
        Long sysBrandId = jsonObject.getLong("sysBrandId");
        String msgContent = jsonObject.getString("msgContent");
        SysSmsConfigPOExample sysSmsConfigPOExample = new SysSmsConfigPOExample();
        sysSmsConfigPOExample.createCriteria().andSysBrandIdEqualTo(sysBrandId).andChannelTypeEqualTo(Integer.valueOf(10)).andValidEqualTo(Boolean.TRUE);
        List sysSmsConfigList = this.sysSmsConfigPOMapper.selectByExample(sysSmsConfigPOExample);
        if (CollectionUtils.isNotEmpty((Collection)sysSmsConfigList)) {
            ObjectMapper mapper = new ObjectMapper();
            SysSmsConfigVO sysSmsConfigVO = (SysSmsConfigVO)mapper.convertValue(sysSmsConfigList.get(0), SysSmsConfigVO.class);
            sysSmsConfigVO.setMsgContent(msgContent);
            sysSmsConfigVO.setPhones(jsonObject.getString("phones"));
            responseData.setData((Object)sysSmsConfigVO);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        } else {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u54c1\u724cid:" + sysBrandId + "\u672a\u627e\u5230\u77ed\u4fe1\u901a\u9053\u4fe1\u606f");
        }
        return responseData;
    }

    public ResponseData<String> harassCheck(String str) {
        return super.commonHarassCheck(str);
    }

    public ResponseData<Integer> sendMessage(SysSmsConfigVO sysSmsConfigVO) {
        return this.sendBatchMessage.sendSmgBatch(sysSmsConfigVO);
    }

    public ResponseData<String> insertRecord(String str) {
        ResponseData responseData = new ResponseData();
        JSONObject jsonObject = JSON.parseObject((String)str);
        Long sysBrandId = jsonObject.getLong("sysBrandId");
        Long sysCompanyId = jsonObject.getLong("sysCompanyId");
        String memberPhones = jsonObject.getString("phones");
        String memberOnlineServiceStoreCodes = jsonObject.getString("memberOnlineServiceStoreCodes");
        String memberNames = jsonObject.getString("memberNames");
        String scene = jsonObject.getString("scene");
        String[] phoneArray = memberPhones.split(",");
        String[] storeCodeArray = memberOnlineServiceStoreCodes.split(",");
        String[] nameArray = memberNames.split(",");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < phoneArray.length; ++i) {
            MsgSmsRecordPo msgSmsRecordPo = new MsgSmsRecordPo();
            msgSmsRecordPo.setSysBrandId(sysBrandId);
            msgSmsRecordPo.setSysCompanyId(sysCompanyId);
            msgSmsRecordPo.setMemberPhone(phoneArray[i]);
            msgSmsRecordPo.setMemberOnlineServiceStoreCode(storeCodeArray[i]);
            msgSmsRecordPo.setMemberName(nameArray[i]);
            msgSmsRecordPo.setContent(jsonObject.getString("msgContent"));
            msgSmsRecordPo.setCreateDate(new Date());
            msgSmsRecordPo.setSceneCode(scene);
            SysCodeValuePO sysCodeValuePO = DictHelper.getDict((String)"template_type_sms", (String)jsonObject.getString("scene"));
            if (sysCodeValuePO == null) {
                msgSmsRecordPo.setScene("\u9a8c\u8bc1\u7801");
            } else {
                String templateTypeName = DictHelper.getDict((String)"template_type_sms", (String)jsonObject.getString("scene")).getItemCodeName();
                msgSmsRecordPo.setScene(templateTypeName);
            }
            msgSmsRecordPo.setSendState(Integer.valueOf(0));
            msgSmsRecordPo.setTrace(MDC.get((String)"traceId"));
            this.msgSmsRecordPoMapper.insertSelective(msgSmsRecordPo);
            log.info("insertRecord\u63d2\u5165\u6570\u636e\u5230db\u6210\u529f:{}", (Object)JSON.toJSONString((Object)msgSmsRecordPo));
            sb.append(msgSmsRecordPo.getMsgSmsRecordId()).append(",");
        }
        String mkgSmsRecordIds = sb.deleteCharAt(sb.length() - 1).toString();
        responseData.setData((Object)mkgSmsRecordIds);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public void updateRecord(ResponseData<Integer> integerResponseData, String msgSmsRecordIds, int sendCount) {
        String[] msgSmsRecordIdArray = msgSmsRecordIds.split(",");
        MsgSmsRecordPo update = new MsgSmsRecordPo();
        if (integerResponseData.getCode() == SysResponseEnum.SUCCESS.getCode()) {
            for (int i = 0; i < msgSmsRecordIdArray.length; ++i) {
                update.setMsgSmsRecordId(Long.valueOf(msgSmsRecordIdArray[i]));
                update.setSendResultCount(Integer.valueOf(sendCount));
                update.setSendState(Integer.valueOf(1));
                this.msgSmsRecordPoMapper.updateByPrimaryKeySelective(update);
            }
        } else {
            for (int i = 0; i < msgSmsRecordIdArray.length; ++i) {
                update.setMsgSmsRecordId(Long.valueOf(msgSmsRecordIdArray[i]));
                update.setSendState(Integer.valueOf(-1));
                update.setFailDetail(integerResponseData.getMessage());
                this.msgSmsRecordPoMapper.updateByPrimaryKeySelective(update);
            }
        }
    }

    public void insertMongo(ResponseData<Integer> integerResponseData, String str) {
        JSONObject jsonObject = JSON.parseObject((String)str);
        String phoneStr = jsonObject.getString("phones");
        String memberNames = jsonObject.getString("memberNames");
        String[] phoneArray = phoneStr.split(",");
        String[] nameArray = memberNames.split(",");
        int sendStatus = -1;
        String resultInfo = "\u5931\u8d25";
        if (integerResponseData.getCode() == SysResponseEnum.SUCCESS.getCode()) {
            sendStatus = 1;
            resultInfo = "\u6210\u529f";
            for (int i = 0; i < phoneArray.length; ++i) {
                SysCodeValuePO sysCodeValuePO;
                MsgSmsLogPO insertPO = new MsgSmsLogPO();
                insertPO.setCreateDate(new Date());
                if (!StringUtils.isBlank((CharSequence)jsonObject.getString("scene"))) {
                    insertPO.setTemplateType(jsonObject.getString("scene"));
                }
                if ((sysCodeValuePO = DictHelper.getDict((String)"template_type_sms", (String)jsonObject.getString("scene"))) == null) {
                    insertPO.setTemplateTypeName("\u9a8c\u8bc1\u7801");
                } else {
                    String templateTypeName = DictHelper.getDict((String)"template_type_sms", (String)jsonObject.getString("scene")).getItemCodeName();
                    insertPO.setTemplateTypeName(templateTypeName);
                }
                insertPO.setMemberPhone(phoneArray[i]);
                insertPO.setMemberName(nameArray[i]);
                insertPO.setMessageBody(str);
                if (!StringUtils.isBlank((CharSequence)jsonObject.getString("sysBrandId"))) {
                    insertPO.setSysBrandId(jsonObject.getLong("sysBrandId"));
                }
                insertPO.setSendState(Integer.valueOf(sendStatus));
                insertPO.setResultInfo(resultInfo);
                this.msgSmsLogPOBaseMongoDao.insert((Object)insertPO);
                log.info("\u63d2\u5165\u5230mongo\u6210\u529f:{},\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)insertPO), (Object)insertPO.get_id());
            }
        } else {
            for (int i = 0; i < phoneArray.length; ++i) {
                MsgSmsLogPO insertPO = new MsgSmsLogPO();
                insertPO.setCreateDate(new Date());
                insertPO.setBussinessId("testBusinessId");
                insertPO.setTemplateType(jsonObject.getString("scene"));
                insertPO.setTemplateTypeName(DictHelper.getDict((String)"template_type_sms", (String)jsonObject.getString("scene")).getItemCodeName());
                insertPO.setMemberPhone(phoneArray[i]);
                insertPO.setMemberName(nameArray[i]);
                insertPO.setMessageBody(str);
                if (!StringUtils.isBlank((CharSequence)jsonObject.getString("sysBrandId"))) {
                    insertPO.setSysBrandId(jsonObject.getLong("sysBrandId"));
                }
                insertPO.setSendState(Integer.valueOf(sendStatus));
                insertPO.setResultInfo(resultInfo);
                insertPO.setResultInfoDetail(integerResponseData.getMessage());
                this.msgSmsLogPOBaseMongoDao.insert((Object)insertPO);
                log.info("\u63d2\u5165\u5230mongo\u6210\u529f:{},\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)insertPO), (Object)insertPO.get_id());
            }
        }
    }
}

