/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.sms.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.message.mappers.MsgSmsRecordPoMapper;
import com.bizvane.message.mappers.SysSmsConfigPOMapper;
import com.bizvane.messagebase.common.constants.ResponseData;
import com.bizvane.messagebase.common.constants.SysResponseEnum;
import com.bizvane.messagebase.model.po.SysSmsConfigPOExample;
import com.bizvane.messagebase.model.vo.StandardMessageVo;
import com.bizvane.messagebase.model.vo.SysSmsConfigVO;
import com.bizvane.sms.baseProcess.MessageBaseProcess;
import com.bizvane.sms.service.VerificationCodeMessageService;
import com.bizvane.sms.service.impl.SendCommonMessageImpl;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VerificationCodeMessageServiceImpl
extends MessageBaseProcess
implements VerificationCodeMessageService {
    private static final Logger log = LoggerFactory.getLogger(VerificationCodeMessageServiceImpl.class);
    @Autowired
    private SysSmsConfigPOMapper sysSmsConfigPOMapper;
    @Autowired
    private SendCommonMessageImpl sendCommonMessage;
    @Autowired
    private MsgSmsRecordPoMapper msgSmsRecordPoMapper;

    public ResponseData<String> send(StandardMessageVo standardMessageVo) {
        return super.send(JSON.toJSONString((Object)standardMessageVo));
    }

    public ResponseData<String> notNullCheck(String str) {
        return super.notNullCheckCommon(str);
    }

    public ResponseData<String> templateExistCheck(String str) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)str);
        return responseData;
    }

    public ResponseData<SysSmsConfigVO> channelExistCheck(String str) {
        ResponseData responseData = new ResponseData();
        JSONObject jsonObject = JSON.parseObject((String)str);
        Long sysBrandId = jsonObject.getLong("sysBrandId");
        String msgContent = jsonObject.getString("msgContent");
        SysSmsConfigPOExample sysSmsConfigPOExample = new SysSmsConfigPOExample();
        sysSmsConfigPOExample.createCriteria().andSysBrandIdEqualTo(sysBrandId).andChannelTypeEqualTo(Integer.valueOf(10)).andValidEqualTo(Boolean.TRUE);
        List sysSmsConfigList = this.sysSmsConfigPOMapper.selectByExample(sysSmsConfigPOExample);
        if (CollectionUtils.isNotEmpty((Collection)sysSmsConfigList)) {
            ObjectMapper mapper = new ObjectMapper();
            SysSmsConfigVO sysSmsConfigVO = (SysSmsConfigVO)mapper.convertValue(sysSmsConfigList.get(0), SysSmsConfigVO.class);
            sysSmsConfigVO.setMsgContent(msgContent);
            sysSmsConfigVO.setPhone(jsonObject.getString("phone"));
            responseData.setData((Object)sysSmsConfigVO);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        } else {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u54c1\u724cid:" + sysBrandId + "\u672a\u627e\u5230\u77ed\u4fe1\u901a\u9053\u4fe1\u606f");
        }
        return responseData;
    }

    public ResponseData<String> harassCheck(String str) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        return responseData;
    }

    public ResponseData<Integer> sendMessage(SysSmsConfigVO sysSmsConfigVO) {
        return this.sendCommonMessage.sendSmg(sysSmsConfigVO);
    }

    public ResponseData<String> insertRecord(String str) {
        return super.insertRecordCommon(str);
    }

    public void updateRecord(ResponseData<Integer> integerResponseData, String msgSmsRecordIds, int sendCount) {
        super.updateRecordCommon(integerResponseData, msgSmsRecordIds, sendCount);
    }

    public void insertMongo(ResponseData<Integer> integerResponseData, String str) {
        super.insertMongoCommon(integerResponseData, str);
    }
}

