/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.sms.rocketmq.consumer;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.message.mappers.MsgSmsTempPOMapper;
import com.bizvane.message.mappers.SysSmsConfigPOMapper;
import com.bizvane.messagebase.common.constants.ResponseData;
import com.bizvane.messagebase.common.constants.SysResponseEnum;
import com.bizvane.messagebase.model.po.MsgSmsTempPO;
import com.bizvane.messagebase.model.po.MsgSmsTempPOExample;
import com.bizvane.messagebase.model.po.SysSmsConfigPOExample;
import com.bizvane.messagebase.model.vo.SysSmsConfigVO;
import com.bizvane.sms.baseProcess.MessageBaseProcess;
import com.bizvane.sms.service.impl.SendCommonMessageImpl;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;

@RocketMQMessageListener(topic="public_bizvane_single_message")
public class StandardSingleConsumer
extends MessageBaseProcess
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(StandardSingleConsumer.class);
    @Autowired
    private MsgSmsTempPOMapper msgSmsTempPOMapper;
    @Autowired
    private SysSmsConfigPOMapper sysSmsConfigPOMapper;
    @Autowired
    private SendCommonMessageImpl sendCommonMessage;

    public void onMessage(ConsumerMessage<String> message) {
        log.info("StandardSingleConsumer:{},traceId:{}", message.getMessage(), (Object)MDC.get((String)"traceId"));
        super.send((String)message.getMessage());
    }

    public ResponseData<String> notNullCheck(String str) {
        return super.notNullCheckCommon(str);
    }

    public ResponseData<String> templateExistCheck(String str) {
        JSONObject jsonObject = JSON.parseObject((String)str);
        Long sysBrandId = jsonObject.getLong("sysBrandId");
        String businessModuleCode = jsonObject.getString("scene");
        String isWxMember = jsonObject.getString("isWxMember");
        ResponseData responseData = new ResponseData();
        MsgSmsTempPOExample msgSmsTempPOExample = new MsgSmsTempPOExample();
        msgSmsTempPOExample.createCriteria().andSysBrandIdEqualTo(sysBrandId).andTemplateTypeEqualTo(businessModuleCode).andValidEqualTo(Boolean.TRUE);
        List smsTempPOList = this.msgSmsTempPOMapper.selectByExample(msgSmsTempPOExample);
        if (null == smsTempPOList || smsTempPOList.size() == 0) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u54c1\u724cid" + sysBrandId + "\u6a21\u677f\u7c7b\u578b:" + businessModuleCode + "\u4e0d\u5b58\u5728");
            return responseData;
        }
        MsgSmsTempPO smsTempPO = (MsgSmsTempPO)smsTempPOList.get(0);
        if (!smsTempPO.getStatus().booleanValue()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u54c1\u724cid" + sysBrandId + "\u6a21\u677f\u7c7b\u578b:" + businessModuleCode + "\u77ed\u4fe1\u6a21\u677f\u914d\u7f6e\u6ca1\u6709\u5f00\u542f");
            return responseData;
        }
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)str);
        return responseData;
    }

    public ResponseData<SysSmsConfigVO> channelExistCheck(String str) {
        ResponseData responseData = new ResponseData();
        JSONObject jsonObject = JSON.parseObject((String)str);
        Long sysBrandId = jsonObject.getLong("sysBrandId");
        String msgContent = jsonObject.getString("msgContent");
        SysSmsConfigPOExample sysSmsConfigPOExample = new SysSmsConfigPOExample();
        sysSmsConfigPOExample.createCriteria().andSysBrandIdEqualTo(sysBrandId).andChannelTypeEqualTo(Integer.valueOf(10)).andValidEqualTo(Boolean.TRUE);
        List sysSmsConfigList = this.sysSmsConfigPOMapper.selectByExample(sysSmsConfigPOExample);
        if (CollectionUtils.isNotEmpty((Collection)sysSmsConfigList)) {
            ObjectMapper mapper = new ObjectMapper();
            SysSmsConfigVO sysSmsConfigVO = (SysSmsConfigVO)mapper.convertValue(sysSmsConfigList.get(0), SysSmsConfigVO.class);
            sysSmsConfigVO.setMsgContent(msgContent);
            sysSmsConfigVO.setPhone(jsonObject.getString("phone"));
            sysSmsConfigVO.setMsgId(jsonObject.getString("msgId"));
            responseData.setData((Object)sysSmsConfigVO);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        } else {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u54c1\u724cid:" + sysBrandId + "\u672a\u627e\u5230\u77ed\u4fe1\u901a\u9053\u4fe1\u606f");
        }
        return responseData;
    }

    public ResponseData<String> harassCheck(String str) {
        return super.commonHarassCheck(str);
    }

    public ResponseData<Integer> sendMessage(SysSmsConfigVO sysSmsConfigVO) {
        return this.sendCommonMessage.sendSmg(sysSmsConfigVO);
    }

    public ResponseData<String> insertRecord(String str) {
        return super.insertRecordCommon(str);
    }

    public void updateRecord(ResponseData<Integer> integerResponseData, String msgSmsRecordIds, int sendCount) {
        super.updateRecordCommon(integerResponseData, msgSmsRecordIds, sendCount);
    }

    public void insertMongo(ResponseData<Integer> integerResponseData, String str) {
        super.insertMongoCommon(integerResponseData, str);
    }
}

