/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.sms.mongo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;

@Component
public class BaseMongoDao<T> {
    protected Class<T> entityClass;
    @Autowired
    protected MongoTemplate mongoTemplate;

    protected Class<T> getEntityClass() {
        if (this.entityClass == null) {
            this.entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        }
        return this.entityClass;
    }

    public List<T> find(Query query) {
        return this.mongoTemplate.find(query, this.getEntityClass());
    }

    protected List<T> find(Query query, String collectionName) {
        return this.mongoTemplate.find(query, this.getEntityClass(), collectionName);
    }

    protected T findOne(Query query) {
        return (T)this.mongoTemplate.findOne(query, this.getEntityClass());
    }

    protected T findOne(Query query, String collectionName) {
        return (T)this.mongoTemplate.findOne(query, this.getEntityClass(), collectionName);
    }

    protected void update(Query query, Update update) {
        this.mongoTemplate.findAndModify(query, update, this.getEntityClass());
    }

    protected void update(Query query, T entity) {
        Update update = new Update();
        JSONObject entityJson = JSON.parseObject((String)JSON.toJSONString(entity));
        for (String key : entityJson.keySet()) {
            Object value = entityJson.get((Object)key);
            update.set(key, value);
        }
        this.mongoTemplate.findAndModify(query, update, this.getEntityClass());
    }

    protected void update(Query query, Update update, String collectionName) {
        this.mongoTemplate.findAndModify(query, update, this.getEntityClass(), collectionName);
    }

    public T insert(T entity) {
        this.mongoTemplate.insert(entity);
        return entity;
    }

    protected T insert(T entity, String collectionName) {
        this.mongoTemplate.insert(entity, collectionName);
        return entity;
    }

    protected T save(T entity) {
        this.mongoTemplate.save(entity);
        return entity;
    }

    protected T save(T entity, String collectionName) {
        this.mongoTemplate.save(entity, collectionName);
        return entity;
    }

    protected void batchSave(Collection<T> entitys) {
        this.mongoTemplate.insert(entitys, this.getEntityClass());
    }

    protected void batchSave(Collection<T> entitys, String collectionName) {
        this.mongoTemplate.insert(entitys, this.getEntityClass());
    }

    protected T delete(T entity) {
        this.mongoTemplate.remove(entity);
        return entity;
    }

    protected T delete(T entity, String collectionName) {
        this.mongoTemplate.remove(entity, collectionName);
        return entity;
    }

    protected void delete(Query query) {
        this.mongoTemplate.remove(query, this.getEntityClass());
    }

    protected void delete(Query query, String collectionName) {
        this.mongoTemplate.remove(query, this.getEntityClass(), collectionName);
    }

    protected T findById(String id) {
        return (T)this.mongoTemplate.findById((Object)id, this.getEntityClass());
    }

    protected T findById(String id, String collectionName) {
        return (T)this.mongoTemplate.findById((Object)id, this.getEntityClass(), collectionName);
    }

    public BaseMongoDao() {
    }

    public BaseMongoDao(Class<T> entityClass) {
        this.entityClass = entityClass;
    }

    protected long count(Query query) {
        return this.mongoTemplate.count(query, this.getEntityClass());
    }

    protected long count(Query query, String collectionName) {
        return this.mongoTemplate.count(query, this.getEntityClass(), collectionName);
    }

    protected MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }
}

