/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.sms.service.impl;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.messagebase.common.constants.ResponseData;
import com.bizvane.messagebase.common.constants.SysRespConstants;
import com.bizvane.messagebase.common.constants.SysResponseEnum;
import com.bizvane.sms.service.StandardRocketMQSendSmsService;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StandardRocketMQSendSmsServiceImpl
implements StandardRocketMQSendSmsService {
    private static final Logger log = LoggerFactory.getLogger(StandardRocketMQSendSmsServiceImpl.class);
    @Autowired
    RocketMQTemplate rocketMQTemplate;

    public ResponseData<String> sendMessage(String messageBody) {
        log.info("StandardRocketMQSendSmsServiceImpl\u5165\u53c2:{}", (Object)messageBody);
        ResponseData result = new ResponseData();
        if (StringUtils.isBlank((CharSequence)messageBody)) {
            log.error("StandardRocketMQSendSmsServiceImpl \tmessageBody\u4e0d\u80fd\u4e3a\u7a7a");
            result.setCode(SysRespConstants.SYSTEM_DATA_NOT_EMPTY.getStatus());
            result.setMessage(SysRespConstants.SYSTEM_DATA_NOT_EMPTY.getMsg());
            return result;
        }
        JSONObject jsonObject = JSON.parseObject((String)messageBody);
        Long sysBrandId = jsonObject.getLong("sysBrandId");
        if (sysBrandId == null) {
            log.error(this.getClass().getName() + "sysBrandId:\u54c1\u724cid\u5185\u5bb9\u4e3a\u7a7a");
            result.setCode(SysResponseEnum.FAILED.getCode());
            result.setMessage("\u54c1\u724cid\u5185\u5bb9\u4e3a\u7a7a");
            return result;
        }
        String sysCompanyId = jsonObject.getString("sysCompanyId");
        if (sysCompanyId == null) {
            log.error(this.getClass().getName() + "sysCompanyId:\u4f01\u4e1aid\u5185\u5bb9\u4e3a\u7a7a");
            result.setCode(SysResponseEnum.FAILED.getCode());
            result.setMessage("\u4f01\u4e1aid\u5185\u5bb9\u4e3a\u7a7a");
            return result;
        }
        String topic = jsonObject.getString("topic");
        if (StringUtils.isBlank((CharSequence)topic)) {
            log.error("StandardRocketMQSendSmsServiceImpl\ttopic\u4e0d\u80fd\u4e3a\u7a7a");
            result.setCode(SysRespConstants.ROCKET_MQ_TOPIC_NOT_EMPTY.getStatus());
            result.setMessage(SysRespConstants.ROCKET_MQ_TOPIC_NOT_EMPTY.getMsg());
            return result;
        }
        String tag = jsonObject.getString("tag");
        if (StringUtils.isBlank((CharSequence)tag)) {
            log.error("StandardRocketMQSendSmsServiceImpl\ttag\u4e0d\u80fd\u4e3a\u7a7a");
            result.setCode(SysRespConstants.ROCKET_MQ_TAG_NOT_EMPTY.getStatus());
            result.setMessage(SysRespConstants.ROCKET_MQ_TAG_NOT_EMPTY.getMsg());
            return result;
        }
        String phone = jsonObject.getString("phone");
        String phones = jsonObject.getString("phones");
        if (StringUtils.isBlank((CharSequence)phone) && StringUtils.isBlank((CharSequence)phones)) {
            log.error("StandardRocketMQSendSmsServiceImpl\t\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            result.setCode(SysResponseEnum.FAILED.getCode());
            result.setMessage("\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return result;
        }
        String memberOnlineServiceStoreCode = jsonObject.getString("memberOnlineServiceStoreCode");
        String memberOnlineServiceStoreCodes = jsonObject.getString("memberOnlineServiceStoreCodes");
        if (StringUtils.isBlank((CharSequence)memberOnlineServiceStoreCode) && StringUtils.isBlank((CharSequence)memberOnlineServiceStoreCodes)) {
            log.error(this.getClass().getName() + "memberOnlineServiceStoreCode:\u4f1a\u5458\u7684\u7ebf\u4e0a\u6240\u5c5e\u95e8\u5e97code\u4e3a\u7a7a");
            result.setCode(SysResponseEnum.FAILED.getCode());
            result.setMessage("\u4f1a\u5458\u7684\u7ebf\u4e0a\u6240\u5c5e\u95e8\u5e97code\u4e3a\u7a7a");
            return result;
        }
        SendResult sendResult = this.rocketMQTemplate.send(Destination.builder().topic(topic).tag(tag).build(), (Object)messageBody);
        String messageId = sendResult.getMsgId();
        result.setData((Object)messageId);
        result.setMessage(SysRespConstants.SUCCESS.getMsg());
        log.info("topic:{}.tag:{}", (Object)topic, (Object)tag);
        log.info("StandardRocketMQSendSmsServiceImpl\t\u6d88\u606f\u53d1\u9001\u5b8c\u6210mq\u8fd4\u56de\u7684msgId:{},", (Object)messageId, (Object)sendResult);
        return result;
    }
}

