/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.sms.controller;

import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.message.mappers.MsgSmsTempPOMapper;
import com.bizvane.messagebase.common.constants.ResponseData;
import com.bizvane.messagebase.common.constants.SysResponseEnum;
import com.bizvane.messagebase.model.po.MsgSmsTempPO;
import com.bizvane.messagebase.model.po.MsgSmsTempPOExample;
import com.bizvane.messagebase.model.vo.StandardMessageVo;
import com.bizvane.sms.service.StandardRocketMQSendSmsService;
import com.bizvane.sms.service.VerificationCodeMessageService;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/standardMessage"})
public class StandardMessageController {
    private static final Logger log = LoggerFactory.getLogger(StandardMessageController.class);
    @Autowired
    private StandardRocketMQSendSmsService standardRocketMQSendSmsService;
    @Autowired
    private MsgSmsTempPOMapper msgSmsTempPOMapper;
    @Autowired
    private VerificationCodeMessageService validateCodeMessageService;
    @Autowired
    private RocketMQTemplate rocketMQTemplate;

    @PostMapping(value={"/sendSingleMessageImmediately"})
    public ResponseData<String> sendSingleMessageImmediately(@RequestBody StandardMessageVo vo) {
        log.info("sendSingleMessageImmediately param:{}", (Object)JSON.toJSONString((Object)vo));
        return this.validateCodeMessageService.send(vo);
    }

    @PostMapping(value={"/sendSingleMessage"})
    public ResponseData<String> sendSingleMessage(@RequestBody StandardMessageVo vo) {
        log.info("sendSingleMessage param:{}", (Object)JSON.toJSONString((Object)vo));
        JSONObject jsonObjectSms = JSONObject.parseObject((String)JSONObject.toJSONString((Object)vo));
        jsonObjectSms.put("topic", (Object)"public_bizvane_single_message");
        jsonObjectSms.put("tag", (Object)vo.getScene());
        jsonObjectSms.put("scene", (Object)vo.getScene());
        jsonObjectSms.put("msgId", (Object)vo.getMsgId());
        return this.standardRocketMQSendSmsService.sendMessage(jsonObjectSms.toJSONString());
    }

    @PostMapping(value={"/sendBatchMessage"})
    public ResponseData sendBatchMessage(@RequestBody StandardMessageVo vo) {
        log.info("sendBatchMessage param:{}", (Object)JSON.toJSONString((Object)vo));
        JSONObject jsonObjectSms = JSONObject.parseObject((String)JSONObject.toJSONString((Object)vo));
        jsonObjectSms.put("topic", (Object)"public_bizvane_batch_message");
        jsonObjectSms.put("tag", (Object)vo.getScene());
        jsonObjectSms.put("scene", (Object)vo.getScene());
        jsonObjectSms.put("msgId", (Object)vo.getMsgId());
        return this.standardRocketMQSendSmsService.sendMessage(jsonObjectSms.toJSONString());
    }

    @PostMapping(value={"/getTemplate"})
    public ResponseData<String> getTemplateByBrandIdAndTemType(@RequestParam Long sysCompanyId, @RequestParam Long sysBrandId, @RequestParam String templateType) {
        log.info("getTemplateByBrandIdAndTemType sysBrandId:{},templateType:{}", (Object)sysBrandId, (Object)templateType);
        MsgSmsTempPOExample msgSmsTempPOExample = new MsgSmsTempPOExample();
        msgSmsTempPOExample.createCriteria().andSysBrandIdEqualTo(sysBrandId).andTemplateTypeEqualTo(templateType).andValidEqualTo(Boolean.TRUE);
        List smsTempPOList = this.msgSmsTempPOMapper.selectByExample(msgSmsTempPOExample);
        ResponseData responseData = new ResponseData();
        if (CollectionUtils.isEmpty((Collection)smsTempPOList)) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setData(null);
            return responseData;
        }
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)((MsgSmsTempPO)smsTempPOList.get(0)).getContent());
        return responseData;
    }
}

