/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.util;

import com.bizvane.base.common.bean.ResultBean;
import com.bizvane.base.remote.dto.TemplateDto;
import com.bizvane.base.remote.service.IRemoteTemplateService;
import com.bizvane.centerstageservice.models.vo.SysMerchantSmsVo;
import com.bizvane.centerstageservice.rpc.SysMerchantSmsRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RemoteMessageOps {
    private static final Logger log = LoggerFactory.getLogger(RemoteMessageOps.class);
    @Autowired
    private IRemoteTemplateService remoteTemplateService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private SysMerchantSmsRpc sysMerchantSmsRpc;
    private String prefixKey = "remoteMessageOps";

    public TemplateDto queryTemplateDto(String merchantId, String channelType, String templateCode) {
        ResultBean resultBean = this.remoteTemplateService.queryTemplate(merchantId, channelType, templateCode);
        if (resultBean == null || !resultBean.getSuccess().booleanValue() || resultBean.getResult() == null) {
            log.warn("queryTemplateDto\u672a\u67e5\u8be2\u5230:merchantId:{},channelType:{},templateCode:{}", new Object[]{merchantId, channelType, templateCode});
            return null;
        }
        TemplateDto templateDto = (TemplateDto)resultBean.getResult();
        return templateDto;
    }

    public SysMerchantSmsVo querySysMerchantSmsVo(Long sysCompanyId, Long sysBrandId) {
        SysMerchantSmsVo merchantSmsVo = new SysMerchantSmsVo();
        merchantSmsVo.setSysCompanyId(sysCompanyId);
        merchantSmsVo.setSysBrandId(sysBrandId);
        ResponseData sysMerchantSmsVoResponseData = this.sysMerchantSmsRpc.getByCondition(merchantSmsVo);
        if (sysMerchantSmsVoResponseData == null || sysMerchantSmsVoResponseData.getCode() != SysResponseEnum.SUCCESS.getCode() || sysMerchantSmsVoResponseData.getData() == null) {
            log.error("\u67e5\u8be2\u5546\u6237\u53f7\u5931\u8d25:sysCompanyId:{},sysBrandId:{}", (Object)sysCompanyId, (Object)sysBrandId);
            return null;
        }
        SysMerchantSmsVo sysMerchantSmsVo = (SysMerchantSmsVo)sysMerchantSmsVoResponseData.getData();
        return sysMerchantSmsVo;
    }

    public SysMerchantSmsVo querySysMerchantSmsByMerchantId(Long sysCompanyId, Long sysBrandId, String merchantId) {
        SysMerchantSmsVo merchantSmsVo = new SysMerchantSmsVo();
        merchantSmsVo.setSysCompanyId(sysCompanyId);
        merchantSmsVo.setSysBrandId(sysBrandId);
        merchantSmsVo.setMerchantId(merchantId);
        ResponseData sysMerchantSmsVoResponseData = this.sysMerchantSmsRpc.getByCondition(merchantSmsVo);
        if (sysMerchantSmsVoResponseData == null || sysMerchantSmsVoResponseData.getCode() != SysResponseEnum.SUCCESS.getCode() || sysMerchantSmsVoResponseData.getData() == null) {
            log.error("\u67e5\u8be2\u5546\u6237\u53f7\u5931\u8d25:sysCompanyId:{},sysBrandId:{},merchantId:{}", new Object[]{sysCompanyId, sysBrandId, merchantId});
            return null;
        }
        SysMerchantSmsVo sysMerchantSmsVo = (SysMerchantSmsVo)sysMerchantSmsVoResponseData.getData();
        return sysMerchantSmsVo;
    }

    public SysMerchantSmsVo querySysMerchantSmsByMerchantId(String merchantId) {
        SysMerchantSmsVo merchantSmsVo = new SysMerchantSmsVo();
        merchantSmsVo.setMerchantId(merchantId);
        ResponseData sysMerchantSmsVoResponseData = this.sysMerchantSmsRpc.getByCondition(merchantSmsVo);
        if (sysMerchantSmsVoResponseData == null || sysMerchantSmsVoResponseData.getCode() != SysResponseEnum.SUCCESS.getCode() || sysMerchantSmsVoResponseData.getData() == null) {
            log.error("\u67e5\u8be2\u5546\u6237\u53f7\u5931\u8d25:merchantId:{}", (Object)merchantId);
            return null;
        }
        SysMerchantSmsVo sysMerchantSmsVo = (SysMerchantSmsVo)sysMerchantSmsVoResponseData.getData();
        return sysMerchantSmsVo;
    }
}

