/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.service.impl.wxtemplatemessage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.appletservice.models.bo.ObtainGraphicBo;
import com.bizvane.appletservice.rpc.GraphicTemplateServiceRpc;
import com.bizvane.message.service.WXTemplateMessageService;
import com.bizvane.message.service.WechatTuWenMessageLogService;
import com.bizvane.messagebase.common.constants.SysRespConstants;
import com.bizvane.messagebase.model.po.MsgWxTuWenPO;
import com.bizvane.messagefacade.models.vo.Result;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="wXTuWenTemplateMessageServiceImpl")
public class WXTuWenTemplateMessageServiceImpl
implements WXTemplateMessageService {
    private static final Logger logger = LoggerFactory.getLogger(WXTuWenTemplateMessageServiceImpl.class);
    @Autowired
    private WechatTuWenMessageLogService wechatTuWenMessageLogService;
    @Autowired
    private GraphicTemplateServiceRpc graphicTemplateServiceRpc;

    public Result<String> sendMessage(String rocketMsgId, String messageBody) {
        logger.info(this.getClass().getName() + ".sendMessage\u5165\u53c2\uff1a" + messageBody);
        Result result = new Result();
        if (StringUtils.isBlank((CharSequence)messageBody)) {
            logger.error(this.getClass().getName() + ".sendMessage\u5165\u53c2\u4e3a\u7a7a");
            return result;
        }
        JSONObject jsonObject = JSON.parseObject((String)messageBody);
        MsgWxTuWenPO msgWxTuWenPO = new MsgWxTuWenPO();
        msgWxTuWenPO.setSysCompanyId(jsonObject.getLong("sysCompanyId"));
        msgWxTuWenPO.setBrandId(jsonObject.getLong("brandId"));
        msgWxTuWenPO.setTaskId(jsonObject.getString("taskId"));
        msgWxTuWenPO.setMessageId(rocketMsgId);
        msgWxTuWenPO.setGroupName(jsonObject.getString("groupName"));
        msgWxTuWenPO.setHeadlTitle(jsonObject.getString("headlTitle"));
        msgWxTuWenPO.setMemberSum(jsonObject.getString("memberSum"));
        msgWxTuWenPO.setSendState("2");
        msgWxTuWenPO.setSendStateName("\u53d1\u9001\u4e2d");
        msgWxTuWenPO.setOpenId(jsonObject.getString("openIdS"));
        msgWxTuWenPO.setMediaId(jsonObject.getString("mediaId"));
        msgWxTuWenPO.setMsgType(jsonObject.getString("msgType"));
        msgWxTuWenPO.setSendIgnoreReprint(jsonObject.getString("sendIgnoreReprint"));
        msgWxTuWenPO.setDataBody(jsonObject.toJSONString());
        Result insertResult = this.wechatTuWenMessageLogService.insert(msgWxTuWenPO);
        String wechatMessageLogId = (String)insertResult.getData();
        Result sendResult = new Result();
        sendResult = this.sendMessage(wechatMessageLogId, msgWxTuWenPO);
        MsgWxTuWenPO updatePO = new MsgWxTuWenPO();
        updatePO.set_id(wechatMessageLogId);
        updatePO.setMessageId(wechatMessageLogId);
        updatePO.setMessageId(wechatMessageLogId);
        updatePO.setResultInfo(sendResult.getMsg());
        if (sendResult.getStatus() == 0L) {
            updatePO.setTaskIdData((String)sendResult.getData());
            updatePO.setSendState("0");
            updatePO.setSendStateName("\u53d1\u9001\u6210\u529f");
            updatePO.setSendYesSum(msgWxTuWenPO.getMemberSum());
            updatePO.setSendNotSum("0");
        } else {
            updatePO.setSendState("1");
            updatePO.setSendStateName("\u53d1\u9001\u5931\u8d25");
            updatePO.setSendYesSum("0");
            updatePO.setSendNotSum(msgWxTuWenPO.getMemberSum());
        }
        this.wechatTuWenMessageLogService.update(updatePO);
        return result;
    }

    public Result<String> sendMessage(String wechatMessageLogId, MsgWxTuWenPO msgWxTuWenPO) {
        Result result = new Result();
        try {
            ArrayList<String> openIdlsit = new ArrayList<String>();
            for (String openId : msgWxTuWenPO.getOpenId().split(",")) {
                openIdlsit.add(openId);
            }
            ObtainGraphicBo obtainGraphicBo = new ObtainGraphicBo();
            obtainGraphicBo.setBrandId(msgWxTuWenPO.getBrandId());
            obtainGraphicBo.setOpenId(openIdlsit);
            obtainGraphicBo.setMediaId(msgWxTuWenPO.getMediaId());
            obtainGraphicBo.setMsgType(msgWxTuWenPO.getMsgType());
            obtainGraphicBo.setSendIgnoreReprint(msgWxTuWenPO.getSendIgnoreReprint());
            logger.info(this.getClass().getName() + ".sendMessage\u53d1\u9001\u56fe\u6587\u6d88\u606f\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)obtainGraphicBo));
            ResponseData responseData = this.graphicTemplateServiceRpc.groupSending(obtainGraphicBo);
            logger.info(this.getClass().getName() + ".sendMessage\u53d1\u9001\u56fe\u6587\u6d88\u606f\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)responseData));
            if (responseData.getData() != null) {
                result.setStatus((long)SysRespConstants.SUCCESS.getStatus());
                result.setData((Object)responseData.getData().toString());
                result.setMsg(responseData.getMessage());
            } else {
                result.setStatus((long)SysRespConstants.FAILED.getStatus());
                result.setMsg(responseData.getMessage());
            }
        }
        catch (Exception e) {
            result.setStatus((long)SysRespConstants.FAILED.getStatus());
            result.setMsg("\u53d1\u9001\u5f02\u5e38" + e.getMessage());
        }
        return result;
    }
}

