/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.message.common.constants.SystemConstants;
import com.bizvane.message.common.utils.AsyncHttpUtil;
import com.bizvane.message.mappers.MsgWxTempPOMapper;
import com.bizvane.message.service.WxMessagetempService;
import com.bizvane.messagebase.common.constants.SysRespConstants;
import com.bizvane.messagebase.model.po.MsgWxTempPO;
import com.bizvane.messagebase.model.po.MsgWxTempPOExample;
import com.bizvane.messagefacade.models.vo.Result;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WxMessagetempServiceImpl
implements WxMessagetempService {
    private static final Logger log = LoggerFactory.getLogger(WxMessagetempServiceImpl.class);
    @Autowired
    private MsgWxTempPOMapper msgWxTempPOMapper;
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;

    public ResponseData<Object> getTemplateByType(Long sysBrandId, String businessType, String templateType) {
        ResponseData responseData = new ResponseData();
        MsgWxTempPOExample example = new MsgWxTempPOExample();
        List messageTempPOList = new ArrayList();
        if (templateType == null || StringUtils.isBlank((CharSequence)templateType)) {
            example.createCriteria().andSysBrandIdEqualTo(sysBrandId).andBusinessTypeEqualTo(businessType).andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE);
            messageTempPOList = this.msgWxTempPOMapper.selectByExample(example);
            responseData.setData(messageTempPOList);
            responseData.setCode(SysRespConstants.SUCCESS.getStatus());
        } else {
            example.createCriteria().andSysBrandIdEqualTo(sysBrandId).andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE).andTemplateTypeEqualTo(templateType);
            messageTempPOList = this.msgWxTempPOMapper.selectByExample(example);
            MsgWxTempPO messageTempPO = new MsgWxTempPO();
            if (CollectionUtils.isNotEmpty(messageTempPOList)) {
                messageTempPO = (MsgWxTempPO)messageTempPOList.get(0);
                responseData.setCode(SysRespConstants.SUCCESS.getStatus());
            }
            responseData.setData((Object)messageTempPO);
        }
        return responseData;
    }

    public ResponseData<Object> getWxTemplateState(Long sysBrandId) {
        ResponseData responseData = new ResponseData();
        if (sysBrandId == null) {
            responseData.setCode(SysRespConstants.FAILED.getStatus());
            responseData.setMessage("\u54c1\u724c\u4e0d\u80fd\u662f\u7a7a\uff01");
            return responseData;
        }
        ResponseData publicPO = this.wxPublicServiceFeign.getWxPublicBySysBrandId(sysBrandId);
        if (publicPO.getData() == null) {
            responseData.setCode(SysRespConstants.FAILED.getStatus());
            responseData.setMessage("WxPublicPO\u662f\u7a7a:" + sysBrandId);
            return responseData;
        }
        ResponseData Stringkey = this.wxPublicServiceFeign.getAccessTokenByAppId(((WxPublicPO)publicPO.getData()).getAppid());
        if (Stringkey.getCode() != SysRespConstants.SUCCESS.getStatus()) {
            responseData.setCode(SysRespConstants.FAILED.getStatus());
            responseData.setMessage("getAppidREE:" + ((WxPublicPO)publicPO.getData()).getAppid());
            return responseData;
        }
        String ACCESS_TOKEN = (String)Stringkey.getData();
        String sendResulttemp = AsyncHttpUtil.doPost((String)("https://api.weixin.qq.com/cgi-bin/template/get_all_private_template?access_token=" + ACCESS_TOKEN), (String)"");
        JSONObject jsonObject = JSONObject.parseObject((String)sendResulttemp);
        JSONArray json = JSONArray.parseArray((String)jsonObject.getString("template_list"));
        JSONObject templateIdJSon = new JSONObject();
        if (json.size() > 0) {
            for (int i = 0; i < json.size(); ++i) {
                JSONObject job = json.getJSONObject(i);
                templateIdJSon.put(job.getString("template_id"), (Object)job.getString("template_id"));
            }
        }
        MsgWxTempPOExample example = new MsgWxTempPOExample();
        example.createCriteria().andSysBrandIdEqualTo(sysBrandId);
        List msgWxTemplist = this.msgWxTempPOMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)msgWxTemplist)) {
            responseData.setMessage("\u5fae\u4fe1\u6240\u6709\u6a21\u677f-\u672a\u914d\u7f6e\uff01");
            return responseData;
        }
        JSONObject JSONObjectPO = new JSONObject();
        for (MsgWxTempPO msgWxTempPO : msgWxTemplist) {
            if (StringUtils.isBlank((CharSequence)templateIdJSon.getString(msgWxTempPO.getWxTemplateId()))) {
                this.msgWxTempPOMapper.deleteByPrimaryKey(msgWxTempPO.getWxMessageTempId());
                continue;
            }
            JSONObjectPO.put(msgWxTempPO.getTemplateType(), (Object)msgWxTempPO.getTemplateType());
        }
        StringBuffer message = new StringBuffer();
        if (JSONObjectPO.get((Object)"INTEGRAL_ADD") == null) {
            message.append("\u79ef\u5206\u5165\u8d26\u901a\u77e5-\u672a\u914d\u7f6e");
        }
        if (JSONObjectPO.get((Object)"INTEGRAL_USE") == null) {
            message.append(",\u79ef\u5206\u4f7f\u7528\u901a\u77e5-\u672a\u914d\u7f6e");
        }
        if (JSONObjectPO.get((Object)"COUPON_RECEIVE") == null) {
            message.append(",\u4f18\u60e0\u5238\u5165\u8d26\u901a\u77e5-\u672a\u914d\u7f6e");
        }
        if (JSONObjectPO.get((Object)"COUPON_EXPIRE") == null) {
            message.append(",\u4f18\u60e0\u5238\u8fc7\u671f\u901a\u77e5-\u672a\u914d\u7f6e");
        }
        if (JSONObjectPO.get((Object)"COUPON_USE") == null) {
            message.append(",\u4f18\u60e0\u5238\u4f7f\u7528\u901a\u77e5-\u672a\u914d\u7f6e");
        }
        if (JSONObjectPO.get((Object)"MEMEBER_REGISTER") == null) {
            message.append(",\u4f1a\u5458\u6ce8\u518c\u6210\u529f\u901a\u77e5-\u672a\u914d\u7f6e");
        }
        if (JSONObjectPO.get((Object)"MEMEBER_INVITE_REGISTER") == null) {
            message.append(",\u7ed1\u5b9a\u6210\u529f\u901a\u77e5-\u672a\u914d\u7f6e");
        }
        if (JSONObjectPO.get((Object)"MEMEBER_UPGRADE") == null) {
            message.append(",\u4f1a\u5458\u5347\u7ea7\u901a\u77e5-\u672a\u914d\u7f6e");
        }
        if (JSONObjectPO.get((Object)"MEMEBER_DOWNGRADE") == null) {
            message.append(",\u4f1a\u5458\u964d\u7ea7\u901a\u77e5-\u672a\u914d\u7f6e");
        }
        if (JSONObjectPO.get((Object)"ORDER_SHIP") == null) {
            message.append(",\u5546\u57ce\u53d1\u8d27\u901a\u77e5-\u672a\u914d\u7f6e");
        }
        if (JSONObjectPO.get((Object)"CHU_ZHI_GEN_WXTEMPLATE_MESSAGE") == null) {
            message.append(",\u50a8\u503c\u4f59\u989d\u53d8\u52a8\u6a21\u677f\u6d88\u606f\u63d0");
        }
        if (message.toString().equals("")) {
            message.append("\u68c0\u6d4b\u5fae\u4fe1\u6a21\u677f\u6d88\u606f\u914d\u7f6e\uff1a\u5168\u90e8\u6b63\u5e38\uff01");
        }
        responseData.setMessage(message.toString());
        return responseData;
    }

    public ResponseData<Object> updateMsgSmsTempById(MsgWxTempPO po) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysRespConstants.FAILED.getStatus());
        if (po.getBusinessType() == null || StringUtils.isBlank((CharSequence)po.getBusinessType().toString())) {
            responseData.setCode(SysRespConstants.SYSTEM_DATA_NOT_REPEAT.getStatus());
            responseData.setMessage("\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return responseData;
        }
        if (po.getTemplateType() == null || StringUtils.isBlank((CharSequence)po.getTemplateType().toString())) {
            responseData.setCode(SysRespConstants.SYSTEM_DATA_NOT_REPEAT.getStatus());
            responseData.setMessage("\u5fae\u4fe1\u6a21\u677f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return responseData;
        }
        if (po.getStatus() == null || StringUtils.isBlank((CharSequence)po.getStatus().toString())) {
            responseData.setCode(SysRespConstants.SYSTEM_DATA_NOT_REPEAT.getStatus());
            responseData.setMessage("\u77ed\u4fe1\u5f00\u542f\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        MsgWxTempPOExample example = new MsgWxTempPOExample();
        example.createCriteria().andSysBrandIdEqualTo(po.getSysBrandId()).andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE).andTemplateTypeEqualTo(po.getTemplateType());
        List messageTempPOList = this.msgWxTempPOMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty((Collection)messageTempPOList)) {
            po.setWxMessageTempId(((MsgWxTempPO)messageTempPOList.get(0)).getWxMessageTempId());
            po.setModifiedDate(new Date());
            int n = this.msgWxTempPOMapper.updateByPrimaryKeySelective(po);
        } else {
            po.setCreateDate(new Date());
            po.setValid(Boolean.valueOf(true));
            int n = this.msgWxTempPOMapper.insert(po);
        }
        responseData.setCode(SysRespConstants.SUCCESS.getStatus());
        responseData.setMessage(SysRespConstants.SUCCESS.getMsg());
        responseData.setData((Object)po);
        return responseData;
    }

    public ResponseData<Object> insert(MsgWxTempPO po) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysRespConstants.FAILED.getStatus());
        if (po.getBusinessType() == null || StringUtils.isBlank((CharSequence)po.getBusinessType().toString())) {
            responseData.setCode(SysRespConstants.SYSTEM_DATA_NOT_REPEAT.getStatus());
            responseData.setMessage("\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return responseData;
        }
        if (po.getTemplateType() == null || StringUtils.isBlank((CharSequence)po.getTemplateType().toString())) {
            responseData.setCode(SysRespConstants.SYSTEM_DATA_NOT_REPEAT.getStatus());
            responseData.setMessage("\u5fae\u4fe1\u6a21\u677f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return responseData;
        }
        if (po.getStatus() == null || StringUtils.isBlank((CharSequence)po.getStatus().toString())) {
            responseData.setCode(SysRespConstants.SYSTEM_DATA_NOT_REPEAT.getStatus());
            responseData.setMessage("\u77ed\u4fe1\u5f00\u542f\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        if (po.getUrl() == null || StringUtils.isBlank((CharSequence)po.getUrl().toString())) {
            responseData.setCode(SysRespConstants.SYSTEM_DATA_NOT_REPEAT.getStatus());
            responseData.setMessage("\u5fae\u4fe1\u6a21\u677f\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return responseData;
        }
        MsgWxTempPOExample example = new MsgWxTempPOExample();
        example.createCriteria().andSysBrandIdEqualTo(po.getSysBrandId()).andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE).andTemplateTypeEqualTo(po.getTemplateType());
        List messageTempPOList = this.msgWxTempPOMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty((Collection)messageTempPOList)) {
            responseData.setCode(SysRespConstants.SYSTEM_DATA_NOT_REPEAT.getStatus());
            responseData.setMessage("\u8be5\u54c1\u724c\u7684\u5fae\u4fe1\u6a21\u677f\u7c7b\u578b\u5df2\u7ecf\u5b58\u5728\uff01\u4e0d\u5141\u8bb8\u91cd\u590d");
            return responseData;
        }
        po.setCreateDate(new Date());
        po.setValid(Boolean.valueOf(true));
        int count = this.msgWxTempPOMapper.insert(po);
        if (count == 0) {
            responseData.setMessage(SysRespConstants.FAILED.getMsg());
        } else {
            responseData.setCode(SysRespConstants.SUCCESS.getStatus());
            responseData.setMessage(SysRespConstants.SUCCESS.getMsg());
        }
        responseData.setData((Object)po);
        return responseData;
    }

    public MsgWxTempPO findMessagetempPOByType(String type, Long wxPublicId) {
        MsgWxTempPOExample example = new MsgWxTempPOExample();
        example.createCriteria().andTemplateTypeEqualTo(type).andWxPublicIdEqualTo(wxPublicId);
        List list = this.msgWxTempPOMapper.selectByExample(example);
        MsgWxTempPO wxMessagetempPOWithBLOBs = null;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            wxMessagetempPOWithBLOBs = (MsgWxTempPO)list.get(0);
        }
        return wxMessagetempPOWithBLOBs;
    }

    public Result<MsgWxTempPO> findCanSendMessagetempPOByType(String type, Long wxPublicId) {
        Result result = new Result();
        MsgWxTempPO wxMessagetempPOWithBLOBs = this.findMessagetempPOByType(type, wxPublicId);
        if (wxMessagetempPOWithBLOBs == null) {
            result.setStatus((long)SysRespConstants.WX_MESSAGETEMP_NOT_EXISTS.getStatus());
            result.setMsg(SysRespConstants.WX_MESSAGETEMP_NOT_EXISTS.getMsg());
            return result;
        }
        if (!SystemConstants.WECHAT_TEMPLATE_SEND_STATE_YES.equals(wxMessagetempPOWithBLOBs.getStatus())) {
            result.setStatus((long)SysRespConstants.WX_MESSAGETEMP_STATE_NOT_SEND.getStatus());
            result.setMsg(SysRespConstants.WX_MESSAGETEMP_STATE_NOT_SEND.getMsg());
            return result;
        }
        result.setData((Object)wxMessagetempPOWithBLOBs);
        return result;
    }

    public List<MsgWxTempPO> findByPublicIdAndValid(Long wxPublicId, Boolean valid) {
        MsgWxTempPOExample example = new MsgWxTempPOExample();
        example.createCriteria().andWxPublicIdEqualTo(wxPublicId).andValidEqualTo(valid);
        List wxMessageTempPOList = this.msgWxTempPOMapper.selectByExample(example);
        return wxMessageTempPOList;
    }

    public List<MsgWxTempPO> findByIdStr(String temp_id_str) {
        List wxMessageTempPOList = this.msgWxTempPOMapper.findByIdStr(temp_id_str);
        return wxMessageTempPOList;
    }

    public void updateWxMessageTemp(MsgWxTempPO wxMessageTempPO, MsgWxTempPOExample example) {
        this.msgWxTempPOMapper.updateByExampleSelective(wxMessageTempPO, example);
    }

    public MsgWxTempPO findById(long wxMessageTempId) {
        MsgWxTempPO po = this.msgWxTempPOMapper.selectByPrimaryKey(Long.valueOf(wxMessageTempId));
        return po;
    }

    public List<MsgWxTempPO> findByExample(MsgWxTempPOExample example) {
        List list = this.msgWxTempPOMapper.selectByExample(example);
        return list;
    }

    public long findCountByTemplateIdAndPublicId(String template_id, long public_id) {
        MsgWxTempPOExample example = new MsgWxTempPOExample();
        example.createCriteria().andWxTemplateIdEqualTo(template_id).andWxPublicIdEqualTo(Long.valueOf(public_id));
        long count = this.msgWxTempPOMapper.countByExample(example);
        return count;
    }

    public long saveMessageTemp(MsgWxTempPO po) {
        long id = this.msgWxTempPOMapper.insertSelective(po);
        return id;
    }

    public int deleteById(long wxMessageTempId) {
        int val = this.msgWxTempPOMapper.deleteByPrimaryKey(Long.valueOf(wxMessageTempId));
        return val;
    }

    public int deleteByExample(MsgWxTempPOExample example) {
        int val = this.msgWxTempPOMapper.deleteByExample(example);
        return val;
    }

    public long findCountByShortCodeAndPublicId(String short_code, long public_id) {
        MsgWxTempPOExample example = new MsgWxTempPOExample();
        example.createCriteria().andShortCodeEqualTo(short_code).andWxPublicIdEqualTo(Long.valueOf(public_id));
        long count = this.msgWxTempPOMapper.countByExample(example);
        return count;
    }

    public Long findIdByShortCodeAndPublicId(String short_code, long public_id) {
        MsgWxTempPOExample example = new MsgWxTempPOExample();
        example.createCriteria().andShortCodeEqualTo(short_code).andWxPublicIdEqualTo(Long.valueOf(public_id));
        List po = this.msgWxTempPOMapper.selectByExample(example);
        if (null == po && po.size() == 0) {
            return null;
        }
        return ((MsgWxTempPO)po.get(0)).getWxMessageTempId();
    }

    public ResponseData<Object> updateWxMessageIsSend(Long wxMessageTempId, Boolean issendmessage) {
        ResponseData responseData = new ResponseData();
        MsgWxTempPO tempPO = new MsgWxTempPO();
        tempPO.setWxMessageTempId(wxMessageTempId);
        tempPO.setIssendmessage(issendmessage);
        int count = this.msgWxTempPOMapper.updateByPrimaryKeySelective(tempPO);
        responseData.setData((Object)count);
        return responseData;
    }

    public ResponseData<Object> updateWxMessageTempById(MsgWxTempPO msgWxTempPO) {
        ResponseData responseData = new ResponseData();
        int count = this.msgWxTempPOMapper.updateByPrimaryKeySelective(msgWxTempPO);
        responseData.setData((Object)count);
        return responseData;
    }

    public List<MsgWxTempPO> findByPublicIdAndShortCode(Long public_id, String opentm207128229) {
        MsgWxTempPOExample example = new MsgWxTempPOExample();
        example.createCriteria().andWxPublicIdEqualTo(public_id).andShortCodeEqualTo("opentm207128229");
        List poList = this.msgWxTempPOMapper.selectByExample(example);
        return poList;
    }

    public List<MsgWxTempPO> findByTypeAndPublicId(String templateMessageType, long wxPublicId) {
        MsgWxTempPOExample example = new MsgWxTempPOExample();
        example.createCriteria().andBusinessTypeEqualTo(templateMessageType).andWxPublicIdEqualTo(Long.valueOf(wxPublicId));
        List list = this.msgWxTempPOMapper.selectByExample(example);
        return list;
    }

    public List<MsgWxTempPO> findBypublicDiff(long public_id) {
        List poList = this.msgWxTempPOMapper.findBypublicDiff(public_id);
        return poList;
    }

    public ResponseData<Object> getTemplateByType(String businessType) {
        ResponseData responseData = new ResponseData();
        if (StringUtils.isBlank((CharSequence)businessType)) {
            responseData.setCode(SysRespConstants.SYSTEM_DATA_NOT_EMPTY.getStatus());
            responseData.setMessage(SysRespConstants.SYSTEM_DATA_NOT_EMPTY.getMsg());
            return responseData;
        }
        MsgWxTempPOExample example = new MsgWxTempPOExample();
        example.createCriteria().andBusinessTypeEqualTo(businessType).andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE);
        List messageTempPOList = this.msgWxTempPOMapper.selectByExample(example);
        MsgWxTempPO messageTempPO = null;
        if (CollectionUtils.isNotEmpty((Collection)messageTempPOList)) {
            messageTempPO = (MsgWxTempPO)messageTempPOList.get(0);
        }
        responseData.setData(messageTempPO);
        return responseData;
    }
}

