/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.service.impl;

import com.bizvane.message.common.constants.SystemConstants;
import com.bizvane.message.mappers.MsgMenuPlaceHolderRelPOMapper;
import com.bizvane.message.mappers.MsgSmsTempPOMapper;
import com.bizvane.message.service.MsgSmsTempService;
import com.bizvane.messagebase.common.constants.SysRespConstants;
import com.bizvane.messagebase.model.po.MsgMenuPlaceHolderRelPO;
import com.bizvane.messagebase.model.po.MsgSmsTempPO;
import com.bizvane.messagebase.model.po.MsgSmsTempPOExample;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MsgSmsTempServiceImpl
implements MsgSmsTempService {
    @Autowired
    private MsgSmsTempPOMapper msgSmsTempPOMapper;
    @Autowired
    private MsgMenuPlaceHolderRelPOMapper msgMenuPlaceHolderRelPOMapper;

    public ResponseData<Object> getTemplateByType(Long sysBrandId, String businessType, String templateType) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysRespConstants.FAILED.getStatus());
        MsgSmsTempPOExample example = new MsgSmsTempPOExample();
        List messageTempPOList = new ArrayList();
        if (templateType == null || StringUtils.isBlank((CharSequence)templateType)) {
            example.createCriteria().andSysBrandIdEqualTo(sysBrandId).andBusinessTypeEqualTo(businessType).andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE);
            messageTempPOList = this.msgSmsTempPOMapper.selectByExample(example);
            responseData.setData(messageTempPOList);
            responseData.setCode(SysRespConstants.SUCCESS.getStatus());
        } else {
            example.createCriteria().andSysBrandIdEqualTo(sysBrandId).andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE).andTemplateTypeEqualTo(templateType);
            messageTempPOList = this.msgSmsTempPOMapper.selectByExample(example);
            MsgSmsTempPO messageTempPO = new MsgSmsTempPO();
            if (CollectionUtils.isNotEmpty(messageTempPOList)) {
                messageTempPO = (MsgSmsTempPO)messageTempPOList.get(0);
                responseData.setCode(SysRespConstants.SUCCESS.getStatus());
                responseData.setData((Object)messageTempPO);
            } else {
                responseData.setData(messageTempPOList);
            }
        }
        return responseData;
    }

    public ResponseData<List<MsgSmsTempPO>> getQyTemplateByType(Long sysBrandId, String businessType, String templateType) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysRespConstants.FAILED.getStatus());
        MsgSmsTempPOExample example = new MsgSmsTempPOExample();
        List messageTempPOList = new ArrayList();
        example.createCriteria().andSysBrandIdEqualTo(sysBrandId).andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE).andBusinessTypeEqualTo(businessType);
        messageTempPOList = this.msgSmsTempPOMapper.selectByExample(example);
        responseData.setData(messageTempPOList);
        return responseData;
    }

    public ResponseData<Object> findBytemplateType(String templateType) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysRespConstants.FAILED.getStatus());
        if (StringUtils.isBlank((CharSequence)templateType)) {
            responseData.setCode(SysRespConstants.SYSTEM_DATA_NOT_EMPTY.getStatus());
            responseData.setMessage(SysRespConstants.SYSTEM_DATA_NOT_EMPTY.getMsg());
            return responseData;
        }
        List messageTempPOList = this.msgMenuPlaceHolderRelPOMapper.findBytemplateType(templateType);
        ArrayList<String> namelist = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)messageTempPOList)) {
            for (MsgMenuPlaceHolderRelPO msgMenuPlaceHolderRelPO : messageTempPOList) {
                namelist.add(msgMenuPlaceHolderRelPO.getMenuName());
            }
            namelist.add("\u81ea\u5b9a\u4e49\u6587\u672c");
            responseData.setCode(SysRespConstants.SUCCESS.getStatus());
            responseData.setData(namelist);
            return responseData;
        }
        responseData.setData(null);
        return responseData;
    }

    public ResponseData<Object> updateMsgSmsTempById(MsgSmsTempPO po) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysRespConstants.FAILED.getStatus());
        if (po.getBusinessType() == null || StringUtils.isBlank((CharSequence)po.getBusinessType().toString())) {
            responseData.setCode(SysRespConstants.SYSTEM_DATA_NOT_REPEAT.getStatus());
            responseData.setMessage("\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return responseData;
        }
        if (po.getTemplateType() == null || StringUtils.isBlank((CharSequence)po.getTemplateType().toString())) {
            responseData.setCode(SysRespConstants.SYSTEM_DATA_NOT_REPEAT.getStatus());
            responseData.setMessage("\u77ed\u4fe1\u6a21\u677f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return responseData;
        }
        if (po.getStatus() == null || StringUtils.isBlank((CharSequence)po.getStatus().toString())) {
            responseData.setCode(SysRespConstants.SYSTEM_DATA_NOT_REPEAT.getStatus());
            responseData.setMessage("\u77ed\u4fe1\u5f00\u542f\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        if (po.getContent() == null || StringUtils.isBlank((CharSequence)po.getContent().toString())) {
            responseData.setCode(SysRespConstants.SYSTEM_DATA_NOT_REPEAT.getStatus());
            responseData.setMessage("\u77ed\u4fe1\u6a21\u677f\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return responseData;
        }
        if (po.getSendWxmember() == null || StringUtils.isBlank((CharSequence)po.getSendWxmember().toString())) {
            responseData.setCode(SysRespConstants.SYSTEM_DATA_NOT_REPEAT.getStatus());
            responseData.setMessage("0.\u5168\u90e8\u53d1\u9001 1.\u5411\u5fae\u4fe1\u4f1a\u5458\u53d1\u9001\u77ed\u4fe12.\u5411\u975e\u5fae\u4fe1\u4f1a\u5458\u53d1\u9001\u77ed\u4fe1,\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return responseData;
        }
        if (po.getMsgSmsTempId() == null || StringUtils.isBlank((CharSequence)po.getMsgSmsTempId().toString())) {
            responseData.setCode(SysRespConstants.SYSTEM_DATA_NOT_REPEAT.getStatus());
            responseData.setMessage("msgSmsTempId\u4e3b\u952eID\u4e0d\u80fd\u662f\u7a7a\uff01");
            return responseData;
        }
        MsgSmsTempPOExample example = new MsgSmsTempPOExample();
        example.createCriteria().andSysBrandIdEqualTo(po.getSysBrandId()).andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE).andTemplateTypeEqualTo(po.getTemplateType());
        List messageTempPOList = this.msgSmsTempPOMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty((Collection)messageTempPOList) && !((MsgSmsTempPO)messageTempPOList.get(0)).getMsgSmsTempId().equals(po.getMsgSmsTempId())) {
            responseData.setCode(SysRespConstants.SYSTEM_DATA_NOT_REPEAT.getStatus());
            responseData.setMessage("\u8be5\u54c1\u724c\u7684\u77ed\u4fe1\u6a21\u677f\u7c7b\u578b\u5df2\u7ecf\u5b58\u5728\uff01\u4e0d\u5141\u8bb8\u91cd\u590d");
            return responseData;
        }
        po.setModifiedDate(new Date());
        int count = this.msgSmsTempPOMapper.updateByPrimaryKeySelective(po);
        if (count == 0) {
            responseData.setCode(SysRespConstants.FAILED.getStatus());
            responseData.setMessage(SysRespConstants.FAILED.getMsg());
        } else {
            responseData.setCode(SysRespConstants.SUCCESS.getStatus());
            responseData.setMessage(SysRespConstants.SUCCESS.getMsg());
        }
        responseData.setData((Object)po);
        return responseData;
    }

    public ResponseData<Object> insert(MsgSmsTempPO po) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysRespConstants.FAILED.getStatus());
        if (po.getBusinessType() == null || StringUtils.isBlank((CharSequence)po.getBusinessType().toString())) {
            responseData.setCode(SysRespConstants.SYSTEM_DATA_NOT_REPEAT.getStatus());
            responseData.setMessage("\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return responseData;
        }
        if (po.getTemplateType() == null || StringUtils.isBlank((CharSequence)po.getTemplateType().toString())) {
            responseData.setCode(SysRespConstants.SYSTEM_DATA_NOT_REPEAT.getStatus());
            responseData.setMessage("\u77ed\u4fe1\u6a21\u677f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return responseData;
        }
        if (po.getStatus() == null || StringUtils.isBlank((CharSequence)po.getStatus().toString())) {
            responseData.setCode(SysRespConstants.SYSTEM_DATA_NOT_REPEAT.getStatus());
            responseData.setMessage("\u77ed\u4fe1\u5f00\u542f\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        if (po.getContent() == null || StringUtils.isBlank((CharSequence)po.getContent().toString())) {
            responseData.setCode(SysRespConstants.SYSTEM_DATA_NOT_REPEAT.getStatus());
            responseData.setMessage("\u77ed\u4fe1\u6a21\u677f\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return responseData;
        }
        if (po.getSendWxmember() == null || StringUtils.isBlank((CharSequence)po.getSendWxmember().toString())) {
            responseData.setCode(SysRespConstants.SYSTEM_DATA_NOT_REPEAT.getStatus());
            responseData.setMessage("0.\u5168\u90e8\u53d1\u9001 1.\u5411\u5fae\u4fe1\u4f1a\u5458\u53d1\u9001\u77ed\u4fe12.\u5411\u975e\u5fae\u4fe1\u4f1a\u5458\u53d1\u9001\u77ed\u4fe1,\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return responseData;
        }
        MsgSmsTempPOExample example = new MsgSmsTempPOExample();
        example.createCriteria().andSysBrandIdEqualTo(po.getSysBrandId()).andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE).andTemplateTypeEqualTo(po.getTemplateType());
        List messageTempPOList = this.msgSmsTempPOMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty((Collection)messageTempPOList)) {
            responseData.setMessage("\u8be5\u54c1\u724c\u7684\u77ed\u4fe1\u6a21\u677f\u7c7b\u578b\u5df2\u7ecf\u5b58\u5728\uff01\u4e0d\u5141\u8bb8\u91cd\u590d");
            return responseData;
        }
        po.setCreateDate(new Date());
        int count = this.msgSmsTempPOMapper.insert(po);
        if (count == 0) {
            responseData.setMessage(SysRespConstants.FAILED.getMsg());
        } else {
            responseData.setCode(SysRespConstants.SUCCESS.getStatus());
            responseData.setMessage(SysRespConstants.SUCCESS.getMsg());
        }
        responseData.setData((Object)po);
        return responseData;
    }
}

