/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.service.Standard.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.message.mappers.SysSmsConfigPOMapper;
import com.bizvane.message.service.Standard.VerificationCodeMessageService;
import com.bizvane.message.service.Standard.baseProcess.MessageBaseProcess;
import com.bizvane.message.service.impl.centerMsg.SendCommonMessageImpl;
import com.bizvane.messagebase.model.po.SysSmsConfigPOExample;
import com.bizvane.messagebase.model.vo.StandardMessageVo;
import com.bizvane.messagefacade.models.vo.SysSmsConfigVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class VerificationCodeMessageServiceImpl
extends MessageBaseProcess
implements VerificationCodeMessageService {
    private static final Logger log = LoggerFactory.getLogger(VerificationCodeMessageServiceImpl.class);
    @Autowired
    private SysSmsConfigPOMapper sysSmsConfigPOMapper;
    @Autowired
    private SendCommonMessageImpl sendCommonMessage;
    @Value(value="${smsdefaultaccountinfo.channelName}")
    private String channelName;
    @Value(value="${smsdefaultaccountinfo.channelService}")
    private String channelService;
    @Value(value="${smsdefaultaccountinfo.channelAccount}")
    private String channelAccount;
    @Value(value="${smsdefaultaccountinfo.channelPassword}")
    private String channelPassword;

    public ResponseData<String> send(StandardMessageVo standardMessageVo) {
        return super.send(JSON.toJSONString((Object)standardMessageVo));
    }

    public ResponseData<String> notNullCheck(String str) {
        return super.notNullCheckCommon(str);
    }

    public ResponseData<String> templateExistCheck(String str) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)str);
        return responseData;
    }

    public ResponseData<SysSmsConfigVO> channelExistCheck(String str) {
        ResponseData responseData = new ResponseData();
        JSONObject jsonObject = JSON.parseObject((String)str);
        Long sysBrandId = jsonObject.getLong("sysBrandId");
        String msgContent = jsonObject.getString("msgContent");
        SysSmsConfigPOExample sysSmsConfigPOExample = new SysSmsConfigPOExample();
        sysSmsConfigPOExample.createCriteria().andSysBrandIdEqualTo(sysBrandId).andChannelTypeEqualTo(Integer.valueOf(20)).andValidEqualTo(Boolean.TRUE);
        List sysSmsConfigList = this.sysSmsConfigPOMapper.selectByExample(sysSmsConfigPOExample);
        if (CollectionUtils.isNotEmpty((Collection)sysSmsConfigList)) {
            ObjectMapper mapper = new ObjectMapper();
            SysSmsConfigVO sysSmsConfigVO = (SysSmsConfigVO)mapper.convertValue(sysSmsConfigList.get(0), SysSmsConfigVO.class);
            sysSmsConfigVO.setMsgContent(msgContent);
            sysSmsConfigVO.setPhone(jsonObject.getString("phone"));
            responseData.setData((Object)sysSmsConfigVO);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        } else {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u54c1\u724cid:" + sysBrandId + "\u672a\u627e\u5230\u77ed\u4fe1\u901a\u9053\u4fe1\u606f");
        }
        return responseData;
    }

    public ResponseData<String> harassCheck(String str) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        return responseData;
    }

    public ResponseData<Integer> sendMessage(SysSmsConfigVO vo) {
        return this.sendCommonMessage.sendSmg(vo);
    }

    public ResponseData<String> insertRecord(String str) {
        return super.insertRecordCommon(str);
    }

    public void updateRecord(ResponseData<Integer> integerResponseData, String msgSmsRecordIds, int sendCount) {
        super.updateRecordCommon(integerResponseData, msgSmsRecordIds, sendCount);
    }

    public void insertMongo(ResponseData<Integer> integerResponseData, String str) {
        super.insertMongoCommon(integerResponseData, str);
    }
}

