/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.service.impl.wxtemplatemessage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.members.facade.models.WxChannelInfoModel;
import com.bizvane.members.facade.service.api.WxChannelInfoApiService;
import com.bizvane.members.facade.vo.WxChannelInfoVo;
import com.bizvane.members.facade.vo.WxChannelRelationVo;
import com.bizvane.message.common.utils.DictHelper;
import com.bizvane.message.service.WXTemplateMessageService;
import com.bizvane.message.service.WechatMessageLogService;
import com.bizvane.message.template.UseTemplate;
import com.bizvane.messagebase.common.constants.SysRespConstants;
import com.bizvane.messagebase.model.po.MsgWxLogPO;
import com.bizvane.messagefacade.models.vo.Result;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="wXTemplateMessageOfflineInfoServiceImpl")
public class WXTemplateMessageOfflineInfoServiceImpl
implements WXTemplateMessageService {
    private static final Logger logger = LoggerFactory.getLogger(WXTemplateMessageOfflineInfoServiceImpl.class);
    @Autowired
    private WechatMessageLogService wechatMessageLogService;
    @Autowired
    private WxChannelInfoApiService wxChannelInfoApiService;
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;

    public Result<String> sendMessage(String rocketMsgId, String messageBody) {
        logger.info(this.getClass().getName() + ".sendMessage\u5165\u53c2\uff1a" + messageBody);
        Result result = new Result();
        if (StringUtils.isBlank((CharSequence)messageBody)) {
            logger.error(this.getClass().getName() + ".sendMessage\u5165\u53c2\u4e3a\u7a7a");
            return result;
        }
        JSONObject jsonObject = JSON.parseObject((String)messageBody);
        String bussinessId = jsonObject.getString("rocketMQBussinessId");
        MsgWxLogPO insertPO = new MsgWxLogPO();
        insertPO.setTemplateType(jsonObject.getString("bussinessModuleCode"));
        insertPO.setTemplateTypeName(DictHelper.getDict((String)"template_type_wechat", (String)jsonObject.getString("bussinessModuleCode")).getItemCodeName());
        insertPO.setRocketMsgId(rocketMsgId);
        insertPO.setResultInfo("\u53d1\u9001\u4e2d");
        if (!StringUtils.isBlank((CharSequence)jsonObject.getString("sysBrandId"))) {
            insertPO.setSysBrandId(jsonObject.getLong("sysBrandId"));
        }
        if (!StringUtils.isBlank((CharSequence)jsonObject.getString("memberPhone"))) {
            insertPO.setMemberPhone(jsonObject.getString("memberPhone"));
        }
        insertPO.setBussinessId(bussinessId);
        insertPO.setDataBody(messageBody);
        Result insertResult = this.wechatMessageLogService.insert(insertPO);
        String wechatMessageLogId = (String)insertResult.getData();
        Result sendResult = null;
        sendResult = !StringUtils.isBlank((CharSequence)jsonObject.getString("openId")) ? this.sendDingXiangMessageHuoDong(wechatMessageLogId, jsonObject) : this.sendMessage(wechatMessageLogId, jsonObject);
        String messageId = null;
        String resultInfo = null;
        String sendState = "05";
        if ((long)SysRespConstants.SUCCESS.getStatus() == sendResult.getStatus()) {
            sendState = "10";
            resultInfo = (String)sendResult.getData();
            messageId = String.valueOf(JSON.parseObject((String)resultInfo).getLong("msgid"));
        } else {
            resultInfo = sendResult.getMsg();
        }
        MsgWxLogPO updatePO = new MsgWxLogPO();
        updatePO.set_id(wechatMessageLogId);
        updatePO.setMessageId(messageId);
        updatePO.setResultInfo(resultInfo);
        updatePO.setSendState(sendState);
        this.wechatMessageLogService.update(updatePO);
        return result;
    }

    public Result<String> sendDingXiangMessageHuoDong(String wechatMessageLogId, JSONObject jsonObject) {
        Result result = new Result();
        WxChannelInfoVo wxChannelInfoVo = new WxChannelInfoVo();
        String openId = jsonObject.getString("openId");
        wxChannelInfoVo.setWxOpenId(openId);
        ResponseData wxChannelInfoVonew = this.wxChannelInfoApiService.getWxChannelInfo(wxChannelInfoVo);
        if (null == wxChannelInfoVonew.getData()) {
            result.setStatus((long)SysRespConstants.WX_VIP_NOT_FOCUS.getStatus());
            result.setMsg(SysRespConstants.WX_VIP_NOT_FOCUS.getMsg());
            return result;
        }
        WxChannelInfoVo wxChannelInfoVip = (WxChannelInfoVo)wxChannelInfoVonew.getData();
        JSONObject messagejo = new JSONObject();
        messagejo.put("first", (Object)"\u60a8\u597d\uff0c\u60a8\u7684\u4e13\u5c5e\u5bfc\u8d2d\u7ed9\u60a8\u53d1\u4e86\u4e00\u6761\u6d88\u606f");
        messagejo.put("keyword1", (Object)"\u5728\u7ebf\u6c9f\u901a");
        messagejo.put("keyword2", (Object)"\u5f85\u786e\u8ba4");
        messagejo.put("remark", (Object)"\u8bf7\u70b9\u51fb\u67e5\u770b\u8be6\u60c5!");
        messagejo.put("url", (Object)jsonObject.getString("url"));
        for (String key : messagejo.keySet()) {
            String value = messagejo.getString(key);
            if (StringUtils.isBlank((CharSequence)value)) {
                value = " ";
            }
            messagejo.put(key, (Object)value);
        }
        logger.info("tempate message :" + messagejo.toString());
        MsgWxLogPO wechatMessageLogPO = new MsgWxLogPO();
        wechatMessageLogPO.set_id(wechatMessageLogId);
        wechatMessageLogPO.setWxPublicId(wxChannelInfoVip.getWxPublicId());
        wechatMessageLogPO.setOpenId(openId);
        wechatMessageLogPO.setMessageBody(messagejo.toString());
        String memberName = jsonObject.getString("memberName");
        wechatMessageLogPO.setMemberName(memberName);
        wechatMessageLogPO.setWxNick(wxChannelInfoVip.getWxNick());
        this.wechatMessageLogService.update(wechatMessageLogPO);
        WxPublicPO wxPublicPO = new WxPublicPO();
        wxPublicPO.setWxPublicId(wxChannelInfoVip.getWxPublicId());
        ResponseData Stringkey = this.wxPublicServiceFeign.getAccessTokenByAppId(wxChannelInfoVip.getAppId());
        wxPublicPO.setAppid((String)Stringkey.getData());
        return UseTemplate.sendMessage((WxPublicPO)wxPublicPO, (String)"OFFLINE_INFO", (String)openId, (JSONObject)messagejo);
    }

    public Result<String> sendMessage(String wechatMessageLogId, JSONObject jsonObject) {
        Result result = new Result();
        String memberCode = jsonObject.getString("memberCode");
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            result.setStatus((long)SysRespConstants.WX_MESSAGETEMP_USER_INFO_NOT_EMPTY.getStatus());
            result.setMsg(SysRespConstants.WX_MESSAGETEMP_USER_INFO_NOT_EMPTY.getMsg());
            return result;
        }
        Long sysCompanyId = jsonObject.getLongValue("sysCompanyId");
        Long brandId = jsonObject.getLongValue("sysBrandId");
        WxChannelRelationVo wxChannelRelationVo = new WxChannelRelationVo();
        wxChannelRelationVo.setMemberCode(memberCode);
        wxChannelRelationVo.setSysCompanyId(sysCompanyId);
        wxChannelRelationVo.setBrandId(brandId);
        wxChannelRelationVo.setMiniProgram(Integer.valueOf(1));
        ResponseData memberResult = this.wxChannelInfoApiService.getWxChannelInfoRelation(wxChannelRelationVo);
        WxChannelInfoModel wxChannelInfoVip = (WxChannelInfoModel)memberResult.getData();
        if (null == wxChannelInfoVip) {
            result.setStatus((long)SysRespConstants.WX_VIP_NOT_FOCUS.getStatus());
            result.setMsg(SysRespConstants.WX_VIP_NOT_FOCUS.getMsg());
            return result;
        }
        ObjectMapper mapper = new ObjectMapper();
        WxChannelInfoVo wxChannelInfoModel = new WxChannelInfoVo();
        wxChannelInfoModel.setMemberCode(memberCode);
        ResponseData channelResult = this.wxChannelInfoApiService.getWxChannelInfo(wxChannelInfoModel);
        WxChannelInfoVo channelInfoModel = (WxChannelInfoVo)channelResult.getData();
        WxChannelInfoVo channelVal = null;
        if (null != channelInfoModel) {
            channelVal = (WxChannelInfoVo)mapper.convertValue((Object)channelInfoModel, WxChannelInfoVo.class);
        }
        if (wxChannelInfoVip == null) {
            result.setStatus((long)SysRespConstants.WX_VIP_NOT_FOCUS.getStatus());
            result.setMsg(SysRespConstants.WX_VIP_NOT_FOCUS.getMsg());
            return result;
        }
        JSONObject messagejo = new JSONObject();
        messagejo.put("first", (Object)"\u60a8\u597d\uff0c\u60a8\u7684\u4e13\u5c5e\u5bfc\u8d2d\u7ed9\u60a8\u53d1\u4e86\u4e00\u6761\u6d88\u606f");
        messagejo.put("keyword1", (Object)"\u5728\u7ebf\u6c9f\u901a");
        messagejo.put("keyword2", (Object)"\u5f85\u786e\u8ba4");
        messagejo.put("remark", (Object)"\u8bf7\u70b9\u51fb\u67e5\u770b\u8be6\u60c5!");
        messagejo.put("url", (Object)jsonObject.getString("url"));
        for (String key : messagejo.keySet()) {
            String value = messagejo.getString(key);
            if (StringUtils.isBlank((CharSequence)value)) {
                value = " ";
            }
            messagejo.put(key, (Object)value);
        }
        logger.info("tempate message :" + messagejo.toString());
        String openId = wxChannelInfoVip.getOpenId();
        MsgWxLogPO wechatMessageLogPO = new MsgWxLogPO();
        wechatMessageLogPO.set_id(wechatMessageLogId);
        wechatMessageLogPO.setWxPublicId(wxChannelInfoVip.getPublicId());
        wechatMessageLogPO.setOpenId(openId);
        wechatMessageLogPO.setMessageBody(messagejo.toString());
        wechatMessageLogPO.setMemberName(channelInfoModel.getName());
        if (channelVal != null) {
            wechatMessageLogPO.setWxNick(channelVal.getWxNick());
        }
        this.wechatMessageLogService.update(wechatMessageLogPO);
        WxPublicPO wxPublicPO = new WxPublicPO();
        wxPublicPO.setWxPublicId(wxChannelInfoVip.getPublicId());
        ResponseData Stringkey = this.wxPublicServiceFeign.getAccessTokenByAppId(wxChannelInfoVip.getAppId());
        wxPublicPO.setAppid((String)Stringkey.getData());
        return UseTemplate.sendMessage((WxPublicPO)wxPublicPO, (String)"OFFLINE_INFO", (String)openId, (JSONObject)messagejo);
    }
}

