/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.mongo;

import com.bizvane.message.common.utils.PageForm;
import com.bizvane.message.mongo.BaseMongoDao;
import com.bizvane.messagebase.model.po.MsgWxTuWenPO;
import com.bizvane.messagefacade.models.vo.WechatMessageLogVO;
import com.bizvane.utils.responseinfo.PageInfo;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component
public class WechatTuWenLogPOMongoDao
extends BaseMongoDao<MsgWxTuWenPO> {
    public String saveRocketLogPO(MsgWxTuWenPO msgSmsTempPO) {
        MsgWxTuWenPO item = (MsgWxTuWenPO)super.insert((Object)msgSmsTempPO);
        return item.get_id();
    }

    public void updateRocketLogPO(MsgWxTuWenPO msgSmsTempPO) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)msgSmsTempPO.get_id()));
        super.update(query, (Object)msgSmsTempPO);
    }

    public static boolean isNumeric(String str) {
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public PageInfo<MsgWxTuWenPO> getRocketLogPOList(WechatMessageLogVO wechatMessageLogVO) {
        Criteria criteriabaseSysBrandId = new Criteria();
        Criteria criteria = new Criteria();
        Criteria headlTitle = new Criteria();
        Criteria groupName = new Criteria();
        Criteria criteriasendTimeStart = new Criteria();
        Criteria criteriasendTimeEnd = new Criteria();
        Criteria criteriaSearchValue = new Criteria();
        Criteria criteriaSearchStatistics = new Criteria();
        if (null == wechatMessageLogVO.getSysBrandId()) {
            PageInfo saveMsgWxTuWenPOList = new PageInfo();
            return saveMsgWxTuWenPOList;
        }
        criteriabaseSysBrandId = Criteria.where((String)"brandId").is((Object)wechatMessageLogVO.getSysBrandId());
        if (!StringUtils.isBlank((CharSequence)wechatMessageLogVO.getSearchValue())) {
            criteriaSearchValue.orOperator(new Criteria[]{Criteria.where((String)"headlTitle").is((Object)wechatMessageLogVO.getSearchValue()), Criteria.where((String)"groupName").is((Object)wechatMessageLogVO.getSearchValue())});
        }
        if (!StringUtils.isBlank((CharSequence)wechatMessageLogVO.getHeadlTitle())) {
            headlTitle = Criteria.where((String)"headlTitle").is((Object)wechatMessageLogVO.getHeadlTitle());
        }
        if (!StringUtils.isBlank((CharSequence)wechatMessageLogVO.getGroupName())) {
            groupName = Criteria.where((String)"groupName").is((Object)wechatMessageLogVO.getGroupName());
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            if (!StringUtils.isBlank((CharSequence)wechatMessageLogVO.getSendTimeStart())) {
                Date timeStart = format.parse(wechatMessageLogVO.getSendTimeStart());
                criteriasendTimeStart = Criteria.where((String)"createDate").gte((Object)timeStart);
            }
            if (!StringUtils.isBlank((CharSequence)wechatMessageLogVO.getSendTimeEnd())) {
                Date timeEnd = format.parse(wechatMessageLogVO.getSendTimeEnd());
                criteriasendTimeEnd = Criteria.where((String)"createDate").lte((Object)timeEnd);
            }
        }
        catch (Exception timeEnd) {
            // empty catch block
        }
        if (!StringUtils.isBlank((CharSequence)wechatMessageLogVO.getSendState())) {
            criteriaSearchStatistics = Criteria.where((String)"sendState").is((Object)wechatMessageLogVO.getSendState());
        }
        criteria.andOperator(new Criteria[]{criteriaSearchValue, criteriabaseSysBrandId, headlTitle, groupName, criteriaSearchStatistics, criteriasendTimeStart, criteriasendTimeEnd});
        Query findquery = new Query();
        findquery.addCriteria((CriteriaDefinition)criteria).with(new Sort(Sort.Direction.DESC, new String[]{"createDate"}));
        PageForm pageForm = new PageForm();
        pageForm.setPageNum(wechatMessageLogVO.getPageNumber());
        pageForm.setPageSize(wechatMessageLogVO.getPageSize());
        PageInfo MsgWxTuWenPOl = super.findPage(pageForm, findquery);
        return MsgWxTuWenPOl;
    }
}

