/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.service.impl.wxtemplatemessage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.members.facade.models.WxChannelInfoModel;
import com.bizvane.members.facade.service.api.WxChannelInfoApiService;
import com.bizvane.members.facade.vo.WxChannelInfoVo;
import com.bizvane.members.facade.vo.WxChannelRelationVo;
import com.bizvane.message.common.utils.DictHelper;
import com.bizvane.message.service.WXTemplateMessageService;
import com.bizvane.message.service.WechatMessageLogService;
import com.bizvane.message.template.UseTemplateNew;
import com.bizvane.messagebase.common.constants.SysRespConstants;
import com.bizvane.messagebase.model.po.MsgWxLogPO;
import com.bizvane.messagefacade.models.vo.IntegralMessageVO;
import com.bizvane.messagefacade.models.vo.Result;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="wXTemplateMessageIntegralUseServiceImpl")
public class WXTemplateMessageIntegralUseServiceImpl
implements WXTemplateMessageService {
    private static final Logger logger = LoggerFactory.getLogger(WXTemplateMessageIntegralUseServiceImpl.class);
    @Autowired
    private WechatMessageLogService wechatMessageLogService;
    @Autowired
    private WxChannelInfoApiService wxChannelInfoApiService;
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;

    public Result<String> sendMessage(String rocketMsgId, String messageBody) {
        logger.info(this.getClass().getName() + ".sendMessage\u5165\u53c2\uff1a" + messageBody);
        Result result = new Result();
        if (StringUtils.isBlank((CharSequence)messageBody)) {
            logger.error(this.getClass().getName() + ".sendMessage\u5165\u53c2\u4e3a\u7a7a");
            return result;
        }
        JSONObject jsonObject = JSON.parseObject((String)messageBody);
        String bussinessId = jsonObject.getString("rocketMQBussinessId");
        MsgWxLogPO insertPO = new MsgWxLogPO();
        insertPO.setTemplateType(jsonObject.getString("bussinessModuleCode"));
        insertPO.setTemplateTypeName(DictHelper.getDict((String)"template_type_wechat", (String)jsonObject.getString("bussinessModuleCode")).getItemCodeName());
        insertPO.setRocketMsgId(rocketMsgId);
        insertPO.setResultInfo("\u53d1\u9001\u4e2d");
        if (StringUtils.isNotBlank((CharSequence)jsonObject.getString("sysBrandId"))) {
            insertPO.setSysBrandId(jsonObject.getLong("sysBrandId"));
        }
        if (StringUtils.isNotBlank((CharSequence)jsonObject.getString("memberPhone"))) {
            insertPO.setMemberPhone(jsonObject.getString("memberPhone"));
        }
        insertPO.setBussinessId(bussinessId);
        insertPO.setDataBody(messageBody);
        Result insertResult = null;
        try {
            insertResult = this.wechatMessageLogService.insert(insertPO);
        }
        catch (Exception e) {
            logger.error("\u5199\u5165mongodb\u51fa\u9519");
            e.printStackTrace();
        }
        String wechatMessageLogId = (String)insertResult.getData();
        Result sendResult = this.sendMessage(wechatMessageLogId, jsonObject);
        String messageId = null;
        String resultInfo = null;
        String sendState = "05";
        if ((long)SysRespConstants.SUCCESS.getStatus() == sendResult.getStatus()) {
            sendState = "10";
            resultInfo = (String)sendResult.getData();
            messageId = String.valueOf(JSON.parseObject((String)resultInfo).getLong("msgid"));
        } else {
            resultInfo = sendResult.getMsg();
        }
        MsgWxLogPO updatePO = new MsgWxLogPO();
        updatePO.set_id(wechatMessageLogId);
        updatePO.setMessageId(messageId);
        updatePO.setResultInfo(resultInfo);
        updatePO.setSendState(sendState);
        this.wechatMessageLogService.update(updatePO);
        return result;
    }

    public Result<String> sendMessage(String wechatMessageLogId, JSONObject jsonObject) {
        Result result = new Result();
        String memberCode = jsonObject.getString("memberCode");
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            result.setStatus((long)SysRespConstants.WX_MESSAGETEMP_USER_INFO_NOT_EMPTY.getStatus());
            result.setMsg(SysRespConstants.WX_MESSAGETEMP_USER_INFO_NOT_EMPTY.getMsg());
            return result;
        }
        Long sysCompanyId = jsonObject.getLongValue("sysCompanyId");
        Long brandId = jsonObject.getLongValue("sysBrandId");
        WxChannelRelationVo wxChannelRelationVo = new WxChannelRelationVo();
        wxChannelRelationVo.setMemberCode(memberCode);
        wxChannelRelationVo.setSysCompanyId(sysCompanyId);
        wxChannelRelationVo.setBrandId(brandId);
        wxChannelRelationVo.setMiniProgram(Integer.valueOf(1));
        ResponseData memberResult = this.wxChannelInfoApiService.getWxChannelInfoRelation(wxChannelRelationVo);
        WxChannelInfoModel wxChannelInfoVip = (WxChannelInfoModel)memberResult.getData();
        if (null == wxChannelInfoVip) {
            logger.error("wxChannelInfoApiService.getWxChannelInfoRelation,\u672a\u67e5\u8be2\u5230\u8bb0\u5f55,\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)wxChannelRelationVo));
            result.setStatus((long)SysRespConstants.WX_VIP_NOT_FOCUS.getStatus());
            result.setMsg(SysRespConstants.WX_VIP_NOT_FOCUS.getMsg());
            return result;
        }
        ObjectMapper mapper = new ObjectMapper();
        WxChannelInfoVo wxChannelInfoModel = new WxChannelInfoVo();
        wxChannelInfoModel.setMemberCode(memberCode);
        ResponseData channelResult = this.wxChannelInfoApiService.getWxChannelInfo(wxChannelInfoModel);
        WxChannelInfoVo channelInfoModel = (WxChannelInfoVo)channelResult.getData();
        WxChannelInfoVo channelVal = null;
        if (null != channelInfoModel) {
            channelVal = (WxChannelInfoVo)mapper.convertValue((Object)channelInfoModel, WxChannelInfoVo.class);
        }
        if (wxChannelInfoVip == null) {
            result.setStatus((long)SysRespConstants.WX_VIP_NOT_FOCUS.getStatus());
            result.setMsg(SysRespConstants.WX_VIP_NOT_FOCUS.getMsg());
            return result;
        }
        JSONObject messagejo = new JSONObject();
        IntegralMessageVO integralMessageVO = (IntegralMessageVO)jsonObject.toJavaObject(IntegralMessageVO.class);
        messagejo.put("first", (Object)"\u5c0a\u656c\u7684\u4f1a\u5458\uff0c\u60a8\u6709\u4e00\u7b14\u79ef\u5206\u521a\u88ab\u4f7f\u7528\u3002");
        messagejo.put("keyword1", (Object)("-" + integralMessageVO.getUseIntegral()));
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        messagejo.put("keyword2", (Object)formatter.format(new Date()));
        messagejo.put("remark", (Object)"\u611f\u8c22\u60a8\u7684\u652f\u6301!");
        Date tasktime = jsonObject.getDate("changeDate");
        SimpleDateFormat formatterA = new SimpleDateFormat("yyyy-MM-dd");
        if (tasktime == null) {
            result.setStatus((long)SysRespConstants.DATA_NOT_TOTAY.getStatus());
            result.setMsg(SysRespConstants.DATA_NOT_TOTAY.getMsg());
            return result;
        }
        String data = formatterA.format(new Date());
        if (!data.equals(formatterA.format(tasktime))) {
            result.setStatus((long)SysRespConstants.DATA_NOT_TOTAY.getStatus());
            result.setMsg(SysRespConstants.DATA_NOT_TOTAY.getMsg());
            return result;
        }
        for (String key : messagejo.keySet()) {
            String value = messagejo.getString(key);
            if (StringUtils.isBlank((CharSequence)value)) {
                value = " ";
            }
            messagejo.put(key, (Object)value);
        }
        logger.info("tempate message :" + messagejo.toString());
        String openId = wxChannelInfoVip.getOpenId();
        MsgWxLogPO wechatMessageLogPO = new MsgWxLogPO();
        wechatMessageLogPO.set_id(wechatMessageLogId);
        wechatMessageLogPO.setWxPublicId(wxChannelInfoVip.getPublicId());
        wechatMessageLogPO.setOpenId(openId);
        wechatMessageLogPO.setMessageBody(messagejo.toString());
        wechatMessageLogPO.setMemberName(channelInfoModel.getName());
        if (channelVal != null) {
            wechatMessageLogPO.setWxNick(channelVal.getWxNick());
        }
        this.wechatMessageLogService.update(wechatMessageLogPO);
        WxPublicPO wxPublicPO = new WxPublicPO();
        wxPublicPO.setWxPublicId(wxChannelInfoVip.getPublicId());
        ResponseData Stringkey = this.wxPublicServiceFeign.getAccessTokenByAppId(wxChannelInfoVip.getAppId());
        wxPublicPO.setAppid((String)Stringkey.getData());
        messagejo.put("\u4f7f\u7528\u79ef\u5206\u6570\u989d", (Object)("-" + integralMessageVO.getUseIntegral()));
        messagejo.put("\u516c\u4f17\u53f7", (Object)integralMessageVO.getNickName());
        messagejo.put("\u4f1a\u5458\u59d3\u540d", (Object)integralMessageVO.getNickName());
        messagejo.put("\u79ef\u5206\u4f59\u989d", (Object)integralMessageVO.getNowIntegral());
        messagejo.put("\u79ef\u5206\u4f7f\u7528\u65f6\u95f4", (Object)formatter.format(new Date()));
        messagejo.put("\u4f1a\u5458\u5361\u53f7", (Object)integralMessageVO.getCardnumber());
        messagejo.put("\u53d8\u66f4\u7c7b\u578b", (Object)integralMessageVO.getBusinessDescription());
        messagejo.put("\u53d8\u52a8\u8be6\u60c5", (Object)(StringUtils.isNotBlank((CharSequence)integralMessageVO.getChangeDetails()) ? integralMessageVO.getChangeDetails() : ""));
        logger.info("WXTemplateMessageIntegralUseServiceImpl\u5f00\u59cb\u8c03\u7528UseTemplateNew.sendMessage");
        return UseTemplateNew.sendMessage((WxPublicPO)wxPublicPO, (String)"INTEGRAL_USE", (String)openId, (JSONObject)messagejo);
    }
}

