/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.service.impl.wxtemplatemessage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.members.facade.models.WxChannelInfoModel;
import com.bizvane.members.facade.service.api.WxChannelInfoApiService;
import com.bizvane.members.facade.vo.WxChannelAndMemberVo;
import com.bizvane.members.facade.vo.WxChannelInfoVo;
import com.bizvane.members.facade.vo.WxChannelRelationVo;
import com.bizvane.message.common.utils.DictHelper;
import com.bizvane.message.service.WXTemplateMessageService;
import com.bizvane.message.service.WechatMessageLogService;
import com.bizvane.message.template.UseTemplate;
import com.bizvane.message.template.UseTemplateNew;
import com.bizvane.messagebase.common.constants.SysRespConstants;
import com.bizvane.messagebase.model.po.MsgWxLogPO;
import com.bizvane.messagefacade.enums.MsgTemplateType;
import com.bizvane.messagefacade.models.vo.Result;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="wXGenTemplateMessageServiceImpl")
public class WXGenTemplateMessageServiceImpl
implements WXTemplateMessageService {
    private static final Logger logger = LoggerFactory.getLogger(WXGenTemplateMessageServiceImpl.class);
    @Autowired
    private WechatMessageLogService wechatMessageLogService;
    @Autowired
    private WxChannelInfoApiService wxChannelInfoApiService;
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;

    public Result<String> sendMessage(String rocketMsgId, String messageBody) {
        logger.info(this.getClass().getName() + ".sendMessage\u5165\u53c2\uff1a" + messageBody);
        Result result = new Result();
        if (StringUtils.isBlank((CharSequence)messageBody)) {
            logger.error(this.getClass().getName() + ".sendMessage\u5165\u53c2\u4e3a\u7a7a");
            return result;
        }
        JSONObject jsonObject = JSON.parseObject((String)messageBody);
        String bussinessId = jsonObject.getString("rocketMQBussinessId");
        MsgWxLogPO insertPO = new MsgWxLogPO();
        insertPO.setTemplateType(jsonObject.getString("templateType"));
        insertPO.setTemplateTypeName(DictHelper.getDict((String)"template_type_wechat", (String)jsonObject.getString("templateType")).getItemCodeName());
        insertPO.setRocketMsgId(rocketMsgId);
        insertPO.setResultInfo("\u53d1\u9001\u4e2d");
        if (!StringUtils.isBlank((CharSequence)jsonObject.getString("sysBrandId"))) {
            insertPO.setSysBrandId(jsonObject.getLong("sysBrandId"));
        }
        insertPO.setBussinessId(bussinessId);
        insertPO.setDataBody(messageBody);
        Result insertResult = this.wechatMessageLogService.insert(insertPO);
        String wechatMessageLogId = (String)insertResult.getData();
        Result sendResult = new Result();
        String memberCode = jsonObject.getString("memberCode");
        sendResult = StringUtils.isBlank((CharSequence)memberCode) ? this.sendMessageOpenId(wechatMessageLogId, jsonObject) : this.sendMessage(wechatMessageLogId, jsonObject);
        MsgWxLogPO updatePO = new MsgWxLogPO();
        updatePO.set_id(wechatMessageLogId);
        updatePO.setResultInfo(sendResult.getMsg());
        if ((long)SysRespConstants.SUCCESS.getStatus() == sendResult.getStatus()) {
            updatePO.setSendState("10");
            updatePO.setMessageId(String.valueOf(JSON.parseObject((String)((String)sendResult.getData())).getLong("msgid")));
        }
        WxChannelInfoVo channelVO = new WxChannelInfoVo();
        channelVO.setMemberCode(memberCode);
        channelVO.setBrandId(jsonObject.getLong("sysBrandId"));
        channelVO.setMiniProgram(Integer.valueOf(1));
        ResponseData channelResult = this.wxChannelInfoApiService.getWxChannelInfoAndMemberInfo(channelVO);
        WxChannelInfoVo channelInfoVo = null;
        if (channelResult.getData() != null) {
            channelInfoVo = ((WxChannelAndMemberVo)channelResult.getData()).getWxChannelInfoVo();
            updatePO.setMemberPhone(channelInfoVo.getPhone());
            updatePO.setMemberName(channelInfoVo.getName());
        }
        this.wechatMessageLogService.update(updatePO);
        return result;
    }

    public Result<String> sendMessage(String wechatMessageLogId, JSONObject jsonObject) {
        Result result = new Result();
        String memberCode = jsonObject.getString("memberCode");
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            result.setStatus((long)SysRespConstants.WX_MESSAGETEMP_USER_INFO_NOT_EMPTY.getStatus());
            result.setMsg(SysRespConstants.WX_MESSAGETEMP_USER_INFO_NOT_EMPTY.getMsg());
            return result;
        }
        Long sysCompanyId = jsonObject.getLongValue("sysCompanyId");
        Long brandId = jsonObject.getLongValue("sysBrandId");
        WxChannelRelationVo wxChannelRelationVo = new WxChannelRelationVo();
        wxChannelRelationVo.setMemberCode(memberCode);
        wxChannelRelationVo.setSysCompanyId(sysCompanyId);
        wxChannelRelationVo.setBrandId(brandId);
        wxChannelRelationVo.setMiniProgram(Integer.valueOf(1));
        ResponseData memberResult = this.wxChannelInfoApiService.getWxChannelInfoRelation(wxChannelRelationVo);
        WxChannelInfoModel wxChannelInfoVip = (WxChannelInfoModel)memberResult.getData();
        if (null == wxChannelInfoVip) {
            result.setStatus((long)SysRespConstants.WX_VIP_NOT_FOCUS.getStatus());
            result.setMsg(SysRespConstants.WX_VIP_NOT_FOCUS.getMsg());
            return result;
        }
        ObjectMapper mapper = new ObjectMapper();
        WxChannelInfoVo wxChannelInfoModel = new WxChannelInfoVo();
        wxChannelInfoModel.setMemberCode(memberCode);
        ResponseData channelResult = this.wxChannelInfoApiService.getWxChannelInfo(wxChannelInfoModel);
        WxChannelInfoVo channelInfoModel = (WxChannelInfoVo)channelResult.getData();
        WxChannelInfoVo channelVal = null;
        if (null != channelInfoModel) {
            channelVal = (WxChannelInfoVo)mapper.convertValue((Object)channelInfoModel, WxChannelInfoVo.class);
        }
        JSONObject messagejo = JSONObject.parseObject((String)jsonObject.getString("messagejo"));
        for (String key : messagejo.keySet()) {
            String value = messagejo.getString(key);
            if (StringUtils.isBlank((CharSequence)value)) {
                value = " ";
            }
            messagejo.put(key, (Object)value);
        }
        logger.info("tempate message :" + messagejo.toString());
        String openId = wxChannelInfoVip.getOpenId();
        MsgWxLogPO wechatMessageLogPO = new MsgWxLogPO();
        wechatMessageLogPO.set_id(wechatMessageLogId);
        wechatMessageLogPO.setWxPublicId(wxChannelInfoVip.getPublicId());
        wechatMessageLogPO.setOpenId(openId);
        wechatMessageLogPO.setMessageBody(messagejo.toString());
        wechatMessageLogPO.setMemberPhone(channelInfoModel.getPhone());
        wechatMessageLogPO.setMemberName(channelInfoModel.getName());
        if (channelVal != null) {
            wechatMessageLogPO.setWxNick(channelVal.getWxNick());
        }
        this.wechatMessageLogService.update(wechatMessageLogPO);
        WxPublicPO wxPublicPO = new WxPublicPO();
        wxPublicPO.setWxPublicId(wxChannelInfoVip.getPublicId());
        ResponseData Stringkey = this.wxPublicServiceFeign.getAccessTokenByAppId(wxChannelInfoVip.getAppId());
        wxPublicPO.setAppid((String)Stringkey.getData());
        if (MsgTemplateType.BEI_OU_GEN_WXTEMPLATE_MESSAGE.getCode().equals(jsonObject.getString("templateType"))) {
            return UseTemplate.sendMessage((WxPublicPO)wxPublicPO, (String)jsonObject.getString("templateType"), (String)openId, (JSONObject)messagejo);
        }
        messagejo.put("\u4f1a\u5458\u59d3\u540d", (Object)channelInfoModel.getName());
        messagejo.put("\u4f1a\u5458\u5361\u53f7", (Object)channelInfoModel.getCardNo());
        messagejo.put("\u4f59\u989d\u53d8\u52a8\u7c7b\u578b", messagejo.get((Object)"keyword1"));
        if (StringUtils.isNotEmpty((CharSequence)jsonObject.getString("templateType")) && MsgTemplateType.CONSUME_GEN_WXTEMPLATE_MESSAGE.getCode().equals(jsonObject.getString("templateType"))) {
            messagejo.put("\u6d88\u8d39\u91d1\u989d", (Object)(messagejo.get((Object)"keyword2") + "\u5143"));
            messagejo.put("\u5f53\u524d\u4f59\u989d\u5143", (Object)(messagejo.get((Object)"keyword3") + "\u5143"));
            messagejo.put("\u6d88\u8d39\u95e8\u5e97", messagejo.get((Object)"keyword4"));
            messagejo.put("\u6d88\u8d39\u65f6\u95f4", messagejo.get((Object)"keyword5"));
            messagejo.put("\u4f1a\u5458\u5361\u53f7", messagejo.get((Object)"keyword6"));
            messagejo.put("\u5173\u8054\u8ba2\u5355\u53f7", messagejo.get((Object)"keyword7"));
            messagejo.put("\u4f1a\u5458\u59d3\u540d", messagejo.get((Object)"keyword8"));
            messagejo.put("\u50a8\u503c\u5361\u53f7", messagejo.get((Object)"keyword9"));
        } else if (StringUtils.isNotEmpty((CharSequence)jsonObject.getString("templateType")) && MsgTemplateType.RECHARGE_GIVE_BALANCE_MESSAGE.getCode().equals(jsonObject.getString("templateType"))) {
            messagejo.put("\u8f6c\u8d60\u91d1\u989d", (Object)(messagejo.get((Object)"keyword2") + "\u5143"));
            messagejo.put("\u8d26\u6237\u4f59\u989d", (Object)(messagejo.get((Object)"keyword3") + "\u5143"));
            messagejo.put("\u8f6c\u51fa\u4eba\uff08\u5fae\u4fe1\u6635\u79f0\uff09", messagejo.get((Object)"keyword4"));
            messagejo.put("\u8f6c\u8d26\u65f6\u95f4", messagejo.get((Object)"keyword5"));
        } else if (StringUtils.isNotEmpty((CharSequence)jsonObject.getString("templateType")) && MsgTemplateType.RECHARGE_GIVE_OVERDUE_MESSAGE.getCode().equals(jsonObject.getString("templateType"))) {
            messagejo.put("\u8f6c\u8d60\u91d1\u989d", (Object)(messagejo.get((Object)"keyword2") + "\u5143"));
            messagejo.put("\u8d26\u6237\u4f59\u989d", (Object)(messagejo.get((Object)"keyword3") + "\u5143"));
            messagejo.put("\u8f6c\u51fa\u4eba\uff08\u5fae\u4fe1\u6635\u79f0\uff09", messagejo.get((Object)"keyword4"));
            messagejo.put("\u8f6c\u8d26\u65f6\u95f4", messagejo.get((Object)"keyword5"));
        } else if (StringUtils.isNotEmpty((CharSequence)jsonObject.getString("templateType")) && MsgTemplateType.RECHARGE_RECEIVE_BALANCE_MESSAGE.getCode().equals(jsonObject.getString("templateType"))) {
            messagejo.put("\u8f6c\u8d60\u91d1\u989d", (Object)(messagejo.get((Object)"keyword2") + "\u5143"));
            messagejo.put("\u8d26\u6237\u4f59\u989d", (Object)(messagejo.get((Object)"keyword3") + "\u5143"));
            messagejo.put("\u63a5\u6536\u4eba\uff08\u5fae\u4fe1\u6635\u79f0\uff09", messagejo.get((Object)"keyword4"));
            messagejo.put("\u8f6c\u8d26\u65f6\u95f4", messagejo.get((Object)"keyword5"));
            messagejo.put("\u8f6c\u51fa\u4eba\uff08\u5fae\u4fe1\u6635\u79f0\uff09", messagejo.get((Object)"keyword6"));
        } else if (StringUtils.isNotEmpty((CharSequence)jsonObject.getString("templateType")) && MsgTemplateType.RECHARGE_BALANCE_OVERDUE_MESSAGE.getCode().equals(jsonObject.getString("templateType"))) {
            messagejo.put("\u8fc7\u671f\u65f6\u95f4", messagejo.get((Object)"keyword2"));
            messagejo.put("\u8d26\u6237\u4f59\u989d", (Object)(messagejo.get((Object)"keyword3") + "\u5143"));
        } else {
            messagejo.put("\u4f59\u989d\u53d8\u52a8\u989d\u5143", (Object)(messagejo.get((Object)"keyword2") + "\u5143"));
            messagejo.put("\u5f53\u524d\u4f59\u989d\u5143", (Object)(messagejo.get((Object)"keyword3") + "\u5143"));
            messagejo.put("\u4ea4\u6613\u95e8\u5e97", messagejo.get((Object)"keyword4"));
            messagejo.put("\u4f59\u989d\u53d8\u52a8\u65f6\u95f4", messagejo.get((Object)"keyword5"));
            messagejo.put("\u4f1a\u5458\u5361\u53f7", messagejo.get((Object)"keyword6"));
            messagejo.put("\u5173\u8054\u8ba2\u5355\u53f7", messagejo.get((Object)"keyword7"));
        }
        return UseTemplateNew.sendMessage((WxPublicPO)wxPublicPO, (String)jsonObject.getString("templateType"), (String)openId, (JSONObject)messagejo);
    }

    public Result<String> sendMessageOpenId(String wechatMessageLogId, JSONObject jsonObject) {
        Result result = new Result();
        WxChannelInfoVo wxChannelInfoVo = new WxChannelInfoVo();
        String openId = jsonObject.getString("openId");
        wxChannelInfoVo.setWxOpenId(openId);
        ResponseData wxChannelInfoVonew = this.wxChannelInfoApiService.getWxChannelInfo(wxChannelInfoVo);
        if (null == wxChannelInfoVonew.getData()) {
            result.setStatus((long)SysRespConstants.WX_VIP_NOT_FOCUS.getStatus());
            result.setMsg(SysRespConstants.WX_VIP_NOT_FOCUS.getMsg());
            return result;
        }
        WxChannelInfoVo wxChannelInfoVip = (WxChannelInfoVo)wxChannelInfoVonew.getData();
        JSONObject messagejo = JSONObject.parseObject((String)jsonObject.getString("messagejo"));
        for (String key : messagejo.keySet()) {
            String value = messagejo.getString(key);
            if (StringUtils.isBlank((CharSequence)value)) {
                value = " ";
            }
            messagejo.put(key, (Object)value);
        }
        logger.info("tempate message :" + messagejo.toString());
        MsgWxLogPO wechatMessageLogPO = new MsgWxLogPO();
        wechatMessageLogPO.set_id(wechatMessageLogId);
        wechatMessageLogPO.setWxPublicId(wxChannelInfoVip.getWxPublicId());
        wechatMessageLogPO.setOpenId(openId);
        wechatMessageLogPO.setMessageBody(messagejo.toString());
        wechatMessageLogPO.setWxNick(wxChannelInfoVip.getWxNick());
        this.wechatMessageLogService.update(wechatMessageLogPO);
        WxPublicPO wxPublicPO = new WxPublicPO();
        wxPublicPO.setWxPublicId(wxChannelInfoVip.getWxPublicId());
        ResponseData Stringkey = this.wxPublicServiceFeign.getAccessTokenByAppId(wxChannelInfoVip.getAppId());
        wxPublicPO.setAppid((String)Stringkey.getData());
        if (MsgTemplateType.BEI_OU_GEN_WXTEMPLATE_MESSAGE.getCode().equals(jsonObject.getString("templateType"))) {
            return UseTemplate.sendMessage((WxPublicPO)wxPublicPO, (String)jsonObject.getString("templateType"), (String)openId, (JSONObject)messagejo);
        }
        messagejo.put("\u4f1a\u5458\u59d3\u540d", (Object)wxChannelInfoVip.getName());
        messagejo.put("\u4f1a\u5458\u5361\u53f7", (Object)wxChannelInfoVip.getCardNo());
        return UseTemplateNew.sendMessage((WxPublicPO)wxPublicPO, (String)jsonObject.getString("templateType"), (String)openId, (JSONObject)messagejo);
    }
}

