/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.service.impl.wxtemplatemessage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.message.common.constants.SystemConstants;
import com.bizvane.message.common.utils.DictHelper;
import com.bizvane.message.mappers.MsgSmsTempPOMapper;
import com.bizvane.message.mappers.SysSmsConfigPOMapper;
import com.bizvane.message.service.SmsMessageLogService;
import com.bizvane.message.service.SmsTemplateMessageService;
import com.bizvane.message.service.impl.centerMsg.SendCommonMessageImpl;
import com.bizvane.messagebase.common.constants.SysRespConstants;
import com.bizvane.messagebase.model.po.MsgSmsLogPO;
import com.bizvane.messagebase.model.po.SysSmsConfigPOExample;
import com.bizvane.messagefacade.models.vo.Result;
import com.bizvane.messagefacade.models.vo.SysSmsConfigVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="smsTemplateMessageServiceImpl")
public class SmsTemplateMessageServiceImpl
implements SmsTemplateMessageService {
    private static final Logger logger = LoggerFactory.getLogger(SmsTemplateMessageServiceImpl.class);
    @Autowired
    private SmsMessageLogService smsMessageLogService;
    @Autowired
    private SendCommonMessageImpl SendCommonMessageImpl;
    @Autowired
    private MsgSmsTempPOMapper msgSmsTempPOMapper;
    @Autowired
    private SysSmsConfigPOMapper sysSmsConfigPOMapper;

    public Result<String> sendMessage(String rocketMsgId, String messageBody) {
        Result result = new Result();
        try {
            logger.info(this.getClass().getName() + ".sendMessage\u5165\u53c2\uff1a" + messageBody);
            if (StringUtils.isBlank((CharSequence)messageBody)) {
                logger.error(this.getClass().getName() + ".sendMessage\u5165\u53c2\u4e3a\u7a7a");
                return result;
            }
            JSONObject jsonObject = JSON.parseObject((String)messageBody);
            MsgSmsLogPO insertPO = new MsgSmsLogPO();
            insertPO.setBussinessId(jsonObject.getString("rocketMQBussinessId"));
            insertPO.setTemplateType(jsonObject.getString("bussinessModuleCode").replace("SMS_", ""));
            if (!StringUtils.isBlank((CharSequence)jsonObject.getString("memberPhone"))) {
                insertPO.setMemberPhone(jsonObject.getString("memberPhone"));
            }
            if (!StringUtils.isBlank((CharSequence)jsonObject.getString("memberName"))) {
                insertPO.setMemberName(jsonObject.getString("memberName"));
            }
            insertPO.setTemplateTypeName(DictHelper.getDict((String)"template_type_sms", (String)jsonObject.getString("bussinessModuleCode").replace("SMS_", "")).getItemCodeName());
            insertPO.setMessageBody(messageBody);
            if (!StringUtils.isBlank((CharSequence)jsonObject.getString("sysBrandId"))) {
                insertPO.setSysBrandId(jsonObject.getLong("sysBrandId"));
            }
            Result insertResult = this.smsMessageLogService.insert(insertPO);
            Result sendResult = this.sendMessageDoing(jsonObject);
            Integer sendState = SystemConstants.SMS_MESSAGE_LOG_SEND_STATE_FAIL;
            String resultInfo = null;
            if ((long)SysRespConstants.SUCCESS.getStatus() == sendResult.getStatus()) {
                sendState = SystemConstants.SMS_MESSAGE_LOG_SEND_STATE_SUCCESS;
                resultInfo = sendResult.getMsg();
            } else {
                resultInfo = sendResult.getMsg();
            }
            insertPO.setMemberName(jsonObject.getString("memberName"));
            insertPO.setMemberPhone(jsonObject.getString("memberPhone"));
            insertPO.set_id((String)insertResult.getData());
            insertPO.setResultInfoDetail(resultInfo);
            insertPO.setSendState(sendState);
            insertPO.setMessageBody(messageBody + (String)sendResult.getData());
            this.smsMessageLogService.update(insertPO);
            logger.info("results====\u77ed\u4fe1\u53d1\u9001\uff1a" + resultInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38=====" + e.getMessage().toString());
        }
        return result;
    }

    public Result<String> sendMessageDoing(JSONObject jsonObject) {
        Result result = new Result();
        String memberPhone = jsonObject.getString("memberPhone");
        if (StringUtils.isBlank((CharSequence)memberPhone)) {
            logger.error(this.getClass().getName() + ".sendMessage.memberPhone:\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            result.setStatus((long)SysRespConstants.MEMBERPHONE_MODEL_CODE_NOT_EMPTY.getStatus());
            result.setMsg(SysRespConstants.MEMBERPHONE_MODEL_CODE_NOT_EMPTY.getMsg());
            return result;
        }
        String sendWxmember = jsonObject.getString("sendWxmember");
        if (StringUtils.isBlank((CharSequence)sendWxmember)) {
            logger.error(this.getClass().getName() + ".sendMessage.sendWxmember:\u77ed\u4fe1\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            result.setStatus((long)SysRespConstants.MSGCONTENT_MODEL_CODE_NOT_EMPTY.getStatus());
            result.setMsg(SysRespConstants.MSGCONTENT_MODEL_CODE_NOT_EMPTY.getMsg());
            return result;
        }
        Long sysBrandId = jsonObject.getLong("sysBrandId");
        if (sysBrandId == null) {
            logger.error(this.getClass().getName() + ".sendMessage.sysBrandId:\u54c1\u724cid\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            result.setStatus((long)SysRespConstants.SYSBRANDID_MODEL_CODE_NOT_EMPTY.getStatus());
            result.setMsg(SysRespConstants.SYSBRANDID_MODEL_CODE_NOT_EMPTY.getMsg());
            return result;
        }
        SysSmsConfigPOExample sysSmsConfigPOExample = new SysSmsConfigPOExample();
        sysSmsConfigPOExample.createCriteria().andSysBrandIdEqualTo(sysBrandId).andChannelTypeEqualTo(Integer.valueOf(10)).andValidEqualTo(Boolean.TRUE);
        List sysSmsConfigList = this.sysSmsConfigPOMapper.selectByExample(sysSmsConfigPOExample);
        ResponseData sendResults = new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage(), null);
        if (CollectionUtils.isNotEmpty((Collection)sysSmsConfigList)) {
            ObjectMapper mapper = new ObjectMapper();
            SysSmsConfigVO syssmsconfigvo = (SysSmsConfigVO)mapper.convertValue(sysSmsConfigList.get(0), SysSmsConfigVO.class);
            syssmsconfigvo.setMsgContent(sendWxmember);
            syssmsconfigvo.setPhone(jsonObject.getString("memberPhone"));
            result.setData((Object)syssmsconfigvo.getMsgContent());
            sendResults = this.SendCommonMessageImpl.sendSmg(syssmsconfigvo);
            if (SysResponseEnum.SUCCESS.getCode() == sendResults.getCode()) {
                result.setStatus((long)SysRespConstants.SUCCESS.getStatus());
                result.setMsg(sendResults.getMessage());
            } else {
                result.setStatus((long)SysRespConstants.FAILED.getStatus());
                result.setMsg("\u53d1\u9001\u5f02\u5e38" + sendResults.getMessage());
            }
        } else {
            result.setStatus((long)SysRespConstants.SMS_CONFIG_MESSAGETEMP_NOT_EXISTS.getStatus());
            result.setMsg(SysRespConstants.SMS_CONFIG_MESSAGETEMP_NOT_EXISTS.getMsg());
            return result;
        }
        return result;
    }
}

