/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.service.impl.wxtemplatemessage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.members.facade.models.query.CouponMemberPo;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.message.common.constants.SystemConstants;
import com.bizvane.message.common.utils.DictHelper;
import com.bizvane.message.mappers.SysSmsConfigPOMapper;
import com.bizvane.message.service.SmsMessageLogService;
import com.bizvane.message.service.SmsTemplateMessageService;
import com.bizvane.message.service.impl.centerMsg.SendCommonMessageImpl;
import com.bizvane.messagebase.common.constants.SysRespConstants;
import com.bizvane.messagebase.model.po.MsgSmsLogPO;
import com.bizvane.messagebase.model.po.SysSmsConfigPOExample;
import com.bizvane.messagefacade.interfaces.SendBatchMessageFeign;
import com.bizvane.messagefacade.models.vo.Result;
import com.bizvane.messagefacade.models.vo.SysSmsConfigVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="smsGenTemplateMessageServiceImpl")
public class SmsGenTemplateMessageServiceImpl
implements SmsTemplateMessageService {
    private static final Logger logger = LoggerFactory.getLogger(SmsGenTemplateMessageServiceImpl.class);
    @Autowired
    private SmsMessageLogService smsMessageLogService;
    @Autowired
    private SendCommonMessageImpl SendCommonMessageImpl;
    @Autowired
    private SendBatchMessageFeign sendBatchMessage;
    @Autowired
    private SysSmsConfigPOMapper sysSmsConfigPOMapper;
    @Autowired
    private MemberInfoApiService memberInfoApiService;

    public Result<String> sendMessage(String rocketMsgId, String messageBody) {
        Result result = new Result();
        try {
            logger.info(this.getClass().getName() + ".sendMessage\u5165\u53c2\uff1a" + messageBody);
            if (StringUtils.isBlank((CharSequence)messageBody)) {
                logger.error(this.getClass().getName() + ".sendMessage\u5165\u53c2\u4e3a\u7a7a");
                return result;
            }
            JSONObject jsonObject = JSON.parseObject((String)messageBody);
            String phoneStr = jsonObject.getString("phoneStr");
            String sysBrandId = jsonObject.getString("sysBrandId");
            Result sendResult = this.sendMessageDoing(jsonObject, phoneStr);
            String resultInfoDetail = null;
            String resultInfo = null;
            Integer sendState = SystemConstants.SMS_MESSAGE_LOG_SEND_STATE_FAIL;
            if ((long)SysRespConstants.SUCCESS.getStatus() == sendResult.getStatus()) {
                sendState = SystemConstants.SMS_MESSAGE_LOG_SEND_STATE_SUCCESS;
                resultInfo = "\u6210\u529f";
            } else {
                resultInfoDetail = sendResult.getMsg();
                resultInfo = "\u5931\u8d25";
            }
            CouponMemberPo couponMemberPo = new CouponMemberPo();
            couponMemberPo.setPhonesStr(phoneStr);
            couponMemberPo.setBrandId(Long.valueOf(sysBrandId));
            ResponseData getMemberNameByPhones = this.memberInfoApiService.getMemberNameByPhones(couponMemberPo);
            ArrayList<MsgSmsLogPO> MsgSmsLogPOlist = new ArrayList<MsgSmsLogPO>();
            for (String memberPhone : phoneStr.split(",")) {
                MsgSmsLogPO insertPO = new MsgSmsLogPO();
                insertPO.setBussinessId(jsonObject.getString("rocketMQBussinessId"));
                insertPO.setTemplateType(jsonObject.getString("bussinessModuleCode"));
                insertPO.setTemplateTypeName(DictHelper.getDict((String)"template_type_sms", (String)jsonObject.getString("bussinessModuleCode").replace("SMS_", "")).getItemCodeName());
                insertPO.setSysBrandId(jsonObject.getLong("sysBrandId"));
                insertPO.setMessageBody(messageBody);
                insertPO.setResultInfoDetail(resultInfoDetail);
                insertPO.setSendState(sendState);
                insertPO.setResultInfo(resultInfo);
                try {
                    insertPO.setMemberName((String)((Map)getMemberNameByPhones.getData()).get(memberPhone));
                    SimpleDateFormat sdfo = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String d = sdfo.format(jsonObject.getLong("sendTime"));
                    insertPO.setCreateDate(sdfo.parse(d));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                insertPO.setMemberPhone(memberPhone);
                MsgSmsLogPOlist.add(insertPO);
            }
            Result result2 = this.smsMessageLogService.insertCreateDate(MsgSmsLogPOlist);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38=====" + e.getMessage().toString());
        }
        return result;
    }

    private SimpleDateFormat newSimpleDateFormat(String string) {
        return null;
    }

    public Result<String> sendMessageDoing(JSONObject jsonObject, String memberPhone) {
        Result result = new Result();
        String messageBody = jsonObject.getString("messageBody");
        if (StringUtils.isBlank((CharSequence)messageBody)) {
            logger.error(this.getClass().getName() + ".sendMessage.messageBody:\u77ed\u4fe1\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            result.setStatus((long)SysRespConstants.MSGCONTENT_MODEL_CODE_NOT_EMPTY.getStatus());
            result.setMsg(SysRespConstants.MSGCONTENT_MODEL_CODE_NOT_EMPTY.getMsg());
            return result;
        }
        Long sysBrandId = jsonObject.getLong("sysBrandId");
        if (sysBrandId == null) {
            logger.error(this.getClass().getName() + ".sendMessage.sysBrandId:\u54c1\u724cid\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            result.setStatus((long)SysRespConstants.SYSBRANDID_MODEL_CODE_NOT_EMPTY.getStatus());
            result.setMsg(SysRespConstants.SYSBRANDID_MODEL_CODE_NOT_EMPTY.getMsg());
            return result;
        }
        SysSmsConfigPOExample sysSmsConfigPOExample = new SysSmsConfigPOExample();
        sysSmsConfigPOExample.createCriteria().andSysBrandIdEqualTo(sysBrandId).andChannelTypeEqualTo(Integer.valueOf(10)).andValidEqualTo(Boolean.TRUE);
        List sysSmsConfigList = this.sysSmsConfigPOMapper.selectByExample(sysSmsConfigPOExample);
        ResponseData sendResults = new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage(), null);
        if (CollectionUtils.isNotEmpty((Collection)sysSmsConfigList)) {
            ObjectMapper mapper = new ObjectMapper();
            SysSmsConfigVO syssmsconfigvo = (SysSmsConfigVO)mapper.convertValue(sysSmsConfigList.get(0), SysSmsConfigVO.class);
            syssmsconfigvo.setMsgContent(messageBody + " \u9000\u8ba2\u56de\u590dTD");
            result.setData((Object)syssmsconfigvo.getMsgContent());
            String phoneStr = jsonObject.getString("phoneStr");
            syssmsconfigvo.setPhones(phoneStr);
            syssmsconfigvo.setMsgId(jsonObject.getString("rocketMQBussinessId"));
            sendResults = this.sendBatchMessage.sendSmgBatch(syssmsconfigvo);
            if (SysResponseEnum.SUCCESS.getCode() == sendResults.getCode()) {
                result.setStatus((long)SysRespConstants.SUCCESS.getStatus());
                result.setMsg(sendResults.getMessage());
            } else {
                result.setStatus((long)SysRespConstants.FAILED.getStatus());
                result.setMsg("\u53d1\u9001\u5f02\u5e38\uff1a" + sendResults.getMessage());
            }
        } else {
            result.setStatus((long)SysRespConstants.SMS_CONFIG_MESSAGETEMP_NOT_EXISTS.getStatus());
            result.setMsg(SysRespConstants.SMS_CONFIG_MESSAGETEMP_NOT_EXISTS.getMsg());
            return result;
        }
        return result;
    }
}

