/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.service.impl.centerMsg;

import com.alibaba.fastjson.JSON;
import com.bizvane.message.common.network.NetWorkBatch;
import com.bizvane.message.mongo.MsgMongoRepository;
import com.bizvane.messagefacade.interfaces.SendBatchMessageFeign;
import com.bizvane.messagefacade.models.vo.SysSmsConfigVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SendBatchMessageImpl
implements SendBatchMessageFeign {
    private static final Logger log = LoggerFactory.getLogger(SendBatchMessageImpl.class);
    @Autowired
    private NetWorkBatch netWorkBatch;
    @Autowired
    private MsgMongoRepository mongoTemplateService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseData<Integer> sendSmgBatch(SysSmsConfigVO vo) {
        int phonenum;
        ResponseData result = new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage(), null);
        String channelName = vo.getChannelName();
        Boolean resultData = Boolean.FALSE;
        String phones = vo.getPhones();
        Integer batchNum = vo.getBatchNum();
        if (StringUtils.isBlank((String)phones)) {
            result.setMessage("\u6279\u91cf\u624b\u673a\u53f7\u4e3a\u7a7a");
        }
        if ((phonenum = phones.split(",").length) > 1000) {
            result.setMessage("\u6279\u91cf\u624b\u673a\u53f7\u8d85\u8fc7" + batchNum + ",\u65e0\u6cd5\u53d1\u9001");
            log.info("\u6279\u91cf\u624b\u673a\u53f7\u8d85\u8fc71000,\u65e0\u6cd5\u53d1\u9001" + JSON.toJSONString((Object)channelName));
        }
        try {
            if ("moments3.4".equals(channelName)) {
                resultData = this.netWorkBatch.sendMsgMomentsBatch(vo);
            }
            if ("chuangLan253".equals(channelName)) {
                String resultstr = this.netWorkBatch.sendChuangLan253Batch(vo);
                if (resultstr.equals("ture")) {
                    resultData = Boolean.TRUE;
                    result.setCode(SysResponseEnum.SUCCESS.getCode());
                    result.setMessage(SysResponseEnum.SUCCESS.getMessage());
                }
                result.setCode(SysResponseEnum.FAILED.getCode());
                result.setMessage(resultstr);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            vo.setStatus(resultData);
            vo.setCreateDate(new Date());
            this.mongoTemplateService.singleSave((Object)vo);
            if (resultData.booleanValue()) {
                result.setCode(SysResponseEnum.SUCCESS.getCode());
                result.setMessage(SysResponseEnum.SUCCESS.getMessage());
            }
            return result;
        }
    }
}

