/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.service.impl.wxtemplatemessage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.message.common.constants.SystemConstants;
import com.bizvane.message.common.utils.DictHelper;
import com.bizvane.message.mappers.MsgSmsTempPOMapper;
import com.bizvane.message.mappers.SysSmsConfigPOMapper;
import com.bizvane.message.service.SendSmsTemplateMessageService;
import com.bizvane.message.service.SmsMessageLogService;
import com.bizvane.message.service.impl.centerMsg.SendCommonMessageImpl;
import com.bizvane.message.service.impl.wxtemplatemessage.SendSmsTemplateMessageCouponExpireServiceImpl;
import com.bizvane.messagebase.common.constants.SysRespConstants;
import com.bizvane.messagebase.model.po.MsgSmsLogPO;
import com.bizvane.messagebase.model.po.MsgSmsTempPO;
import com.bizvane.messagebase.model.po.MsgSmsTempPOExample;
import com.bizvane.messagebase.model.po.SysSmsConfigPOExample;
import com.bizvane.messagefacade.models.vo.Result;
import com.bizvane.messagefacade.models.vo.SysSmsConfigVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sendSmsTemplateMessageCouponServiceImpl")
public class SendSmsTemplateMessageCouponServiceImpl
implements SendSmsTemplateMessageService {
    private static final Logger logger = LoggerFactory.getLogger(SendSmsTemplateMessageCouponExpireServiceImpl.class);
    @Autowired
    private SmsMessageLogService smsMessageLogService;
    @Autowired
    private SendCommonMessageImpl SendCommonMessageImpl;
    @Autowired
    private MsgSmsTempPOMapper msgSmsTempPOMapper;
    @Autowired
    private SysSmsConfigPOMapper sysSmsConfigPOMapper;

    public Result<String> sendMessage(String rocketMsgId, String messageBody) {
        Result result = new Result();
        try {
            logger.info(this.getClass().getName() + ".sendMessage\u5165\u53c2\uff1a" + messageBody);
            if (StringUtils.isBlank((CharSequence)messageBody)) {
                logger.error(this.getClass().getName() + ".sendMessage\u5165\u53c2\u4e3a\u7a7a");
                return result;
            }
            JSONObject jsonObject = JSON.parseObject((String)messageBody);
            MsgSmsLogPO insertPO = new MsgSmsLogPO();
            insertPO.setBussinessId(jsonObject.getString("rocketMQBussinessId"));
            insertPO.setTemplateType(jsonObject.getString("bussinessModuleCode").replace("SMS_", ""));
            insertPO.setTemplateTypeName(DictHelper.getDict((String)"template_type_sms", (String)jsonObject.getString("bussinessModuleCode").replace("SMS_", "")).getItemCodeName());
            if (!StringUtils.isBlank((CharSequence)jsonObject.getString("memberPhone"))) {
                insertPO.setMemberPhone(jsonObject.getString("memberPhone"));
            }
            insertPO.setMessageBody(messageBody);
            if (!StringUtils.isBlank((CharSequence)jsonObject.getString("sysBrandId"))) {
                insertPO.setSysBrandId(jsonObject.getLong("sysBrandId"));
            }
            Result insertResult = this.smsMessageLogService.insert(insertPO);
            Result sendResult = this.sendMessageDoing(jsonObject);
            Integer sendState = SystemConstants.SMS_MESSAGE_LOG_SEND_STATE_FAIL;
            String resultInfo = null;
            if ((long)SysRespConstants.SUCCESS.getStatus() == sendResult.getStatus()) {
                sendState = SystemConstants.SMS_MESSAGE_LOG_SEND_STATE_SUCCESS;
                resultInfo = sendResult.getMsg();
            } else {
                resultInfo = sendResult.getMsg();
            }
            insertPO.setMemberName(jsonObject.getString("memberName"));
            insertPO.setMemberPhone(jsonObject.getString("memberPhone"));
            insertPO.set_id((String)insertResult.getData());
            insertPO.setResultInfoDetail(resultInfo);
            insertPO.setSendState(sendState);
            insertPO.setMessageBody(messageBody + (String)sendResult.getData());
            this.smsMessageLogService.update(insertPO);
            logger.info("results====\u77ed\u4fe1\u53d1\u9001\uff1a" + resultInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38=====" + e.getMessage().toString());
        }
        return result;
    }

    public Result<String> sendMessageDoing(JSONObject jsonObject) {
        String memberPhone;
        String nickName;
        String orderNo;
        String couponCode;
        String couponName;
        String denomination;
        Result result = new Result();
        String memberName = jsonObject.getString("memberName");
        if (StringUtils.isBlank((CharSequence)memberName)) {
            jsonObject.fluentPut("memberName", (Object)"");
        }
        if (StringUtils.isBlank((CharSequence)(denomination = jsonObject.getString("denomination")))) {
            jsonObject.fluentPut("denomination", (Object)"");
        }
        if (StringUtils.isBlank((CharSequence)(couponName = jsonObject.getString("couponName")))) {
            jsonObject.fluentPut("couponName", (Object)"");
        }
        if (StringUtils.isBlank((CharSequence)(couponCode = jsonObject.getString("couponCode")))) {
            jsonObject.fluentPut("couponCode", (Object)"");
        }
        if (jsonObject.getString("bussinessType").equals("sendSmsCouponOnlineMessage") && StringUtils.isBlank((CharSequence)(orderNo = jsonObject.getString("orderNo")))) {
            jsonObject.fluentPut("orderNo", (Object)"");
        }
        if (StringUtils.isBlank((CharSequence)(nickName = jsonObject.getString("nickName")))) {
            jsonObject.fluentPut("nickName", (Object)"");
        }
        if (StringUtils.isBlank((CharSequence)(memberPhone = jsonObject.getString("memberPhone")))) {
            logger.error(this.getClass().getName() + ".sendMessage.memberPhone:\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            result.setStatus((long)SysRespConstants.MEMBERPHONE_MODEL_CODE_NOT_EMPTY.getStatus());
            result.setMsg(SysRespConstants.MEMBERPHONE_MODEL_CODE_NOT_EMPTY.getMsg());
            return result;
        }
        Long sysBrandId = jsonObject.getLong("sysBrandId");
        if (sysBrandId == null) {
            logger.error(this.getClass().getName() + ".sendMessage.sysBrandId:\u54c1\u724cid\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            result.setStatus((long)SysRespConstants.SYSBRANDID_MODEL_CODE_NOT_EMPTY.getStatus());
            result.setMsg(SysRespConstants.SYSBRANDID_MODEL_CODE_NOT_EMPTY.getMsg());
            return result;
        }
        Date tasktime = jsonObject.getDate("useTime");
        SimpleDateFormat formatterA = new SimpleDateFormat("yyyy-MM-dd");
        if (tasktime == null) {
            result.setStatus((long)SysRespConstants.DATA_NOT_TOTAY.getStatus());
            result.setMsg(SysRespConstants.DATA_NOT_TOTAY.getMsg());
            return result;
        }
        String data = formatterA.format(new Date());
        if (!data.equals(formatterA.format(tasktime))) {
            result.setStatus((long)SysRespConstants.DATA_NOT_TOTAY.getStatus());
            result.setMsg(SysRespConstants.DATA_NOT_TOTAY.getMsg());
            return result;
        }
        MsgSmsTempPOExample msgSmsTempPOExample = new MsgSmsTempPOExample();
        msgSmsTempPOExample.createCriteria().andSysBrandIdEqualTo(sysBrandId).andTemplateTypeEqualTo(jsonObject.getString("bussinessModuleCode").replace("SMS_", "")).andValidEqualTo(Boolean.TRUE);
        List smsTempPOList = this.msgSmsTempPOMapper.selectByExample(msgSmsTempPOExample);
        if (null == smsTempPOList || smsTempPOList.size() == 0) {
            result.setStatus((long)SysRespConstants.SMS_MESSAGETEMP_NOT_EXISTS.getStatus());
            result.setMsg(SysRespConstants.SMS_MESSAGETEMP_NOT_EXISTS.getMsg());
            return result;
        }
        MsgSmsTempPO smsTempPO = (MsgSmsTempPO)smsTempPOList.get(0);
        if (!smsTempPO.getStatus().booleanValue()) {
            logger.error("\u8be5\u4f1a\u5458\u53d1\u9001\u77ed\u4fe1\u672a\u5f00\u542f\uff01");
            result.setStatus((long)SysRespConstants.SMS_MESSAGETEMP_OFF.getStatus());
            result.setMsg(SysRespConstants.SMS_MESSAGETEMP_OFF.getMsg());
            return result;
        }
        if ("2".equals(jsonObject.getString("sendWxmember")) && smsTempPO.getSendWxmember() == 1) {
            logger.error("\u8be5\u6a21\u677f\u8bbe\u7f6e\u4e0d\u5411\u5fae\u4fe1\u4f1a\u5458\u53d1\u77ed\u4fe1");
            result.setStatus((long)SysRespConstants.SMS_CONFIG_MESSAGETEMP_WX_OFF.getStatus());
            result.setMsg(SysRespConstants.SMS_CONFIG_MESSAGETEMP_WX_OFF.getMsg());
            return result;
        }
        SysSmsConfigPOExample sysSmsConfigPOExample = new SysSmsConfigPOExample();
        sysSmsConfigPOExample.createCriteria().andSysBrandIdEqualTo(sysBrandId).andChannelTypeEqualTo(Integer.valueOf(10)).andValidEqualTo(Boolean.TRUE);
        List sysSmsConfigList = this.sysSmsConfigPOMapper.selectByExample(sysSmsConfigPOExample);
        ResponseData sendResults = new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage(), null);
        if (CollectionUtils.isNotEmpty((Collection)sysSmsConfigList)) {
            ObjectMapper mapper = new ObjectMapper();
            SysSmsConfigVO syssmsconfigvo = (SysSmsConfigVO)mapper.convertValue(sysSmsConfigList.get(0), SysSmsConfigVO.class);
            String msgContent = smsTempPO.getContent().replace("@[\u4f1a\u5458\u59d3\u540d]", jsonObject.getString("memberName")).replace("@[\u4f18\u60e0\u5238\u540d\u79f0]", jsonObject.getString("couponName")).replace("@[\u5238\u53f7]", jsonObject.getString("couponCode")).replace("@[\u516c\u4f17\u53f7]", jsonObject.getString("nickName"));
            msgContent = "1".equals(jsonObject.getString("preferentialType")) ? msgContent.replace("@[\u4f18\u60e0\u5238\u6298\u6263/\u91d1\u989d]", jsonObject.getString("denomination") + "\u5143") : ("2".equals(jsonObject.getString("preferentialType")) ? msgContent.replace("@[\u4f18\u60e0\u5238\u6298\u6263/\u91d1\u989d]", jsonObject.getString("denomination") + "\u6298") : msgContent.replace("@[\u4f18\u60e0\u5238\u6298\u6263/\u91d1\u989d]", ""));
            msgContent = msgContent.replace("@[\u4f18\u60e0\u5238\u5165\u8d26\u65f6\u95f4]", formatterA.format(tasktime));
            syssmsconfigvo.setMsgContent(msgContent);
            syssmsconfigvo.setPhone(jsonObject.getString("memberPhone"));
            result.setData((Object)syssmsconfigvo.getMsgContent());
            sendResults = this.SendCommonMessageImpl.sendSmg(syssmsconfigvo);
            if (SysResponseEnum.SUCCESS.getCode() == sendResults.getCode()) {
                result.setStatus((long)SysRespConstants.SUCCESS.getStatus());
                result.setMsg(sendResults.getMessage());
            } else {
                result.setStatus((long)SysRespConstants.FAILED.getStatus());
                result.setMsg("\u53d1\u9001\u5f02\u5e38" + sendResults.getMessage());
            }
        } else {
            result.setStatus((long)SysRespConstants.SMS_CONFIG_MESSAGETEMP_NOT_EXISTS.getStatus());
            result.setMsg(SysRespConstants.SMS_CONFIG_MESSAGETEMP_NOT_EXISTS.getMsg());
            return result;
        }
        return result;
    }
}

