/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.message.service.RocketMQProducerService;
import com.bizvane.message.service.RocketMQSendOrderSmsService;
import com.bizvane.messagebase.common.constants.SysRespConstants;
import com.bizvane.messagefacade.models.vo.Result;
import com.bizvane.utils.responseinfo.ResponseData;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RocketMQSendSmsOrderServiceImpl
implements RocketMQSendOrderSmsService {
    private static final Logger log = LoggerFactory.getLogger(RocketMQSendSmsOrderServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(RocketMQSendSmsOrderServiceImpl.class);
    @Autowired
    private RocketMQProducerService rocketMQProducerService;

    public Result<String> sendMessage(String messageBody) {
        logger.info("RocketMQSendSmsServiceImpl.sendMessage.param:" + messageBody);
        Result result = new Result();
        if (StringUtils.isBlank((CharSequence)messageBody)) {
            logger.error("RocketMQSendSmsServiceImpl.sendMessage.param:\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            result.setStatus((long)SysRespConstants.SYSTEM_DATA_NOT_EMPTY.getStatus());
            result.setMsg(SysRespConstants.SYSTEM_DATA_NOT_EMPTY.getMsg());
            return result;
        }
        JSONObject jsonObject = JSON.parseObject((String)messageBody);
        String topic = jsonObject.getString("rocketMQTopic");
        if (StringUtils.isBlank((CharSequence)topic)) {
            logger.error("SmsServiceImpl.sendMessage.topic:topic\u4e0d\u80fd\u4e3a\u7a7a");
            result.setStatus((long)SysRespConstants.ROCKET_MQ_TOPIC_NOT_EMPTY.getStatus());
            result.setMsg(SysRespConstants.ROCKET_MQ_TOPIC_NOT_EMPTY.getMsg());
            return result;
        }
        String tag = jsonObject.getString("rocketMQTag");
        if (StringUtils.isBlank((CharSequence)tag)) {
            logger.error("SmsServiceImpl.sendMessage.tag:tag\u4e0d\u80fd\u4e3a\u7a7a");
            result.setStatus((long)SysRespConstants.ROCKET_MQ_TAG_NOT_EMPTY.getStatus());
            result.setMsg(SysRespConstants.ROCKET_MQ_TAG_NOT_EMPTY.getMsg());
            return result;
        }
        String bussinessId = jsonObject.getString("rocketMQBussinessId");
        if (StringUtils.isBlank((CharSequence)bussinessId)) {
            logger.error("SmsServiceImpl.sendMessage.bussinessId:\u4e1a\u52a1\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            result.setStatus((long)SysRespConstants.BUSSINESS_ID_NOT_EMPTY.getStatus());
            result.setMsg(SysRespConstants.BUSSINESS_ID_NOT_EMPTY.getMsg());
            return result;
        }
        String bussinessModuleCode = jsonObject.getString("bussinessModuleCode");
        if (StringUtils.isBlank((CharSequence)bussinessModuleCode)) {
            logger.error("SmsServiceImpl.sendMessage.bussinessCode:\u4e1a\u52a1\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            result.setStatus((long)SysRespConstants.BUSSINESS_MODEL_CODE_NOT_EMPTY.getStatus());
            result.setMsg(SysRespConstants.BUSSINESS_MODEL_CODE_NOT_EMPTY.getMsg());
            return result;
        }
        byte[] messageBodyByte = null;
        try {
            jsonObject.put("key", (Object)messageBody.hashCode());
            messageBodyByte = jsonObject.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            log.error(e1.getMessage(), (Throwable)e1);
        }
        ResponseData sendResult = this.rocketMQProducerService.sendMessage(topic, tag, jsonObject.getString("key"), messageBodyByte);
        String messageId = (String)sendResult.getData();
        logger.info("RocketMQSendSmsOrderServiceImpl\u53d1\u9001 " + bussinessId);
        result.setMsg(SysRespConstants.SUCCESS.getMsg());
        result.setData((Object)messageId);
        return result;
    }
}

