/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.message.service.RocketMQProducerService;
import com.bizvane.message.service.RocketMQSendIntegralSmsService;
import com.bizvane.messagebase.common.constants.SysRespConstants;
import com.bizvane.messagefacade.models.vo.Result;
import com.bizvane.utils.responseinfo.ResponseData;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RocketMQSendSmsIntegralServiceImpl
implements RocketMQSendIntegralSmsService {
    private static final Logger log = LoggerFactory.getLogger(RocketMQSendSmsIntegralServiceImpl.class);
    @Autowired
    private RocketMQProducerService rocketMQProducerService;

    public Result<String> sendMessage(String messageBody) {
        log.info("RocketMQSendSmsServiceImpl.sendMessage.param:" + messageBody);
        Result result = new Result();
        if (StringUtils.isBlank((CharSequence)messageBody)) {
            log.error("RocketMQSendSmsServiceImpl.sendMessage.param:\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            result.setStatus((long)SysRespConstants.SYSTEM_DATA_NOT_EMPTY.getStatus());
            result.setMsg(SysRespConstants.SYSTEM_DATA_NOT_EMPTY.getMsg());
            return result;
        }
        JSONObject jsonObject = JSON.parseObject((String)messageBody);
        String topic = jsonObject.getString("rocketMQTopic");
        if (StringUtils.isBlank((CharSequence)topic)) {
            log.error("SmsServiceImpl.sendMessage.topic:topic\u4e0d\u80fd\u4e3a\u7a7a");
            result.setStatus((long)SysRespConstants.ROCKET_MQ_TOPIC_NOT_EMPTY.getStatus());
            result.setMsg(SysRespConstants.ROCKET_MQ_TOPIC_NOT_EMPTY.getMsg());
            return result;
        }
        String tag = jsonObject.getString("rocketMQTag");
        if (StringUtils.isBlank((CharSequence)tag)) {
            log.error("SmsServiceImpl.sendMessage.tag:tag\u4e0d\u80fd\u4e3a\u7a7a");
            result.setStatus((long)SysRespConstants.ROCKET_MQ_TAG_NOT_EMPTY.getStatus());
            result.setMsg(SysRespConstants.ROCKET_MQ_TAG_NOT_EMPTY.getMsg());
            return result;
        }
        String bussinessId = jsonObject.getString("rocketMQBussinessId");
        if (StringUtils.isBlank((CharSequence)bussinessId)) {
            log.error("SmsServiceImpl.sendMessage.bussinessId:\u4e1a\u52a1\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            result.setStatus((long)SysRespConstants.BUSSINESS_ID_NOT_EMPTY.getStatus());
            result.setMsg(SysRespConstants.BUSSINESS_ID_NOT_EMPTY.getMsg());
            return result;
        }
        String bussinessModuleCode = jsonObject.getString("bussinessModuleCode");
        if (StringUtils.isBlank((CharSequence)bussinessModuleCode)) {
            log.error("SmsServiceImpl.sendMessage.bussinessCode:\u4e1a\u52a1\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            result.setStatus((long)SysRespConstants.BUSSINESS_MODEL_CODE_NOT_EMPTY.getStatus());
            result.setMsg(SysRespConstants.BUSSINESS_MODEL_CODE_NOT_EMPTY.getMsg());
            return result;
        }
        byte[] messageBodyByte = null;
        try {
            jsonObject.put("key", (Object)messageBody.hashCode());
            messageBodyByte = jsonObject.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            log.error(e1.getMessage(), (Throwable)e1);
        }
        ResponseData sendResult = this.rocketMQProducerService.sendMessage(topic, tag, jsonObject.getString("key"), messageBodyByte);
        result.setMsg(SysRespConstants.SUCCESS.getMsg());
        result.setData(sendResult.getData());
        return result;
    }
}

