/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.service.impl;

import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.Producer;
import com.bizvane.message.common.utils.SpringContextUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class RocketMQManager {
    @Value(value="${rocketmq.onsaddr}")
    private String onsaddr;
    @Value(value="${rocketmq.accessKey}")
    private String accessKey;
    @Value(value="${rocketmq.secretKey}")
    private String secretKey;
    @Value(value="${rocketmq.consumerStatus}")
    private String consumerStatus;
    @Value(value="${rocketmq.addr}")
    private String addr;
    @Value(value="${rocketmq.environment}")
    private String environment;
    @Value(value="${rocketmq.topic}")
    private String topic;
    @Value(value="${rocketmq.producerId}")
    private String producerId;
    @Value(value="${rocketmq.consumerId}")
    private String consumerId;
    private static Map<String, Producer> producerMap = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(RocketMQManager.class);

    public void initMQuatNew() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Properties propertiesproducer = this.getProperties();
        propertiesproducer.setProperty("ProducerId", this.producerId);
        if (this.environment.equals("uat")) {
            propertiesproducer.setProperty("NAMESRV_ADDR", this.addr);
        }
        propertiesproducer.setProperty("SendMsgTimeoutMillis", "3000");
        Producer producer = ONSFactory.createProducer((Properties)propertiesproducer);
        producer.start();
        logger.info("\u751f\u4ea7\u521d\u59cb\u5316\u6210\u529f\u3002");
        producerMap.put(this.topic, producer);
        if (this.consumerStatus.equals("true")) {
            Properties properties = this.getProperties();
            properties.setProperty("ConsumerId", this.consumerId);
            if (this.environment.equals("uat")) {
                properties.setProperty("NAMESRV_ADDR", this.addr);
            }
            properties.put("ConsumeThreadNums", "25");
            Consumer consumer = ONSFactory.createConsumer((Properties)properties);
            MessageListener messageListener = (MessageListener)SpringContextUtil.getBean((String)"allMessageListener");
            consumer.subscribe(this.topic, "*", messageListener);
            consumer.start();
            logger.info("ALL\u6d88\u8d39\u8005\u521d\u59cb\u5316\u6210\u529f\u3002");
        }
    }

    private Properties getProperties() {
        Properties properties = new Properties();
        properties.setProperty("AccessKey", this.accessKey);
        properties.setProperty("SecretKey", this.secretKey);
        properties.setProperty("ONSAddr", this.onsaddr);
        return properties;
    }

    public static Producer getProducer(String businessType) {
        return (Producer)producerMap.get(businessType);
    }
}

