/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.service.Standard.impl;

import com.bizvane.message.common.utils.PageForm;
import com.bizvane.message.mappers.MsgSmsRecordPoMapper;
import com.bizvane.message.po.MsgSmsRecordPo;
import com.bizvane.message.po.MsgSmsRecordPoExample;
import com.bizvane.message.service.Standard.StandSmsRecordService;
import com.bizvane.messagebase.common.constants.SysResponseEnum;
import com.bizvane.messagefacade.models.vo.SmsMessageLogVo;
import com.bizvane.messagefacade.models.vo.SmsStatisticsVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.math.BigDecimal;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class StandSmsRecordServiceImpl
implements StandSmsRecordService {
    private static final Logger log = LoggerFactory.getLogger(StandSmsRecordServiceImpl.class);
    @Autowired
    private MsgSmsRecordPoMapper msgSmsRecordPoMapper;

    public ResponseData<PageInfo<MsgSmsRecordPo>> getSmsMessageRecordPage(SmsMessageLogVo msgSmsLogPO, PageForm pageForm) {
        Date endTime;
        String templateType;
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        MsgSmsRecordPoExample msgSmsRecordPoExample = new MsgSmsRecordPoExample();
        msgSmsRecordPoExample.setOrderByClause("create_date desc");
        MsgSmsRecordPoExample.Criteria criteria = msgSmsRecordPoExample.createCriteria();
        Long sysBrandId = msgSmsLogPO.getSysBrandId();
        if (null == sysBrandId) {
            PageInfo pageInfo = new PageInfo();
            responseData.setData((Object)pageInfo);
            return responseData;
        }
        criteria.andSysBrandIdEqualTo(sysBrandId);
        String baseSearchValue = msgSmsLogPO.getBaseSearchValue();
        if (!StringUtils.isEmpty((Object)baseSearchValue)) {
            MsgSmsRecordPoExample baseSearchExample = new MsgSmsRecordPoExample();
            baseSearchExample.setOrderByClause("create_date desc");
            MsgSmsRecordPoExample.Criteria baseSearchCri = baseSearchExample.createCriteria();
            baseSearchCri.andSysBrandIdEqualTo(sysBrandId);
            if (StandSmsRecordServiceImpl.isNumeric((String)baseSearchValue)) {
                baseSearchCri.andMemberPhoneEqualTo(baseSearchValue);
                baseSearchCri.andSceneCodeNotEqualTo("VALIDATE_CODE");
            } else {
                baseSearchCri.andSceneCodeEqualTo(baseSearchValue);
            }
            if (null != msgSmsLogPO.getSendState()) {
                baseSearchCri.andSendStateEqualTo(Integer.valueOf(1));
            }
            Page page = PageHelper.startPage((int)pageForm.getPageNum(), (int)pageForm.getPageSize()).doSelectPage(() -> this.msgSmsRecordPoMapper.selectByExample(baseSearchExample));
            PageInfo pageInfo = new PageInfo();
            pageInfo.setList(page.getResult());
            pageInfo.setPageNum(pageForm.getPageNum().intValue());
            pageInfo.setPageSize(pageForm.getPageSize().intValue());
            pageInfo.setTotal(page.getTotal());
            responseData.setData((Object)pageInfo);
            return responseData;
        }
        String memberPhone = msgSmsLogPO.getMemberPhone();
        if (!StringUtils.isEmpty((Object)memberPhone)) {
            criteria.andMemberPhoneEqualTo(memberPhone);
        }
        if (!StringUtils.isEmpty((Object)(templateType = msgSmsLogPO.getTemplateType()))) {
            criteria.andSceneCodeEqualTo(templateType);
        } else {
            criteria.andSceneCodeNotEqualTo("VALIDATE_CODE");
        }
        Date startTime = msgSmsLogPO.getSendTimeStart();
        if (null != startTime) {
            criteria.andCreateDateGreaterThan(startTime);
        }
        if (null != (endTime = msgSmsLogPO.getSendTimeEnd())) {
            criteria.andCreateDateLessThanOrEqualTo(endTime);
        }
        if (null != msgSmsLogPO.getSendState()) {
            criteria.andSendStateEqualTo(Integer.valueOf(1));
        }
        Page page = PageHelper.startPage((int)pageForm.getPageNum(), (int)pageForm.getPageSize()).doSelectPage(() -> this.msgSmsRecordPoMapper.selectByExample(msgSmsRecordPoExample));
        PageInfo pageInfo = new PageInfo();
        pageInfo.setList(page.getResult());
        pageInfo.setPageNum(pageForm.getPageNum().intValue());
        pageInfo.setPageSize(pageForm.getPageSize().intValue());
        pageInfo.setTotal(page.getTotal());
        responseData.setData((Object)pageInfo);
        return responseData;
    }

    public ResponseData<SmsStatisticsVO> getSmsMessageRecordStatics(SmsMessageLogVo smsMessageLogVo) {
        PageForm pageForm = new PageForm();
        pageForm.setPageNum(smsMessageLogVo.getPageNumber());
        pageForm.setPageSize(smsMessageLogVo.getPageSize());
        ResponseData pageInfoList = this.getSmsMessageRecordPage(smsMessageLogVo, pageForm);
        Long allCount = ((PageInfo)pageInfoList.getData()).getTotal();
        smsMessageLogVo.setSendState(Integer.valueOf(1));
        ResponseData pageInfoSuccesslist = this.getSmsMessageRecordPage(smsMessageLogVo, pageForm);
        Long successCount = ((PageInfo)pageInfoSuccesslist.getData()).getTotal();
        Long failedCount = allCount - successCount;
        SmsStatisticsVO smsStatisticsVO = new SmsStatisticsVO();
        if (allCount != 0L) {
            BigDecimal b = new BigDecimal(successCount);
            b = b.divide(new BigDecimal(allCount), 4, 4).multiply(new BigDecimal(100));
            String endPercent = b.setScale(2, 4).toString();
            if (successCount == 0L) {
                endPercent = "0.00";
            }
            smsStatisticsVO.setAllCountSms(allCount);
            smsStatisticsVO.setFailedSms(failedCount);
            smsStatisticsVO.setSuccessSms(successCount);
            smsStatisticsVO.setSuccessPercent(endPercent);
        } else {
            smsStatisticsVO.setAllCountSms(Long.valueOf(0L));
            smsStatisticsVO.setFailedSms(Long.valueOf(0L));
            smsStatisticsVO.setSuccessSms(Long.valueOf(0L));
            smsStatisticsVO.setSuccessPercent("0.00");
        }
        ResponseData responseData = new ResponseData();
        responseData.setData((Object)smsStatisticsVO);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public static boolean isNumeric(String str) {
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

