/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.service.Standard.baseProcess;

import cn.bizvane.rocketmq.spring.core.MessageDelayLevel;
import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.message.common.utils.DictHelper;
import com.bizvane.message.mappers.MsgSendTimePOMapper;
import com.bizvane.message.mappers.MsgSmsRecordPoMapper;
import com.bizvane.message.po.MsgSmsRecordPo;
import com.bizvane.message.service.SmsMessageLogService;
import com.bizvane.messagebase.common.constants.SysResponseEnum;
import com.bizvane.messagebase.model.po.MsgSendTimePO;
import com.bizvane.messagebase.model.po.MsgSendTimePOExample;
import com.bizvane.messagebase.model.po.MsgSmsLogPO;
import com.bizvane.messagebase.model.po.SysCodeValuePO;
import com.bizvane.messagefacade.models.vo.SysSmsConfigVO;
import com.bizvane.utils.responseinfo.ResponseData;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public abstract class MessageBaseProcess {
    private static final Logger log = LoggerFactory.getLogger(MessageBaseProcess.class);
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private MsgSendTimePOMapper msgSendTimePOMapper;
    @Autowired
    private MsgSmsRecordPoMapper msgSmsRecordPoMapper;
    @Autowired
    RocketMQTemplate rocketMQTemplate;
    @Autowired
    private SmsMessageLogService smsMessageLogService;

    public ResponseData<String> send(String str) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        ResponseData sysSmsConfigVOResponseData = new ResponseData();
        sysSmsConfigVOResponseData.setCode(SysResponseEnum.FAILED.getCode());
        ResponseData msgSendTimePOResponseData = new ResponseData();
        msgSendTimePOResponseData.setCode(SysResponseEnum.FAILED.getCode());
        responseData = this.notNullCheck(str);
        if (responseData.getCode() == SysResponseEnum.SUCCESS.getCode() && (responseData = this.templateExistCheck((String)responseData.getData())).getCode() == SysResponseEnum.SUCCESS.getCode() && (sysSmsConfigVOResponseData = this.channelExistCheck((String)responseData.getData())).getCode() == SysResponseEnum.SUCCESS.getCode()) {
            String sign = ((SysSmsConfigVO)sysSmsConfigVOResponseData.getData()).getSign();
            msgSendTimePOResponseData = this.harassCheck(str);
            if (msgSendTimePOResponseData.getCode() == SysResponseEnum.SUCCESS.getCode()) {
                MsgSendTimePO msgSendTimePO = (MsgSendTimePO)JSON.toJavaObject((JSON)JSONObject.parseObject((String)((String)msgSendTimePOResponseData.getData())), MsgSendTimePO.class);
                Date startDate = msgSendTimePO.getSendTimeStart();
                Date endDate = msgSendTimePO.getSendTimeEnd();
                SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
                SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
                Date nowTime = new Date();
                String timeStr = sdf.format(nowTime);
                Date nowDate = null;
                try {
                    nowDate = sdf.parse(timeStr);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                Boolean flag = MessageBaseProcess.isEffectiveDate((Date)nowDate, (Date)startDate, (Date)endDate);
                log.info("flag:{}", (Object)flag);
                if (!flag.booleanValue()) {
                    log.info("\u5904\u7406\u6d88\u606f\uff1a{},\u68c0\u6d4b\u5230\u9632\u9a9a\u6270\u65f6\u6bb5\u7684\u5f00\u59cb\u65f6\u95f4\u4e3a:{},\u7ed3\u675f\u65f6\u95f4\u4e3a:{}\uff0c", new Object[]{str, format.format(startDate), format.format(endDate)});
                    this.reSendMessage(str, startDate);
                    responseData.setMessage("\u9632\u9a9a\u6270\u62e6\u622a,\u6d88\u606f\u88ab\u91cd\u65b0\u5199\u56demq");
                    return responseData;
                }
            }
            ResponseData insertResponseData = this.insertRecord(str);
            String msgSmsRecordIds = (String)insertResponseData.getData();
            ResponseData integerResponseData = this.sendMessage((SysSmsConfigVO)sysSmsConfigVOResponseData.getData());
            int sendCount = (Integer)this.getRealSendCount(str, sign).getData();
            this.updateRecord(integerResponseData, msgSmsRecordIds, sendCount);
        }
        if (responseData.getCode() == SysResponseEnum.FAILED.getCode()) {
            log.info("\u77ed\u4fe1\u4e3b\u52a8\u62d2\u7edd\u53d1\u9001:{}", (Object)responseData.getMessage());
        } else if (sysSmsConfigVOResponseData.getCode() == SysResponseEnum.FAILED.getCode()) {
            log.info("\u77ed\u4fe1\u4e3b\u52a8\u62d2\u7edd\u53d1\u9001:{}", (Object)sysSmsConfigVOResponseData.getMessage());
        }
        return responseData;
    }

    public abstract ResponseData<String> notNullCheck(String var1);

    public abstract ResponseData<String> templateExistCheck(String var1);

    public abstract ResponseData<SysSmsConfigVO> channelExistCheck(String var1);

    public abstract ResponseData<String> harassCheck(String var1);

    public abstract ResponseData<Integer> sendMessage(SysSmsConfigVO var1);

    public abstract ResponseData<String> insertRecord(String var1);

    public abstract void updateRecord(ResponseData<Integer> var1, String var2, int var3);

    public abstract void insertMongo(ResponseData<Integer> var1, String var2);

    public ResponseData<String> notNullCheckCommon(String str) {
        JSONObject jsonObject = JSON.parseObject((String)str);
        ResponseData responseData = new ResponseData();
        Long sysBrandId = jsonObject.getLong("sysBrandId");
        if (sysBrandId == null) {
            log.error(this.getClass().getName() + "sysBrandId:\u54c1\u724cid\u5185\u5bb9\u4e3a\u7a7a");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u54c1\u724cid\u5185\u5bb9\u4e3a\u7a7a");
            return responseData;
        }
        String sysCompanyId = jsonObject.getString("sysCompanyId");
        if (sysCompanyId == null) {
            log.error(this.getClass().getName() + "sysCompanyId:\u4f01\u4e1aid\u5185\u5bb9\u4e3a\u7a7a");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u4f01\u4e1aid\u5185\u5bb9\u4e3a\u7a7a");
            return responseData;
        }
        String phone = jsonObject.getString("phone");
        String phones = jsonObject.getString("phones");
        if (StringUtils.isBlank((CharSequence)phone) && StringUtils.isBlank((CharSequence)phones)) {
            log.error(this.getClass().getName() + "phone:\u624b\u673a\u53f7\u4e3a\u7a7a");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u624b\u673a\u53f7\u4e3a\u7a7a");
            return responseData;
        }
        String memberOnlineServiceStoreCode = jsonObject.getString("memberOnlineServiceStoreCode");
        String memberOnlineServiceStoreCodes = jsonObject.getString("memberOnlineServiceStoreCodes");
        if (StringUtils.isBlank((CharSequence)memberOnlineServiceStoreCode) && StringUtils.isBlank((CharSequence)memberOnlineServiceStoreCodes)) {
            log.error(this.getClass().getName() + "memberOnlineServiceStoreCode:\u4f1a\u5458\u7684\u7ebf\u4e0a\u6240\u5c5e\u95e8\u5e97code\u4e3a\u7a7a");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u4f1a\u5458\u7684\u7ebf\u4e0a\u6240\u5c5e\u95e8\u5e97code\u4e3a\u7a7a");
            return responseData;
        }
        String msgContent = jsonObject.getString("msgContent");
        if (StringUtils.isBlank((CharSequence)msgContent)) {
            log.error(this.getClass().getName() + "msgContent:\u77ed\u4fe1\u5185\u5bb9\u4e3a\u7a7a");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u77ed\u4fe1\u5185\u5bb9\u4e3a\u7a7a");
            return responseData;
        }
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)str);
        return responseData;
    }

    public ResponseData<String> commonHarassCheck(String str) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        responseData.setMessage(SysResponseEnum.FAILED.getMessage());
        String businessModuleCode = JSON.parseObject((String)str).getString("scene");
        long sysBrandId = JSON.parseObject((String)str).getLong("sysBrandId");
        if (businessModuleCode.equals("ACTIVITY_TEMPLATE_MESSAGE") || businessModuleCode.equals("SMS_COUPON_RECEIVE") || businessModuleCode.equals("SMS_COUPON_EXPIRE") || businessModuleCode.equals("SMS_INTEGRAL_ADD")) {
            String result = (String)this.redisTemplate.opsForValue().get((Object)("sendMessageTime" + sysBrandId));
            if (result == null) {
                MsgSendTimePOExample msgSendTimePOExample = new MsgSendTimePOExample();
                msgSendTimePOExample.createCriteria().andSysBrandIdEqualTo(Long.valueOf(sysBrandId)).andValidEqualTo(Boolean.valueOf(true));
                List msgSendTimePOList = this.msgSendTimePOMapper.selectByExample(msgSendTimePOExample);
                if (!CollectionUtils.isEmpty((Collection)msgSendTimePOList)) {
                    MsgSendTimePO msgSendTimePO = (MsgSendTimePO)msgSendTimePOList.get(0);
                    responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                    responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                    String data = JSON.toJSONString((Object)msgSendTimePO);
                    log.info("data:{}", (Object)data);
                    responseData.setData((Object)data);
                    this.redisTemplate.opsForValue().set((Object)("sendMessageTime" + sysBrandId), (Object)data, 5L, TimeUnit.MINUTES);
                }
            } else {
                log.info("\u4eceredis\u4e2d\u83b7\u53d6\u5230\u7684result:{}", (Object)result);
                responseData.setCode(SysResponseEnum.SUCCESS.getCode());
                responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
                responseData.setData((Object)result);
            }
        }
        return responseData;
    }

    public ResponseData<String> insertRecordCommon(String str) {
        ResponseData responseData = new ResponseData();
        JSONObject jsonObject = JSON.parseObject((String)str);
        Long sysBrandId = jsonObject.getLong("sysBrandId");
        Long sysCompanyId = jsonObject.getLong("sysCompanyId");
        String memberPhone = jsonObject.getString("phone");
        String memberName = jsonObject.getString("memberName");
        String scene = jsonObject.getString("scene");
        Long mkt_activity_id = jsonObject.getLong("mkt_activity_id");
        Long mkt_create_user_id = jsonObject.getLong("mkt_create_user_id");
        String memberOnlineServiceStoreCode = jsonObject.getString("memberOnlineServiceStoreCode");
        MsgSmsRecordPo msgSmsRecordPo = new MsgSmsRecordPo();
        msgSmsRecordPo.setSysBrandId(sysBrandId);
        msgSmsRecordPo.setSysCompanyId(sysCompanyId);
        msgSmsRecordPo.setMemberPhone(memberPhone);
        msgSmsRecordPo.setMemberName(memberName);
        msgSmsRecordPo.setMemberOnlineServiceStoreCode(memberOnlineServiceStoreCode);
        msgSmsRecordPo.setContent(jsonObject.getString("msgContent"));
        msgSmsRecordPo.setCreateDate(new Date());
        msgSmsRecordPo.setSceneCode(scene);
        SysCodeValuePO sysCodeValuePO = DictHelper.getDict((String)"template_type_sms", (String)jsonObject.getString("scene"));
        if (sysCodeValuePO == null) {
            msgSmsRecordPo.setScene("\u9a8c\u8bc1\u7801");
        } else {
            String templateTypeName = DictHelper.getDict((String)"template_type_sms", (String)jsonObject.getString("scene")).getItemCodeName();
            msgSmsRecordPo.setScene(templateTypeName);
        }
        msgSmsRecordPo.setSendState(Integer.valueOf(0));
        msgSmsRecordPo.setMktActivityId(mkt_activity_id);
        msgSmsRecordPo.setMktCreateUserId(mkt_create_user_id);
        msgSmsRecordPo.setTrace(MDC.get((String)"traceId"));
        this.msgSmsRecordPoMapper.insertSelective(msgSmsRecordPo);
        responseData.setData((Object)String.valueOf(msgSmsRecordPo.getMsgSmsRecordId()));
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public void updateRecordCommon(ResponseData<Integer> integerResponseData, String msgSmsRecordIds, int sendCount) {
        MsgSmsRecordPo update = new MsgSmsRecordPo();
        update.setMsgSmsRecordId(Long.valueOf(msgSmsRecordIds));
        if (integerResponseData.getCode() == SysResponseEnum.SUCCESS.getCode()) {
            update.setSendResult("\u6210\u529f");
            update.setSendState(Integer.valueOf(1));
            update.setSendResultCount(Integer.valueOf(sendCount));
            this.msgSmsRecordPoMapper.updateByPrimaryKeySelective(update);
        } else {
            update.setSendResult("\u5931\u8d25");
            update.setSendState(Integer.valueOf(-1));
            update.setFailDetail(integerResponseData.getMessage());
            this.msgSmsRecordPoMapper.updateByPrimaryKeySelective(update);
        }
    }

    public void insertMongoCommon(ResponseData<Integer> integerResponseData, String str) {
        JSONObject jsonObject = JSON.parseObject((String)str);
        MsgSmsLogPO insertPO = new MsgSmsLogPO();
        if (!StringUtils.isBlank((CharSequence)jsonObject.getString("phone"))) {
            insertPO.setBussinessId(jsonObject.getString("phone"));
        }
        if (!StringUtils.isBlank((CharSequence)jsonObject.getString("memberName"))) {
            insertPO.setMemberName(jsonObject.getString("memberName"));
        }
        if (!StringUtils.isBlank((CharSequence)jsonObject.getString("scene"))) {
            insertPO.setTemplateType(jsonObject.getString("scene"));
        }
        insertPO.setCreateDate(new Date());
        SysCodeValuePO sysCodeValuePO = DictHelper.getDict((String)"template_type_sms", (String)jsonObject.getString("scene"));
        if (sysCodeValuePO == null) {
            insertPO.setTemplateTypeName("\u9a8c\u8bc1\u7801");
        } else {
            String templateTypeName = DictHelper.getDict((String)"template_type_sms", (String)jsonObject.getString("scene")).getItemCodeName();
            insertPO.setTemplateTypeName(templateTypeName);
        }
        if (!StringUtils.isBlank((CharSequence)jsonObject.getString("phone"))) {
            insertPO.setMemberPhone(jsonObject.getString("phone"));
        }
        insertPO.setMessageBody(str);
        if (!StringUtils.isBlank((CharSequence)jsonObject.getString("sysBrandId"))) {
            insertPO.setSysBrandId(jsonObject.getLong("sysBrandId"));
        }
        if (integerResponseData.getCode() == SysResponseEnum.SUCCESS.getCode()) {
            insertPO.setSendState(Integer.valueOf(1));
            insertPO.setResultInfo("\u6210\u529f");
        } else {
            insertPO.setSendState(Integer.valueOf(-1));
            insertPO.setResultInfoDetail(integerResponseData.getMessage());
            insertPO.setResultInfo("\u5931\u8d25");
        }
        this.smsMessageLogService.insert(insertPO);
        log.info("\u63d2\u5165\u5230mongo\u6210\u529f:{},\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)insertPO), (Object)insertPO.get_id());
    }

    private static boolean isEffectiveDate(Date nowTime, Date startTime, Date endTime) {
        if (nowTime.getTime() == startTime.getTime() || nowTime.getTime() == endTime.getTime()) {
            return true;
        }
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(startTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return date.after(begin) && date.before(end);
    }

    public ResponseData<Integer> getRealSendCount(String str, String sign) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        JSONObject jsonObject = JSON.parseObject((String)str);
        String msgContent = jsonObject.getString("msgContent");
        String messageContent = sign + msgContent;
        double length = messageContent.length();
        double singleLength = 67.0;
        if (length <= 70.0) {
            responseData.setData((Object)1);
        } else {
            responseData.setData((Object)new Double(Math.ceil(length / singleLength)).intValue());
        }
        return responseData;
    }

    public void reSendMessage(String str, Date startDate) {
        JSONObject jsonObject = JSON.parseObject((String)str);
        String topic = jsonObject.getString("topic");
        String tag = jsonObject.getString("tag");
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        Date nowTime = new Date();
        String timeStr = sdf.format(nowTime);
        Date nowDate = null;
        try {
            nowDate = sdf.parse(timeStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Map map = MessageBaseProcess.getTimeInterval((Date)nowDate, (Date)startDate);
        double hour = (Double)map.get("hour");
        double min = (Double)map.get("min");
        MessageDelayLevel messageDelayLevel = MessageDelayLevel._1m;
        if (hour >= 2.0) {
            messageDelayLevel = MessageDelayLevel._2h;
        } else if (hour == 1.0 && min != 0.0) {
            messageDelayLevel = MessageDelayLevel._2h;
        } else if (hour == 1.0 && min == 0.0) {
            messageDelayLevel = MessageDelayLevel._1h;
        } else if (min > 30.0) {
            messageDelayLevel = MessageDelayLevel._1h;
        } else if (min > 20.0) {
            messageDelayLevel = MessageDelayLevel._30m;
        } else if (min > 10.0) {
            messageDelayLevel = MessageDelayLevel._20m;
        } else if (min > 9.0) {
            messageDelayLevel = MessageDelayLevel._10m;
        } else if (min > 8.0) {
            messageDelayLevel = MessageDelayLevel._9m;
        } else if (min > 7.0) {
            messageDelayLevel = MessageDelayLevel._8m;
        } else if (min > 6.0) {
            messageDelayLevel = MessageDelayLevel._7m;
        } else if (min > 5.0) {
            messageDelayLevel = MessageDelayLevel._6m;
        } else if (min > 4.0) {
            messageDelayLevel = MessageDelayLevel._5m;
        } else if (min > 3.0) {
            messageDelayLevel = MessageDelayLevel._4m;
        } else if (min > 2.0) {
            messageDelayLevel = MessageDelayLevel._3m;
        } else if (min > 1.0) {
            messageDelayLevel = MessageDelayLevel._2m;
        }
        jsonObject.put("reSend", (Object)"1");
        String reSendTime = jsonObject.getString("reSendTime");
        reSendTime = reSendTime != null ? String.valueOf(Integer.valueOf(reSendTime) + 1) : "0";
        jsonObject.put("reSendTime", (Object)reSendTime);
        SendResult sendResult = this.rocketMQTemplate.send(Destination.builder().topic(topic).tag(tag).delayLevel(messageDelayLevel).build(), (Object)jsonObject.toJSONString());
        String messageId = sendResult.getMsgId();
        log.info("reSendMessage\t\u6d88\u606f\u91cd\u65b0\u53d1\u9001\u5b8c\u6210mq\u8fd4\u56de\u7684msgId:{},\u5ef6\u8fdf\u7684\u65f6\u95f4\u662f:{}", (Object)messageId, (Object)messageDelayLevel.getLevel());
    }

    public static Map<String, Double> getTimeInterval(Date nowDate, Date startDate) {
        long nd = 86400000L;
        long nh = 3600000L;
        long nm = 60000L;
        long diff = startDate.getTime() - nowDate.getTime();
        double day = diff / nd;
        double hour = diff % nd / nh;
        double min = Math.ceil((double)diff % (double)nd % (double)nh / (double)nm);
        HashMap<String, Double> map = new HashMap<String, Double>();
        map.put("hour", hour);
        map.put("min", min);
        return map;
    }
}

