/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.controller;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.message.common.utils.UUIDGeneratorId;
import com.bizvane.message.service.MsgSmsTempService;
import com.bizvane.message.service.RocketMQSendSmsService;
import com.bizvane.message.service.RocketMQWechatService;
import com.bizvane.message.service.SmsMessageLogService;
import com.bizvane.message.service.WxMessagetempService;
import com.bizvane.messagebase.model.po.MsgSmsTempPO;
import com.bizvane.messagefacade.enums.MsgTemplateType;
import com.bizvane.messagefacade.models.vo.ActivityMessageVO;
import com.bizvane.messagefacade.models.vo.GenMessageVO;
import com.bizvane.messagefacade.models.vo.GenrealGetMessageVO;
import com.bizvane.messagefacade.models.vo.GenrealSendMessageVO;
import com.bizvane.messagefacade.models.vo.GenrealTemMessage;
import com.bizvane.messagefacade.models.vo.Result;
import com.bizvane.messagefacade.models.vo.SendTuWenMessageVO;
import com.bizvane.messagefacade.models.vo.SmsStatisticsVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/templateMessage"})
public class TemplateMessageController {
    private static final Logger log = LoggerFactory.getLogger(TemplateMessageController.class);
    @Autowired
    private RocketMQWechatService rocketMQWechatService;
    @Autowired
    private RocketMQSendSmsService rocketMQSendSmsService;
    @Autowired
    private SmsMessageLogService smsMessageLogService;
    @Autowired
    private WxMessagetempService wxMessagetempService;
    @Autowired
    private MsgSmsTempService msgSmsTempService;

    @PostMapping(value={"/sendWxGenTemplateMessage"})
    public Result<String> sendWxGenTemplateMessage(@RequestBody GenMessageVO vo) {
        vo.setPhoneStr(vo.getMessagejo().getString("phoneStr"));
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)vo));
        jsonObject.put("\u4f59\u989d\u53d8\u52a8\u7c7b\u578b", vo.getMessagejo().get((Object)"keyword1"));
        jsonObject.put("\u4f59\u989d\u53d8\u52a8\u989d\u5143", vo.getMessagejo().get((Object)"keyword2"));
        jsonObject.put("\u5f53\u524d\u4f59\u989d\u5143", vo.getMessagejo().get((Object)"keyword3"));
        jsonObject.put("\u4ea4\u6613\u95e8\u5e97", vo.getMessagejo().get((Object)"keyword4"));
        jsonObject.put("\u4f59\u989d\u53d8\u52a8\u65f6\u95f4", vo.getMessagejo().get((Object)"keyword5"));
        jsonObject.put("\u4f1a\u5458\u5361\u53f7", vo.getMessagejo().get((Object)"keyword6"));
        jsonObject.put("\u5173\u8054\u8ba2\u5355\u53f7", vo.getMessagejo().get((Object)"keyword7"));
        log.info("enter sendWxGenTemplateMessage method!" + jsonObject.toString());
        jsonObject.put("rocketMQTopic", (Object)"public_bizvane_message");
        jsonObject.put("rocketMQTag", (Object)"GEN_WXTEMPLATE_MESSAGE");
        jsonObject.put("bussinessModuleCode", (Object)"GEN_WXTEMPLATE_MESSAGE");
        jsonObject.put("bussinessType", (Object)"wechatGenTemplateMessage");
        jsonObject.put("rocketMQBussinessId", (Object)UUIDGeneratorId.getIdBySeconds());
        if (MsgTemplateType.BEI_OU_GEN_WXTEMPLATE_MESSAGE.getCode().equals(vo.getTemplateType())) {
            log.info("enter sendWxGenTemplateMessage only \u5317\u6b27\u5e01\u53ea\u53d1\u5fae\u4fe1" + jsonObject.toString());
            return this.rocketMQWechatService.sendMessage(jsonObject.toJSONString());
        }
        return this.rocketMQWechatService.sendMessage(jsonObject.toJSONString());
    }

    @PostMapping(value={"/sendOnlyWxGenTemplateMessage"})
    public Result<String> sendOnlyWxGenTemplateMessage(@RequestBody GenMessageVO vo) {
        vo.setPhoneStr(vo.getMessagejo().getString("phoneStr"));
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)vo));
        jsonObject.put("\u4f59\u989d\u53d8\u52a8\u7c7b\u578b", vo.getMessagejo().get((Object)"keyword1"));
        if (StringUtils.isNotEmpty((String)vo.getTemplateType()) && MsgTemplateType.CONSUME_GEN_WXTEMPLATE_MESSAGE.getCode().equals(vo.getTemplateType())) {
            jsonObject.put("\u6d88\u8d39\u91d1\u989d", vo.getMessagejo().get((Object)"keyword2"));
            jsonObject.put("\u5f53\u524d\u4f59\u989d\u5143", vo.getMessagejo().get((Object)"keyword3"));
            jsonObject.put("\u6d88\u8d39\u95e8\u5e97", vo.getMessagejo().get((Object)"keyword4"));
            jsonObject.put("\u6d88\u8d39\u65f6\u95f4", vo.getMessagejo().get((Object)"keyword5"));
            jsonObject.put("\u4f1a\u5458\u5361\u53f7", vo.getMessagejo().get((Object)"keyword6"));
            jsonObject.put("\u5173\u8054\u8ba2\u5355\u53f7", vo.getMessagejo().get((Object)"keyword7"));
            jsonObject.put("\u4f1a\u5458\u59d3\u540d", vo.getMessagejo().get((Object)"keyword8"));
            jsonObject.put("\u50a8\u503c\u5361\u53f7", vo.getMessagejo().get((Object)"keyword9"));
        } else if (StringUtils.isNotEmpty((String)vo.getTemplateType()) && MsgTemplateType.RECHARGE_GIVE_BALANCE_MESSAGE.getCode().equals(vo.getTemplateType())) {
            jsonObject.put("\u8f6c\u8d60\u91d1\u989d", vo.getMessagejo().get((Object)"keyword2"));
            jsonObject.put("\u8d26\u6237\u4f59\u989d", vo.getMessagejo().get((Object)"keyword3"));
            jsonObject.put("\u8f6c\u51fa\u4eba\uff08\u5fae\u4fe1\u6635\u79f0\uff09", vo.getMessagejo().get((Object)"keyword4"));
            jsonObject.put("\u8f6c\u8d26\u65f6\u95f4", vo.getMessagejo().get((Object)"keyword5"));
        } else if (StringUtils.isNotEmpty((String)vo.getTemplateType()) && MsgTemplateType.RECHARGE_GIVE_OVERDUE_MESSAGE.getCode().equals(vo.getTemplateType())) {
            jsonObject.put("\u8f6c\u8d60\u91d1\u989d", vo.getMessagejo().get((Object)"keyword2"));
            jsonObject.put("\u8d26\u6237\u4f59\u989d", vo.getMessagejo().get((Object)"keyword3"));
            jsonObject.put("\u8f6c\u51fa\u4eba\uff08\u5fae\u4fe1\u6635\u79f0\uff09", vo.getMessagejo().get((Object)"keyword4"));
            jsonObject.put("\u8f6c\u8d26\u65f6\u95f4", vo.getMessagejo().get((Object)"keyword5"));
        } else if (StringUtils.isNotEmpty((String)vo.getTemplateType()) && MsgTemplateType.RECHARGE_RECEIVE_BALANCE_MESSAGE.getCode().equals(vo.getTemplateType())) {
            jsonObject.put("\u8f6c\u8d60\u91d1\u989d", vo.getMessagejo().get((Object)"keyword2"));
            jsonObject.put("\u8d26\u6237\u4f59\u989d", vo.getMessagejo().get((Object)"keyword3"));
            jsonObject.put("\u63a5\u6536\u4eba\uff08\u5fae\u4fe1\u6635\u79f0\uff09", vo.getMessagejo().get((Object)"keyword4"));
            jsonObject.put("\u8f6c\u8d26\u65f6\u95f4", vo.getMessagejo().get((Object)"keyword5"));
            jsonObject.put("\u8f6c\u51fa\u4eba\uff08\u5fae\u4fe1\u6635\u79f0\uff09", vo.getMessagejo().get((Object)"keyword6"));
        } else if (StringUtils.isNotEmpty((String)vo.getTemplateType()) && MsgTemplateType.RECHARGE_BALANCE_OVERDUE_MESSAGE.getCode().equals(vo.getTemplateType())) {
            jsonObject.put("\u8fc7\u671f\u65f6\u95f4", vo.getMessagejo().get((Object)"keyword2"));
            jsonObject.put("\u8d26\u6237\u4f59\u989d", vo.getMessagejo().get((Object)"keyword3"));
        } else if (StringUtils.isNotEmpty((String)vo.getTemplateType()) && MsgTemplateType.INTEGRAL_SHOP_GEN_WXTEMPLATE_MESSAGE.getCode().equals(vo.getTemplateType())) {
            jsonObject.put("\u4f1a\u5458\u5361\u53f7", vo.getMessagejo().get((Object)"keyword2"));
            jsonObject.put("\u8ba2\u5355\u53f7", vo.getMessagejo().get((Object)"keyword3"));
            jsonObject.put("\u53d1\u8d27\u65f6\u95f4", vo.getMessagejo().get((Object)"keyword4"));
            jsonObject.put("\u7269\u6d41\u516c\u53f8", vo.getMessagejo().get((Object)"keyword5"));
            jsonObject.put("\u5feb\u9012\u5355\u53f7", vo.getMessagejo().get((Object)"keyword6"));
        } else {
            jsonObject.put("\u4f59\u989d\u53d8\u52a8\u989d\u5143", vo.getMessagejo().get((Object)"keyword2"));
            jsonObject.put("\u5f53\u524d\u4f59\u989d\u5143", vo.getMessagejo().get((Object)"keyword3"));
            jsonObject.put("\u6d88\u8d39\u95e8\u5e97", vo.getMessagejo().get((Object)"keyword4"));
            jsonObject.put("\u4f59\u989d\u53d8\u52a8\u65f6\u95f4", vo.getMessagejo().get((Object)"keyword5"));
            jsonObject.put("\u4f1a\u5458\u5361\u53f7", vo.getMessagejo().get((Object)"keyword6"));
            jsonObject.put("\u5173\u8054\u8ba2\u5355\u53f7", vo.getMessagejo().get((Object)"keyword7"));
            jsonObject.put("\u4f1a\u5458\u59d3\u540d", vo.getMessagejo().get((Object)"keyword8"));
            jsonObject.put("\u50a8\u503c\u5361\u53f7", vo.getMessagejo().get((Object)"keyword9"));
        }
        log.info("enter sendOnlyWxGenTemplateMessage method!" + jsonObject.toString());
        jsonObject.put("rocketMQTopic", (Object)"public_bizvane_message");
        jsonObject.put("rocketMQTag", (Object)"GEN_WXTEMPLATE_MESSAGE");
        jsonObject.put("bussinessModuleCode", (Object)"GEN_WXTEMPLATE_MESSAGE");
        jsonObject.put("bussinessType", (Object)"wechatGenTemplateMessage");
        jsonObject.put("rocketMQBussinessId", (Object)UUIDGeneratorId.getIdBySeconds());
        return this.rocketMQWechatService.sendMessage(jsonObject.toJSONString());
    }

    @ApiOperation(value="\u91cd\u7f6e\u6216\u68c0\u6d4b\u5fae\u4fe1\u6a21\u677f", notes="\u91cd\u7f6e\u5fae\u4fe1\u6a21\u677f", tags={"\u91cd\u7f6e\u5fae\u4fe1\u6a21\u677f"}, httpMethod="POST")
    @PostMapping(value={"/getWxTemplateState"})
    public ResponseData<Object> getWxTemplateState(@RequestBody Long sysBrandId) {
        return this.wxMessagetempService.getWxTemplateState(sysBrandId);
    }

    @ApiOperation(value="\u91cd\u7f6e\u6216\u68c0\u6d4b\u5fae\u4fe1\u6a21\u677fNew", notes="\u91cd\u7f6e\u5fae\u4fe1\u6a21\u677f", tags={"\u91cd\u7f6e\u5fae\u4fe1\u6a21\u677f"}, httpMethod="POST")
    @PostMapping(value={"/getWxTemplateStateNew"})
    public ResponseData<Object> getWxTemplateStateNew(Long sysBrandId) {
        return this.wxMessagetempService.getWxTemplateState(sysBrandId);
    }

    @PostMapping(value={"/sendTuWenMessage"})
    public Result<String> sendTuWenMessage(@RequestBody SendTuWenMessageVO vo) {
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)vo));
        jsonObject.put("rocketMQTopic", (Object)"public_bizvane_message");
        jsonObject.put("rocketMQTag", (Object)"TUWEN_TEMPLATE_MESSAGE");
        jsonObject.put("bussinessModuleCode", (Object)"TUWEN_TEMPLATE_MESSAGE");
        jsonObject.put("bussinessType", (Object)"tuWenTemplateMessage");
        jsonObject.put("rocketMQBussinessId", (Object)vo.getTaskId());
        return this.rocketMQWechatService.sendMessage(jsonObject.toJSONString());
    }

    @PostMapping(value={"/sendQyGenrealBatch"})
    public Result<String> sendQyGenrealBatch(@RequestBody GenrealSendMessageVO vo) {
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)vo));
        jsonObject.put("rocketMQTopic", (Object)"public_bizvane_message");
        jsonObject.put("rocketMQTag", (Object)"GEN_QY_TEMPLATE_MESSAGE");
        jsonObject.put("bussinessModuleCode", (Object)"GEN_QY_TEMPLATE_MESSAGE");
        jsonObject.put("bussinessType", (Object)"genYeTemplateMessage");
        jsonObject.put("rocketMQBussinessId", (Object)vo.getTaskId());
        return this.rocketMQWechatService.sendMessage(jsonObject.toJSONString());
    }

    @PostMapping(value={"/getTemplateType"})
    public ResponseData<List<MsgSmsTempPO>> getTemplateType(@RequestBody GenrealTemMessage vo) {
        return this.msgSmsTempService.getQyTemplateByType(vo.getSysBrandId(), vo.getTemplateType(), vo.getTemplateType());
    }

    @PostMapping(value={"/sendGenrealBatch"})
    public Result<String> sendGenrealBatch(@RequestBody GenrealSendMessageVO vo) {
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)vo));
        jsonObject.put("rocketMQTopic", (Object)"public_bizvane_message");
        jsonObject.put("rocketMQTag", (Object)"BATCH_TEMPLATE_MESSAGE");
        jsonObject.put("bussinessModuleCode", (Object)"BATCH_TEMPLATE_MESSAGE");
        jsonObject.put("bussinessType", (Object)"genSmsTemplateMessage");
        jsonObject.put("rocketMQBussinessId", (Object)vo.getTaskId());
        return this.rocketMQWechatService.sendMessage(jsonObject.toJSONString());
    }

    @RequestMapping(value={"getReturnMessage"})
    public ResponseData<SmsStatisticsVO> getReturnMessage(@RequestBody GenrealGetMessageVO genrealGetMessageVO) {
        ResponseData genreal = this.smsMessageLogService.getReturnMessage(genrealGetMessageVO);
        SmsStatisticsVO smsStatisticsVO = (SmsStatisticsVO)genreal.getData();
        ResponseData smsStatistics = new ResponseData();
        smsStatistics.setData((Object)smsStatisticsVO);
        return smsStatistics;
    }

    @PostMapping(value={"/sendTemplateMessage"})
    public Result<String> sendTemplateMessage(@RequestBody ActivityMessageVO vo) {
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)vo));
        jsonObject.put("rocketMQTopic", (Object)"public_bizvane_message");
        jsonObject.put("rocketMQTag", (Object)"ACTIVITY_TEMPLATE_MESSAGE");
        jsonObject.put("bussinessModuleCode", (Object)"ACTIVITY_TEMPLATE_MESSAGE");
        jsonObject.put("bussinessType", (Object)"wechatTemplateMessage");
        jsonObject.put("rocketMQBussinessId", (Object)vo.getMemberCode());
        return this.rocketMQWechatService.sendMessage(jsonObject.toJSONString());
    }

    @PostMapping(value={"/sendSmsTemplateMessage"})
    public Result<String> sendSmsTemplateMessage(@RequestBody ActivityMessageVO vo) {
        JSONObject jsonObjectSms = JSONObject.parseObject((String)JSONObject.toJSONString((Object)vo));
        jsonObjectSms.put("rocketMQTopic", (Object)"public_bizvane_message");
        jsonObjectSms.put("rocketMQTag", (Object)"ACTIVITY_SMS_TEMPLATE_MESSAGE");
        jsonObjectSms.put("bussinessModuleCode", (Object)"ACTIVITY_SMS_TEMPLATE_MESSAGE");
        jsonObjectSms.put("bussinessType", (Object)"smsTemplateMessage");
        jsonObjectSms.put("rocketMQBussinessId", (Object)vo.getMemberPhone());
        return this.rocketMQSendSmsService.sendMessage(jsonObjectSms.toJSONString());
    }
}

