/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger log = LoggerFactory.getLogger(DateUtil.class);
    public static final String HMS = "HH:mm:ss";
    public static final String YMD = "yyyy-MM-dd ";
    public static final String YMDHMS = "yyyy-MM-dd HH:mm:ss";

    public static boolean isEffectiveDate(Date nowTime, Date startTime, Date endTime) {
        if (nowTime.getTime() == startTime.getTime() || nowTime.getTime() == endTime.getTime()) {
            return true;
        }
        Calendar date = Calendar.getInstance();
        Calendar begin = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        date.setTime(nowTime);
        begin.setTime(startTime);
        end.setTime(endTime);
        return date.after(begin) && date.before(end);
    }

    public static boolean isBefore(Date nowTime, Date startTime) {
        if (nowTime.getTime() == startTime.getTime()) {
            return true;
        }
        Calendar date = Calendar.getInstance();
        Calendar begin = Calendar.getInstance();
        date.setTime(nowTime);
        begin.setTime(startTime);
        return date.before(begin);
    }

    public static Date getMinTime(Date firstDate, Date lastDate) {
        if (firstDate.getTime() == lastDate.getTime()) {
            return firstDate;
        }
        Calendar start = Calendar.getInstance();
        Calendar begin = Calendar.getInstance();
        start.setTime(firstDate);
        begin.setTime(lastDate);
        if (start.before(begin)) {
            return firstDate;
        }
        return lastDate;
    }

    public static Date getDate(String hms) throws ParseException {
        return new SimpleDateFormat(HMS).parse(hms);
    }

    public static String format(Date date, String pattern) {
        String returnValue = "";
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            returnValue = df.format(date);
        }
        return returnValue;
    }

    public static Date getYmdJoinHms(Date ymd, String hms) {
        try {
            SimpleDateFormat df = new SimpleDateFormat(YMDHMS);
            SimpleDateFormat ds = new SimpleDateFormat(YMD);
            return df.parse(ds.format(ymd) + hms);
        }
        catch (ParseException e) {
            log.error("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38:" + e);
            return new Date();
        }
    }

    public static Date addDay(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, n);
        return cal.getTime();
    }
}

