/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.service.impl.centerMsg;

import com.bizvane.message.common.network.NetWorkCommon;
import com.bizvane.message.mappers.MsgSmsPhonePOMapper;
import com.bizvane.message.mongo.MsgMongoRepository;
import com.bizvane.messagebase.model.po.MsgSmsPhonePO;
import com.bizvane.messagebase.model.po.MsgSmsPhonePOExample;
import com.bizvane.messagefacade.interfaces.SendCommonMessageFeign;
import com.bizvane.messagefacade.models.vo.SysSmsConfigVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SendCommonMessageImpl
implements SendCommonMessageFeign {
    private static final Logger log = LoggerFactory.getLogger(SendCommonMessageImpl.class);
    @Autowired
    private NetWorkCommon netWorkCommon;
    @Autowired
    private MsgMongoRepository mongoTemplateService;
    @Autowired
    private MsgSmsPhonePOMapper msgSmsPhonePOMapper;
    @Value(value="${smssend.phonewhite}")
    private String phonewhite;
    @Value(value="${smssend.phoneblack}")
    private String phoneblack;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseData<Integer> sendSmg(SysSmsConfigVO vo) {
        ResponseData result = new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage(), null);
        String channelName = vo.getChannelName();
        Boolean resultData = Boolean.FALSE;
        try {
            result = this.sendSmgPhone(vo);
            if (SysResponseEnum.FAILED.getCode() == result.getCode()) {
                ResponseData responseData = result;
                return responseData;
            }
            result = new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage(), null);
            if (!"moments3.4".equals(channelName)) {
                if ("chuangLan253".equals(channelName)) {
                    String resultstr = this.netWorkCommon.sendChuangLan253(vo);
                    if (resultstr.equals("ture")) {
                        resultData = Boolean.TRUE;
                        result.setCode(SysResponseEnum.SUCCESS.getCode());
                        result.setMessage(SysResponseEnum.SUCCESS.getMessage());
                    }
                    result.setCode(SysResponseEnum.FAILED.getCode());
                    result.setMessage(resultstr);
                }
            } else {
                resultData = this.netWorkCommon.sendMsgMoments(vo);
                if (resultData.booleanValue()) {
                    result.setCode(SysResponseEnum.SUCCESS.getCode());
                    result.setMessage(SysResponseEnum.SUCCESS.getMessage());
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.setCode(SysResponseEnum.FAILED.getCode());
            result.setMessage(e.toString());
        }
        finally {
            vo.setStatus(resultData);
            vo.setCreateDate(new Date());
            vo.setCountryCode(result.getMessage());
            this.mongoTemplateService.singleSave((Object)vo);
            return result;
        }
    }

    public ResponseData<Integer> sendSmgPhone(SysSmsConfigVO vo) {
        ResponseData result = new ResponseData(SysResponseEnum.SUCCESS.getCode(), SysResponseEnum.SUCCESS.getMessage(), null);
        try {
            MsgSmsPhonePOExample sysSmsConfigPOExample = new MsgSmsPhonePOExample();
            sysSmsConfigPOExample.createCriteria().andPhoneEqualTo(vo.getPhone()).andValidEqualTo(Boolean.TRUE);
            List sysSmsConfigList = this.msgSmsPhonePOMapper.selectByExample(sysSmsConfigPOExample);
            if (this.phoneblack.equals("true")) {
                for (MsgSmsPhonePO smsTempPO : sysSmsConfigList) {
                    if (!smsTempPO.getTemplateType().booleanValue()) continue;
                    result.setCode(SysResponseEnum.FAILED.getCode());
                    result.setMessage(":\u8be5\u624b\u673a\u53f7\u662f\u9ed1\u540d\u5355\uff0c\u4e0d\u53d1\u9001\u77ed\u4fe1\uff01");
                    return result;
                }
            }
            if (this.phonewhite.equals("true")) {
                for (MsgSmsPhonePO smsTempPO : sysSmsConfigList) {
                    if (smsTempPO.getTemplateType().booleanValue()) continue;
                    return result;
                }
                result.setCode(SysResponseEnum.FAILED.getCode());
                result.setMessage(":\u8be5\u624b\u673a\u53f7\u4e0d\u662f\u767d\u540d\u5355\uff0c\u4e0d\u53d1\u9001\u77ed\u4fe1\uff01");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.setCode(SysResponseEnum.FAILED.getCode());
            result.setMessage(":\u67e5\u8be2\u9ed1\u767d\u540d\u5355\u7cfb\u7edf\u62a5\u9519\uff01");
        }
        return result;
    }
}

