/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.message.common.constants.SystemConstants;
import com.bizvane.message.common.utils.AsyncHttpUtil;
import com.bizvane.message.mappers.MsgWxTempPOMapper;
import com.bizvane.message.service.WxNewTempService;
import com.bizvane.messagebase.common.constants.SysRespConstants;
import com.bizvane.messagebase.model.po.MsgWxTempPO;
import com.bizvane.messagebase.model.po.MsgWxTempPOExample;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WxNewtempServiceImpl
implements WxNewTempService {
    private static final Logger log = LoggerFactory.getLogger(WxNewtempServiceImpl.class);
    @Autowired
    private MsgWxTempPOMapper msgWxTempPOMapper;
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;

    public ResponseData<Object> getWxTemplate(Long sysBrandId) {
        ResponseData responseData = new ResponseData();
        ResponseData publicPO = this.wxPublicServiceFeign.getWxPublicBySysBrandId(sysBrandId);
        if (publicPO.getData() == null) {
            responseData.setCode(SysRespConstants.FAILED.getStatus());
            responseData.setMessage("\u8be5\u54c1\u724c\u83b7\u53d6\u4e0d\u5230Appid\u4fe1\u606f\uff0cWxPublicPO\u662f\u7a7a\uff0c\u54c1\u724cid:" + sysBrandId);
            return responseData;
        }
        ResponseData ACCESS_TOKEN = this.wxPublicServiceFeign.getAccessTokenByAppId(((WxPublicPO)publicPO.getData()).getAppid());
        if (ACCESS_TOKEN.getCode() != SysRespConstants.SUCCESS.getStatus()) {
            responseData.setCode(SysRespConstants.FAILED.getStatus());
            responseData.setMessage("getAppidREE:" + ((WxPublicPO)publicPO.getData()).getAppid());
            return responseData;
        }
        String sendResulttemp = AsyncHttpUtil.doPost((String)("https://api.weixin.qq.com/cgi-bin/template/get_all_private_template?access_token=" + (String)ACCESS_TOKEN.getData()), (String)"");
        log.info("have get sendResulttemp" + sendResulttemp);
        JSONArray dSONArray = JSONArray.parseArray((String)JSONObject.parseObject((String)sendResulttemp).getString("template_list"));
        if (dSONArray == null) {
            log.info("\u7f16\u8f91\u6a21\u677f\u6b21\u6570\u5df2\u8fbe\u4eca\u65e5\u4e0a\u9650\uff0c\u8bf7\u660e\u65e5\u518d\u8bd5\uff01" + sendResulttemp);
            responseData.setCode(200);
            responseData.setMessage("\u7f16\u8f91\u6a21\u677f\u6b21\u6570\u5df2\u8fbe\u4eca\u65e5\u4e0a\u9650\uff0c\u8bf7\u660e\u65e5\u518d\u8bd5\uff01");
            responseData.setData((Object)(sendResulttemp + "ACCESS_TOKEN\uff1a" + ACCESS_TOKEN + ",Appid\uff1a" + ((WxPublicPO)publicPO.getData()).getAppid()));
            return responseData;
        }
        JSONArray newSONArray = new JSONArray();
        if (dSONArray.size() > 0) {
            for (int i = 0; i < dSONArray.size(); ++i) {
                try {
                    JSONObject job = dSONArray.getJSONObject(i);
                    String[] content = job.getString("content").split("\n");
                    JSONObject contentJSONObject = new JSONObject();
                    int sta = 0;
                    int end = content.length - 1;
                    for (String string : content) {
                        if (sta != 0 && sta != end) {
                            contentJSONObject.put(String.valueOf(sta), (Object)string.substring(0, string.indexOf("\uff1a")));
                        }
                        ++sta;
                    }
                    if (contentJSONObject.isEmpty()) {
                        contentJSONObject.put(String.valueOf(sta), (Object)"\u4fe1\u606f");
                        job.put("content", (Object)contentJSONObject);
                    } else {
                        job.put("content", (Object)contentJSONObject);
                    }
                    newSONArray.add((Object)job);
                    continue;
                }
                catch (Exception e) {
                    log.info("have getsendResulttemp\u6a21\u677f\u6570\u636e\u8f6c\u6362\u5f02\u5e38" + dSONArray.getJSONObject(i));
                }
            }
        }
        log.info("have get ACCESS_TOKEN" + JSONObject.toJSONString((Object)sendResulttemp));
        responseData.setData((Object)newSONArray);
        return responseData;
    }

    public ResponseData<Object> saveWxTemplate(MsgWxTempPO po) {
        ResponseData responseData = new ResponseData();
        if (po.getBusinessType() == null || StringUtils.isBlank((CharSequence)po.getBusinessType().toString())) {
            responseData.setCode(SysRespConstants.SYSTEM_DATA_NOT_REPEAT.getStatus());
            responseData.setMessage("\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return responseData;
        }
        if (po.getTemplateType() == null || StringUtils.isBlank((CharSequence)po.getTemplateType().toString())) {
            responseData.setCode(SysRespConstants.SYSTEM_DATA_NOT_REPEAT.getStatus());
            responseData.setMessage("\u5fae\u4fe1\u6a21\u677f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return responseData;
        }
        if (po.getStatus() == null || StringUtils.isBlank((CharSequence)po.getStatus().toString())) {
            responseData.setCode(SysRespConstants.SYSTEM_DATA_NOT_REPEAT.getStatus());
            responseData.setMessage("\u5f00\u542f\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        if (po.getContent() == null || StringUtils.isBlank((CharSequence)po.getContent().toString())) {
            responseData.setCode(SysRespConstants.SYSTEM_DATA_NOT_REPEAT.getStatus());
            responseData.setMessage("\u5fae\u4fe1\u6a21\u677f\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return responseData;
        }
        ResponseData wxPublicPOlist = this.wxPublicServiceFeign.getWxPublicListBySysBrandId(po.getSysBrandId());
        if (CollectionUtils.isEmpty((Collection)((Collection)wxPublicPOlist.getData()))) {
            responseData.setCode(SysRespConstants.SYSTEM_DATA_NOT_EMPTY.getStatus());
            responseData.setMessage("\u8be5\u54c1\u724c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684Appid");
            return responseData;
        }
        for (WxPublicPO wxPublic : (List)wxPublicPOlist.getData()) {
            if (wxPublic.getMiniProgramType().equals("00")) {
                po.setWxPublicId(wxPublic.getWxPublicId());
            }
            if (wxPublic.getMiniProgramType().equals("10") && !"T002".equals(po.getExample())) {
                po.setExample(wxPublic.getAppid());
            }
            if (!wxPublic.getMiniProgramType().equals("20") || !"T002".equals(po.getExample())) continue;
            po.setExample(wxPublic.getAppid());
        }
        MsgWxTempPOExample example = new MsgWxTempPOExample();
        example.createCriteria().andSysBrandIdEqualTo(po.getSysBrandId()).andValidEqualTo(SystemConstants.TABLE_VALID_EFFECTIVE).andTemplateTypeEqualTo(po.getTemplateType());
        List messageTempPOList = this.msgWxTempPOMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty((Collection)messageTempPOList)) {
            po.setWxMessageTempId(((MsgWxTempPO)messageTempPOList.get(0)).getWxMessageTempId());
            po.setModifiedDate(new Date());
            this.msgWxTempPOMapper.updateByPrimaryKeySelective(po);
            responseData.setData((Object)this.msgWxTempPOMapper.updateByPrimaryKeySelective(po));
        } else {
            po.setCreateDate(new Date());
            po.setValid(Boolean.valueOf(true));
            responseData.setData((Object)this.msgWxTempPOMapper.insert(po));
        }
        return responseData;
    }
}

