/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.message.common.utils.PageForm;
import com.bizvane.message.mappers.MsgSmsTempPOMapper;
import com.bizvane.message.mappers.MsgWxTempPOMapper;
import com.bizvane.message.po.MsgSmsRecordPo;
import com.bizvane.message.service.Standard.StandSmsRecordService;
import com.bizvane.message.service.Standard.StandardRocketMQSendSmsService;
import com.bizvane.message.service.Standard.VerificationCodeMessageService;
import com.bizvane.messagebase.common.constants.SysResponseEnum;
import com.bizvane.messagebase.model.po.MsgSmsTempPO;
import com.bizvane.messagebase.model.po.MsgSmsTempPOExample;
import com.bizvane.messagebase.model.po.MsgWxTempPO;
import com.bizvane.messagebase.model.po.MsgWxTempPOExample;
import com.bizvane.messagebase.model.vo.StandardMessageVo;
import com.bizvane.messagebase.model.vo.StandardTemplateVo;
import com.bizvane.messagefacade.models.vo.MsgWxTempMessageVO;
import com.bizvane.messagefacade.models.vo.SmsMessageLogVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/standardMessage"})
public class StandardMessageController {
    private static final Logger log = LoggerFactory.getLogger(StandardMessageController.class);
    @Autowired
    private StandardRocketMQSendSmsService standardRocketMQSendSmsService;
    @Autowired
    private MsgSmsTempPOMapper msgSmsTempPOMapper;
    @Autowired
    private MsgWxTempPOMapper msgWxTempPOMapper;
    @Autowired
    private VerificationCodeMessageService validateCodeMessageService;
    @Autowired
    private StandSmsRecordService standSmsRecordService;

    @PostMapping(value={"/sendSingleMessageImmediately"})
    public ResponseData<String> sendSingleMessageImmediately(@RequestBody StandardMessageVo vo) {
        log.info("sendSingleMessageImmediately param:{}", (Object)JSON.toJSONString((Object)vo));
        return this.validateCodeMessageService.send(vo);
    }

    @PostMapping(value={"/sendSingleMessage"})
    public ResponseData<String> sendSingleMessage(@RequestBody StandardMessageVo vo) {
        log.info("sendSingleMessage param:{}", (Object)JSON.toJSONString((Object)vo));
        JSONObject jsonObjectSms = JSONObject.parseObject((String)JSONObject.toJSONString((Object)vo));
        jsonObjectSms.put("topic", (Object)"public_bizvane_single_message");
        jsonObjectSms.put("tag", (Object)vo.getScene());
        jsonObjectSms.put("scene", (Object)vo.getScene());
        jsonObjectSms.put("msgId", (Object)vo.getMsgId());
        return this.standardRocketMQSendSmsService.sendMessage(jsonObjectSms.toJSONString());
    }

    @PostMapping(value={"/sendBatchMessage"})
    public ResponseData sendBatchMessage(@RequestBody StandardMessageVo vo) {
        log.info("sendBatchMessage param:{}", (Object)JSON.toJSONString((Object)vo));
        JSONObject jsonObjectSms = JSONObject.parseObject((String)JSONObject.toJSONString((Object)vo));
        jsonObjectSms.put("topic", (Object)"public_bizvane_batch_message");
        jsonObjectSms.put("tag", (Object)vo.getScene());
        jsonObjectSms.put("scene", (Object)vo.getScene());
        jsonObjectSms.put("msgId", (Object)vo.getMsgId());
        return this.standardRocketMQSendSmsService.sendMessage(jsonObjectSms.toJSONString());
    }

    @RequestMapping(value={"/getTemplate"})
    public ResponseData<String> getTemplateByBrandIdAndTemType(@RequestBody StandardTemplateVo standardTemplateVo) {
        long sysBrandId = standardTemplateVo.getSysBrandId();
        String templateType = standardTemplateVo.getTemplateType();
        log.info("getTemplateByBrandIdAndTemType sysBrandId:{},templateType:{}", (Object)sysBrandId, (Object)templateType);
        MsgSmsTempPOExample msgSmsTempPOExample = new MsgSmsTempPOExample();
        msgSmsTempPOExample.createCriteria().andSysBrandIdEqualTo(Long.valueOf(sysBrandId)).andTemplateTypeEqualTo(templateType).andValidEqualTo(Boolean.TRUE);
        List smsTempPOList = this.msgSmsTempPOMapper.selectByExample(msgSmsTempPOExample);
        ResponseData responseData = new ResponseData();
        if (CollectionUtils.isEmpty((Collection)smsTempPOList)) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setData(null);
            return responseData;
        }
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)((MsgSmsTempPO)smsTempPOList.get(0)).getContent());
        return responseData;
    }

    @RequestMapping(value={"/getTemplateByTemType"})
    public ResponseData<MsgWxTempMessageVO> getTemplateByTemType(@RequestBody StandardTemplateVo standardTemplateVo) {
        long sysBrandId = standardTemplateVo.getSysBrandId();
        String templateType = standardTemplateVo.getTemplateType();
        log.info("getTemplateByTemType sysBrandId:{},templateType:{}", (Object)sysBrandId, (Object)templateType);
        MsgWxTempPOExample msgWxTempPOExample = new MsgWxTempPOExample();
        msgWxTempPOExample.createCriteria().andSysBrandIdEqualTo(Long.valueOf(sysBrandId)).andTemplateTypeEqualTo(templateType).andValidEqualTo(Boolean.TRUE);
        List wxTempPOList = this.msgWxTempPOMapper.selectByExample(msgWxTempPOExample);
        ResponseData responseData = new ResponseData();
        if (CollectionUtils.isEmpty((Collection)wxTempPOList)) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setData(null);
            return responseData;
        }
        MsgWxTempPO msgWxTempPO = new MsgWxTempPO();
        MsgWxTempMessageVO msgWxTempMessageVO = new MsgWxTempMessageVO();
        BeanUtils.copyProperties((Object)msgWxTempPO, (Object)msgWxTempMessageVO);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)msgWxTempMessageVO);
        return responseData;
    }

    @ApiOperation(value="\u6d88\u606f\u5de5\u5177>>\u77ed\u4fe1\u6d88\u606f\u8bb0\u5f55", notes="\u6d88\u606f\u5de5\u5177>>\u77ed\u4fe1\u6d88\u606f\u8bb0\u5f55", tags={"\u6d88\u606f\u5de5\u5177>>\u77ed\u4fe1\u6d88\u606f\u8bb0\u5f55"}, httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="baseSearchValue", value="\u57fa\u672c\u67e5\u8be2\u6761\u4ef6", required=true, dataType="String"), @ApiImplicitParam(name="memberPhone", value="\u9ad8\u7ea7\u67e5\u8be2\uff1a\u624b\u673a", required=true, dataType="String"), @ApiImplicitParam(name="templateType", value="\u6d88\u606f\u7c7b\u578b\uff1a\u624b\u673a\uff0c\u77ed\u4fe1\u6a21\u677f\u7c7b\u578b(COUPON_RECEIVE-\u5238\u5230\u8d26\u63d0\u9192\uff0cCOUPON_UNRECEIVED-\u5238\u672a\u9886\u53d6\u63d0\u9192\uff0cCOUPON_EXPIRE-\u5238\u5230\u671f\u63d0\u9192\uff0cCOUPON_USE\u5238\u4f7f\u7528\u63d0\u9192\uff0cINTEGRAL_ADD-\u79ef\u5206\u589e\u52a0\u63d0\u9192\uff0cINTEGRAL_SUBTRACT-\u79ef\u5206\u51cf\u5c11\u63d0\u9192\uff0cINTEGRAL_EXPIRE-\u79ef\u5206\u5230\u671f\u63d0\u9192\uff0cINTEGRAL_USE-\u79ef\u5206\u4f7f\u7528\u63d0\u9192\uff0cMEMEBER_REGISTER-\u4f1a\u5458\u6ce8\u518c\u63d0\u9192\uff0cMEMEBER_INVITE_REGISTER-\u4f1a\u5458\u9080\u8bf7\u6ce8\u518c\u63d0\u9192\uff0cMEMEBER_UPGRADE-\u4f1a\u5458\u5347\u7ea7\u63d0\u9192\uff0cMEMEBER_DOWNGRADE-\u4f1a\u5458\u964d\u7ea7\u63d0\u9192\uff0cORDER_OFFLINE_CONSUME-\u7ebf\u4e0b\u8ba2\u5355\u63d0\u9192\uff0cORDER_ONLINE_CONSUME-\u7ebf\u4e0a\u8ba2\u5355\u63d0\u9192\uff0cORDER_PAYMENT-\u8ba2\u5355\u652f\u4ed8\u63d0\u9192\uff0cORDER_SHIP-\u8ba2\u5355\u53d1\u8d27\u63d0\u9192\uff0cORDER_SIGN-\u8ba2\u5355\u7b7e\u6536\u63d0\u9192\uff0cORDER_CANCEL-\u8ba2\u5355\u53d6\u6d88\u63d0\u9192\uff0cORDER_APPRAISAL-\u8ba2\u5355\u8bc4\u4ef7\u63d0\u9192,ACTIVITY_TEMPLATE_MESSAGE\u6d3b\u52a8\u6d88\u606f)',", required=true, dataType="String"), @ApiImplicitParam(name="sendTimeStart", value="\u9ad8\u7ea7\u67e5\u8be2\uff1a\u53d1\u9001\u5f00\u59cb\u65f6\u95f4", required=true, dataType="Date"), @ApiImplicitParam(name="sendTimeEnd", value="\u9ad8\u7ea7\u67e5\u8be2\uff1a\u53d1\u9001\u7ed3\u675f\u65f6\u95f4", required=true, dataType="Date")})
    @PostMapping(value={"getMsgLogPage"})
    public ResponseData<PageInfo<MsgSmsRecordPo>> getMsgLogPage(SmsMessageLogVo smsMessageLogVo) {
        PageForm pageForm = new PageForm();
        pageForm.setPageNum(smsMessageLogVo.getPageNumber());
        pageForm.setPageSize(smsMessageLogVo.getPageSize());
        return this.standSmsRecordService.getSmsMessageRecordPage(smsMessageLogVo, pageForm);
    }

    @PostMapping(value={"getStatistics"})
    public ResponseData getStatistics(SmsMessageLogVo smsMessageLogVo) {
        return this.standSmsRecordService.getSmsMessageRecordStatics(smsMessageLogVo);
    }
}

