/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.controller;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.message.mappers.SysSmsConfigPOMapper;
import com.bizvane.message.service.RocketMQWechatService;
import com.bizvane.message.service.SmsMessageLogService;
import com.bizvane.messagebase.model.po.MsgSmsLogPO;
import com.bizvane.messagebase.model.po.SysSmsConfigPO;
import com.bizvane.messagebase.model.po.SysSmsConfigPOExample;
import com.bizvane.messagefacade.interfaces.SendCommonMessageFeign;
import com.bizvane.messagefacade.models.vo.GenrealSendMessageVO;
import com.bizvane.messagefacade.models.vo.Result;
import com.bizvane.messagefacade.models.vo.SysSmsConfigVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/msg"}, method={RequestMethod.POST})
public class SendMsgController {
    private static final Logger log = LoggerFactory.getLogger(SendMsgController.class);
    @Autowired
    private SendCommonMessageFeign sendCommonMessage;
    @Autowired
    private RocketMQWechatService rocketMQWechatService;
    @Autowired
    private SmsMessageLogService smsMessageLogService;
    @Autowired
    private SysSmsConfigPOMapper sysSmsConfigPOMapper;
    @Value(value="${smsdefaultaccountinfo.channelName}")
    private String channelName;
    @Value(value="${smsdefaultaccountinfo.channelService}")
    private String channelService;
    @Value(value="${smsdefaultaccountinfo.channelAccount}")
    private String channelAccount;
    @Value(value="${smsdefaultaccountinfo.channelPassword}")
    private String channelPassword;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"/sendsmg"})
    public ResponseData<Integer> sendSmg(@RequestBody SysSmsConfigVO vo) {
        ResponseData sendResultssysSmsConfig = new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage(), null);
        try {
            if (vo.getSysBrandId() != null) {
                SysSmsConfigPOExample sysSmsConfigPOExample = new SysSmsConfigPOExample();
                sysSmsConfigPOExample.createCriteria().andSysBrandIdEqualTo(vo.getSysBrandId()).andChannelTypeEqualTo(Integer.valueOf(20)).andValidEqualTo(Boolean.TRUE);
                List sysSmsConfigList = this.sysSmsConfigPOMapper.selectByExample(sysSmsConfigPOExample);
                if (!CollectionUtils.isNotEmpty((Collection)sysSmsConfigList)) {
                    sendResultssysSmsConfig.setCode(SysResponseEnum.FAILED.getCode());
                    sendResultssysSmsConfig.setData((Object)1);
                    sendResultssysSmsConfig.setMessage("\u5f53\u524d\u54c1\u724c\u77ed\u4fe1\u901a\u9053\u6ca1\u6709\u914d\u7f6e!" + vo.getSysBrandId());
                    MsgSmsLogPO insertPO = new MsgSmsLogPO();
                    insertPO.setTemplateType("YZM_TEMPLATE_MESSAGE");
                    insertPO.setTemplateTypeName("\u9a8c\u8bc1\u7801\u77ed\u4fe1");
                    insertPO.setResultInfo("\u6210\u529f");
                    insertPO.setSysBrandId(vo.getSysBrandId());
                    insertPO.setMemberPhone(vo.getPhone());
                    insertPO.setMemberName("\u9a8c\u8bc1\u7801\u77ed\u4fe1");
                    insertPO.setSendState(Integer.valueOf(-1));
                    insertPO.setResultInfoDetail("\u5f53\u524d\u54c1\u724c\u77ed\u4fe1\u901a\u9053\u6ca1\u6709\u914d\u7f6e!");
                    insertPO.setMessageBody(JSONObject.toJSONString((Object)vo));
                    Result insertResult = this.smsMessageLogService.insert(insertPO);
                    return sendResultssysSmsConfig;
                }
                vo.setChannelType(Integer.valueOf(20));
                vo.setChannelName(((SysSmsConfigPO)sysSmsConfigList.get(0)).getChannelName());
                vo.setChannelService(((SysSmsConfigPO)sysSmsConfigList.get(0)).getChannelService());
                vo.setChannelAccount(((SysSmsConfigPO)sysSmsConfigList.get(0)).getChannelAccount());
                vo.setChannelPassword(((SysSmsConfigPO)sysSmsConfigList.get(0)).getChannelPassword());
            } else {
                vo.setChannelType(Integer.valueOf(20));
                vo.setChannelName(this.channelName);
                vo.setChannelService(this.channelService);
                vo.setChannelAccount(this.channelAccount);
                vo.setChannelPassword(this.channelPassword);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            sendResultssysSmsConfig.setCode(SysResponseEnum.FAILED.getCode());
            sendResultssysSmsConfig.setData((Object)1);
            sendResultssysSmsConfig.setMessage("\u627e\u5f53\u524d\u54c1\u724c\u901a\u9053\u63a5\u53e3\u5f02\u5e38\uff01" + vo.getSysBrandId());
            return sendResultssysSmsConfig;
        }
        ResponseData sendResults = this.sendCommonMessage.sendSmg(vo);
        MsgSmsLogPO insertPO = new MsgSmsLogPO();
        insertPO.setTemplateType("YZM_TEMPLATE_MESSAGE");
        insertPO.setTemplateTypeName("\u9a8c\u8bc1\u7801\u77ed\u4fe1");
        insertPO.setResultInfo("\u6210\u529f");
        insertPO.setSysBrandId(vo.getSysBrandId());
        insertPO.setMemberPhone(vo.getPhone());
        insertPO.setMemberName("\u9a8c\u8bc1\u7801\u77ed\u4fe1");
        if (SysResponseEnum.SUCCESS.getCode() == sendResults.getCode()) {
            insertPO.setSendState(Integer.valueOf(1));
        } else {
            insertPO.setSendState(Integer.valueOf(-1));
            insertPO.setResultInfoDetail(sendResults.getMessage());
        }
        insertPO.setMessageBody(JSONObject.toJSONString((Object)vo) + sendResults.getMessage());
        Result insertResult = this.smsMessageLogService.insert(insertPO);
        return sendResults;
    }

    @PostMapping(value={"/sendBatchsmg"})
    public ResponseData<Integer> sendSmgBatch(@RequestBody SysSmsConfigVO vo) {
        GenrealSendMessageVO vosend = new GenrealSendMessageVO();
        vosend.setSysBrandId(vo.getSysBrandId());
        vosend.setPhoneStr(vo.getPhones());
        vosend.setMessageBody(vo.getMsgContent());
        vosend.setMemberName("\u8425\u9500\u6279\u91cf" + vo.getMsgId());
        vosend.setTemplateType("BATCH_TEMPLATE_MESSAGE");
        vosend.setSendTime(new Date());
        vosend.setTaskId(Long.valueOf(vo.getMsgId()));
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)vosend));
        jsonObject.put("rocketMQTopic", (Object)"public_bizvane_message");
        jsonObject.put("rocketMQTag", (Object)"BATCH_TEMPLATE_MESSAGE");
        jsonObject.put("bussinessModuleCode", (Object)"BATCH_TEMPLATE_MESSAGE");
        jsonObject.put("bussinessType", (Object)"genSmsTemplateMessage");
        jsonObject.put("rocketMQBussinessId", (Object)vo.getMsgId());
        Result result = this.rocketMQWechatService.sendMessage(jsonObject.toJSONString());
        ResponseData resultInteger = new ResponseData(SysResponseEnum.SUCCESS.getCode(), SysResponseEnum.SUCCESS.getMessage(), null);
        resultInteger.setMessage(result.getMsg());
        return resultInteger;
    }
}

