/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.service.impl.wxtemplatemessage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.members.facade.models.WxChannelInfoModel;
import com.bizvane.members.facade.service.api.WxChannelInfoApiService;
import com.bizvane.members.facade.vo.WxChannelInfoVo;
import com.bizvane.members.facade.vo.WxChannelRelationVo;
import com.bizvane.message.common.utils.DictHelper;
import com.bizvane.message.service.WXTemplateMessageService;
import com.bizvane.message.service.WechatMessageLogService;
import com.bizvane.message.template.UseTemplate;
import com.bizvane.message.template.UseTemplateNot;
import com.bizvane.messagebase.common.constants.SysRespConstants;
import com.bizvane.messagebase.model.po.MsgWxLogPO;
import com.bizvane.messagebase.model.po.MsgWxTempPO;
import com.bizvane.messagefacade.models.vo.ActivityMessageVO;
import com.bizvane.messagefacade.models.vo.Result;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="wXTemplateMessageServiceImpl")
public class WXTemplateMessageServiceImpl
implements WXTemplateMessageService {
    private static final Logger logger = LoggerFactory.getLogger(WXTemplateMessageServiceImpl.class);
    @Autowired
    private WechatMessageLogService wechatMessageLogService;
    @Autowired
    private WxChannelInfoApiService wxChannelInfoApiService;
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;

    public Result<String> sendMessage(String rocketMsgId, String messageBody) {
        String openId;
        logger.info("WXTemplateMessageServiceImpl start sendMessage body : {}", (Object)messageBody);
        Result result = new Result();
        if (StringUtils.isBlank((CharSequence)messageBody)) {
            logger.error(this.getClass().getName() + ".sendMessage\u5165\u53c2\u4e3a\u7a7a");
            return result;
        }
        JSONObject jsonObject = JSON.parseObject((String)messageBody);
        String bussinessId = jsonObject.getString("rocketMQBussinessId");
        MsgWxLogPO insertPO = new MsgWxLogPO();
        if (StringUtils.isNotBlank((CharSequence)jsonObject.getString("templateType")) && jsonObject.getString("templateType").equals("TASK_TEMPLATE_MESSAGE")) {
            insertPO.setTemplateType("TASK_TEMPLATE_MESSAGE");
            insertPO.setTemplateTypeName("\u4efb\u52a1\u6d88\u606f\u63d0\u9192");
        } else if (StringUtils.isNotBlank((CharSequence)jsonObject.getString("templateType")) && jsonObject.getString("templateType").equals("RED_TEMPLATE_MESSAGE")) {
            insertPO.setTemplateType("RED_TEMPLATE_MESSAGE");
            insertPO.setTemplateTypeName("\u7ea2\u5305\u9762\u989d\u5347\u7ea7");
        } else {
            insertPO.setTemplateType(jsonObject.getString("bussinessModuleCode"));
            insertPO.setTemplateTypeName(DictHelper.getDict((String)"template_type_wechat", (String)jsonObject.getString("bussinessModuleCode")).getItemCodeName());
        }
        insertPO.setRocketMsgId(rocketMsgId);
        insertPO.setResultInfo("\u53d1\u9001\u4e2d");
        if (StringUtils.isNotBlank((CharSequence)jsonObject.getString("sysBrandId"))) {
            insertPO.setSysBrandId(jsonObject.getLong("sysBrandId"));
        }
        if (StringUtils.isNotBlank((CharSequence)jsonObject.getString("memberPhone"))) {
            insertPO.setMemberPhone(jsonObject.getString("memberPhone"));
        }
        insertPO.setBussinessId(bussinessId);
        insertPO.setDataBody(messageBody);
        Result insertResult = this.wechatMessageLogService.insert(insertPO);
        String wechatMessageLogId = (String)insertResult.getData();
        Result sendResult = new Result();
        sendResult = StringUtils.isNotBlank((CharSequence)jsonObject.getString("templateType")) && jsonObject.getString("templateType").equals("TASK_TEMPLATE_MESSAGE") ? this.sendMessage(wechatMessageLogId, jsonObject) : (StringUtils.isNotBlank((CharSequence)jsonObject.getString("templateType")) && jsonObject.getString("templateType").equals("RED_TEMPLATE_MESSAGE") ? this.sendMessageRed(wechatMessageLogId, jsonObject) : (StringUtils.isNotBlank((CharSequence)jsonObject.getString("sendtype")) ? this.sendDingXiangMessageHuoDong(wechatMessageLogId, jsonObject) : (StringUtils.isBlank((CharSequence)(openId = jsonObject.getString("openId"))) ? this.sendMessage(wechatMessageLogId, jsonObject) : this.sendMessageHuoDong(wechatMessageLogId, jsonObject))));
        String messageId = null;
        String resultInfo = null;
        String sendState = "05";
        if ((long)SysRespConstants.SUCCESS.getStatus() == sendResult.getStatus()) {
            sendState = "10";
            resultInfo = (String)sendResult.getData();
            messageId = String.valueOf(JSON.parseObject((String)resultInfo).getLong("msgid"));
        } else {
            resultInfo = sendResult.getMsg();
        }
        MsgWxLogPO updatePO = new MsgWxLogPO();
        updatePO.set_id(wechatMessageLogId);
        updatePO.setMessageId(messageId);
        updatePO.setResultInfo(resultInfo);
        updatePO.setSendState(sendState);
        this.wechatMessageLogService.update(updatePO);
        return result;
    }

    public Result<String> sendMessage(String wechatMessageLogId, JSONObject jsonObject) {
        Result result = new Result();
        String memberCode = jsonObject.getString("memberCode");
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            result.setStatus((long)SysRespConstants.WX_MESSAGETEMP_USER_INFO_NOT_EMPTY.getStatus());
            result.setMsg(SysRespConstants.WX_MESSAGETEMP_USER_INFO_NOT_EMPTY.getMsg());
            return result;
        }
        Long sysCompanyId = jsonObject.getLongValue("sysCompanyId");
        Long brandId = jsonObject.getLongValue("sysBrandId");
        WxChannelRelationVo wxChannelRelationVo = new WxChannelRelationVo();
        wxChannelRelationVo.setMemberCode(memberCode);
        wxChannelRelationVo.setSysCompanyId(sysCompanyId);
        wxChannelRelationVo.setBrandId(brandId);
        wxChannelRelationVo.setMiniProgram(Integer.valueOf(1));
        ResponseData memberResult = this.wxChannelInfoApiService.getWxChannelInfoRelation(wxChannelRelationVo);
        WxChannelInfoModel wxChannelInfoVip = (WxChannelInfoModel)memberResult.getData();
        if (null == wxChannelInfoVip) {
            result.setStatus((long)SysRespConstants.WX_VIP_NOT_FOCUS.getStatus());
            result.setMsg(SysRespConstants.WX_VIP_NOT_FOCUS.getMsg());
            return result;
        }
        ObjectMapper mapper = new ObjectMapper();
        WxChannelInfoVo wxChannelInfoModel = new WxChannelInfoVo();
        wxChannelInfoModel.setMemberCode(memberCode);
        ResponseData channelResult = this.wxChannelInfoApiService.getWxChannelInfo(wxChannelInfoModel);
        WxChannelInfoVo channelInfoModel = (WxChannelInfoVo)channelResult.getData();
        WxChannelInfoVo channelVal = null;
        if (null != channelInfoModel) {
            channelVal = (WxChannelInfoVo)mapper.convertValue((Object)channelInfoModel, WxChannelInfoVo.class);
        }
        JSONObject messagejo = new JSONObject();
        ActivityMessageVO integralMessageVO = (ActivityMessageVO)jsonObject.toJavaObject(ActivityMessageVO.class);
        messagejo.put("first", (Object)"\u5c0a\u656c\u7684\u4f1a\u5458\uff0c\u6d3b\u52a8\u5fae\u4fe1\u53d1\u9001");
        messagejo.put("keyword1", (Object)integralMessageVO.getActivityName());
        messagejo.put("keyword2", (Object)integralMessageVO.getActivityInterests());
        if (StringUtils.isNotBlank((CharSequence)jsonObject.getString("activityLongtime")) || StringUtils.isBlank((CharSequence)jsonObject.getString("activityEndDate"))) {
            messagejo.put("keyword3", (Object)"\u957f\u671f\u6709\u6548");
        } else {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd");
            messagejo.put("keyword3", (Object)(formatter.format(integralMessageVO.getActivityStartDate()) + "-" + formatter.format(integralMessageVO.getActivityEndDate())));
        }
        messagejo.put("keyword4", (Object)integralMessageVO.getSysBrandName());
        messagejo.put("remark", (Object)"\u611f\u8c22\u60a8\u7684\u652f\u6301");
        messagejo.put("url", (Object)jsonObject.getString("unl"));
        for (String key : messagejo.keySet()) {
            String value = messagejo.getString(key);
            if (StringUtils.isBlank((CharSequence)value)) {
                value = " ";
            }
            messagejo.put(key, (Object)value);
        }
        logger.info("tempate message :" + messagejo.toString());
        String openId = wxChannelInfoVip.getOpenId();
        MsgWxLogPO wechatMessageLogPO = new MsgWxLogPO();
        wechatMessageLogPO.set_id(wechatMessageLogId);
        wechatMessageLogPO.setWxPublicId(wxChannelInfoVip.getPublicId());
        wechatMessageLogPO.setOpenId(openId);
        wechatMessageLogPO.setMessageBody(messagejo.toString());
        wechatMessageLogPO.setMemberName(channelInfoModel.getName());
        if (channelVal != null) {
            wechatMessageLogPO.setWxNick(channelVal.getWxNick());
        }
        this.wechatMessageLogService.update(wechatMessageLogPO);
        WxPublicPO wxPublicPO = new WxPublicPO();
        wxPublicPO.setWxPublicId(wxChannelInfoVip.getPublicId());
        ResponseData Stringkey = this.wxPublicServiceFeign.getAccessTokenByAppId(wxChannelInfoVip.getAppId());
        wxPublicPO.setAppid((String)Stringkey.getData());
        MsgWxTempPO msgWxTempPO = new MsgWxTempPO();
        msgWxTempPO.setWxTemplateId(jsonObject.getString("wxTemplateId"));
        msgWxTempPO.setFirst(jsonObject.getString("first"));
        msgWxTempPO.setContent(jsonObject.getString("content"));
        msgWxTempPO.setTail(jsonObject.getString("tail"));
        msgWxTempPO.setUrl(jsonObject.getString("unl"));
        ResponseData wxPublicPOlist = this.wxPublicServiceFeign.getWxPublicListBySysBrandId(wxChannelInfoVip.getBrandId());
        if (CollectionUtils.isEmpty((Collection)((Collection)wxPublicPOlist.getData()))) {
            result.setStatus((long)SysRespConstants.WX_VIP_NOT_FOCUS.getStatus());
            result.setMsg(SysRespConstants.WX_VIP_NOT_FOCUS.getMsg());
            return result;
        }
        for (WxPublicPO wxPublic : (List)wxPublicPOlist.getData()) {
            if (!wxPublic.getMiniProgramType().equals("10")) continue;
            msgWxTempPO.setExample(wxPublic.getAppid());
        }
        if (!StringUtils.isBlank((CharSequence)jsonObject.getString("templateType")) && jsonObject.getString("templateType").equals("ACTIVITY_TEMPLATE_MESSAGE_NEW")) {
            return UseTemplateNot.sendMessage((WxPublicPO)wxPublicPO, (String)"ACTIVITY_TEMPLATE_MESSAGE", (String)openId, (MsgWxTempPO)msgWxTempPO);
        }
        return UseTemplate.sendMessage((WxPublicPO)wxPublicPO, (String)"ACTIVITY_TEMPLATE_MESSAGE", (String)openId, (JSONObject)messagejo);
    }

    public Result<String> sendMessageRed(String wechatMessageLogId, JSONObject jsonObject) {
        Result result = new Result();
        String memberCode = jsonObject.getString("memberCode");
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            result.setStatus((long)SysRespConstants.WX_MESSAGETEMP_USER_INFO_NOT_EMPTY.getStatus());
            result.setMsg(SysRespConstants.WX_MESSAGETEMP_USER_INFO_NOT_EMPTY.getMsg());
            return result;
        }
        Long sysCompanyId = jsonObject.getLongValue("sysCompanyId");
        Long brandId = jsonObject.getLongValue("sysBrandId");
        WxChannelRelationVo wxChannelRelationVo = new WxChannelRelationVo();
        wxChannelRelationVo.setMemberCode(memberCode);
        wxChannelRelationVo.setSysCompanyId(sysCompanyId);
        wxChannelRelationVo.setBrandId(brandId);
        wxChannelRelationVo.setMiniProgram(Integer.valueOf(1));
        ResponseData memberResult = this.wxChannelInfoApiService.getWxChannelInfoRelation(wxChannelRelationVo);
        WxChannelInfoModel wxChannelInfoVip = (WxChannelInfoModel)memberResult.getData();
        if (null == wxChannelInfoVip) {
            result.setStatus((long)SysRespConstants.WX_VIP_NOT_FOCUS.getStatus());
            result.setMsg(SysRespConstants.WX_VIP_NOT_FOCUS.getMsg());
            return result;
        }
        ObjectMapper mapper = new ObjectMapper();
        WxChannelInfoVo wxChannelInfoModel = new WxChannelInfoVo();
        wxChannelInfoModel.setMemberCode(memberCode);
        ResponseData channelResult = this.wxChannelInfoApiService.getWxChannelInfo(wxChannelInfoModel);
        WxChannelInfoVo channelInfoModel = (WxChannelInfoVo)channelResult.getData();
        WxChannelInfoVo channelVal = null;
        if (null != channelInfoModel) {
            channelVal = (WxChannelInfoVo)mapper.convertValue((Object)channelInfoModel, WxChannelInfoVo.class);
        }
        JSONObject messagejo = new JSONObject();
        ActivityMessageVO integralMessageVO = (ActivityMessageVO)jsonObject.toJavaObject(ActivityMessageVO.class);
        messagejo.put("first", (Object)"\u6709\u597d\u53cb\u5e2e\u4f60\u52a9\u529b\u5566\uff0c\u7ea2\u5305\u9762\u989d\u5347\u7ea7\uff01");
        messagejo.put("keyword1", (Object)integralMessageVO.getActivityName());
        messagejo.put("keyword2", (Object)integralMessageVO.getActivityInterests());
        messagejo.put("remark", (Object)"\u5feb\u53bb\u62c6\u7ea2\u5305\u5427~");
        messagejo.put("url", (Object)jsonObject.getString("unl"));
        for (String key : messagejo.keySet()) {
            String value = messagejo.getString(key);
            if (StringUtils.isBlank((CharSequence)value)) {
                value = " ";
            }
            messagejo.put(key, (Object)value);
        }
        logger.info("tempate message :" + messagejo.toString());
        String openId = wxChannelInfoVip.getOpenId();
        MsgWxLogPO wechatMessageLogPO = new MsgWxLogPO();
        wechatMessageLogPO.set_id(wechatMessageLogId);
        wechatMessageLogPO.setWxPublicId(wxChannelInfoVip.getPublicId());
        wechatMessageLogPO.setOpenId(openId);
        wechatMessageLogPO.setMessageBody(messagejo.toString());
        wechatMessageLogPO.setMemberName(channelInfoModel.getName());
        if (channelVal != null) {
            wechatMessageLogPO.setWxNick(channelVal.getWxNick());
        }
        this.wechatMessageLogService.update(wechatMessageLogPO);
        WxPublicPO wxPublicPO = new WxPublicPO();
        wxPublicPO.setWxPublicId(wxChannelInfoVip.getPublicId());
        ResponseData Stringkey = this.wxPublicServiceFeign.getAccessTokenByAppId(wxChannelInfoVip.getAppId());
        wxPublicPO.setAppid((String)Stringkey.getData());
        MsgWxTempPO msgWxTempPO = new MsgWxTempPO();
        msgWxTempPO.setWxTemplateId(jsonObject.getString("wxTemplateId"));
        msgWxTempPO.setFirst(jsonObject.getString("first"));
        msgWxTempPO.setContent(jsonObject.getString("content"));
        msgWxTempPO.setUrl(jsonObject.getString("unl"));
        msgWxTempPO.setTail(jsonObject.getString("tail"));
        ResponseData wxPublicPOlist = this.wxPublicServiceFeign.getWxPublicListBySysBrandId(wxChannelInfoVip.getBrandId());
        if (CollectionUtils.isEmpty((Collection)((Collection)wxPublicPOlist.getData()))) {
            result.setStatus((long)SysRespConstants.WX_VIP_NOT_FOCUS.getStatus());
            result.setMsg(SysRespConstants.WX_VIP_NOT_FOCUS.getMsg());
            return result;
        }
        for (WxPublicPO wxPublic : (List)wxPublicPOlist.getData()) {
            if (!wxPublic.getMiniProgramType().equals("10")) continue;
            msgWxTempPO.setExample(wxPublic.getAppid());
        }
        if (StringUtils.isNotBlank((CharSequence)jsonObject.getString("templateType")) && jsonObject.getString("templateType").equals("ACTIVITY_TEMPLATE_MESSAGE_NEW")) {
            return UseTemplateNot.sendMessage((WxPublicPO)wxPublicPO, (String)"ACTIVITY_TEMPLATE_MESSAGE", (String)openId, (MsgWxTempPO)msgWxTempPO);
        }
        return UseTemplate.sendMessage((WxPublicPO)wxPublicPO, (String)"ACTIVITY_TEMPLATE_MESSAGE", (String)openId, (JSONObject)messagejo);
    }

    public Result<String> sendMessageHuoDong(String wechatMessageLogId, JSONObject jsonObject) {
        Result result = new Result();
        WxChannelInfoVo wxChannelInfoVo = new WxChannelInfoVo();
        String openId = jsonObject.getString("openId");
        wxChannelInfoVo.setWxOpenId(openId);
        ResponseData wxChannelInfoVonew = this.wxChannelInfoApiService.getWxChannelInfo(wxChannelInfoVo);
        if (null == wxChannelInfoVonew.getData()) {
            result.setStatus((long)SysRespConstants.WX_VIP_NOT_FOCUS.getStatus());
            result.setMsg(SysRespConstants.WX_VIP_NOT_FOCUS.getMsg());
            return result;
        }
        WxChannelInfoVo wxChannelInfoVip = (WxChannelInfoVo)wxChannelInfoVonew.getData();
        JSONObject messagejo = new JSONObject();
        ActivityMessageVO integralMessageVO = (ActivityMessageVO)jsonObject.toJavaObject(ActivityMessageVO.class);
        messagejo.put("first", (Object)"\u5c0a\u656c\u7684\u4f1a\u5458\uff0c\u6d3b\u52a8\u5fae\u4fe1\u53d1\u9001");
        messagejo.put("keyword1", (Object)integralMessageVO.getActivityName());
        messagejo.put("keyword2", (Object)integralMessageVO.getActivityInterests());
        if (!StringUtils.isBlank((CharSequence)jsonObject.getString("activityLongtime")) || StringUtils.isBlank((CharSequence)jsonObject.getString("activityEndDate"))) {
            messagejo.put("keyword3", (Object)"\u957f\u671f\u6709\u6548");
        } else {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd");
            messagejo.put("keyword3", (Object)(formatter.format(integralMessageVO.getActivityStartDate()) + "-" + formatter.format(integralMessageVO.getActivityEndDate())));
        }
        messagejo.put("keyword4", (Object)integralMessageVO.getSysBrandName());
        messagejo.put("remark", (Object)"\u611f\u8c22\u60a8\u7684\u652f\u6301");
        messagejo.put("url", (Object)jsonObject.getString("unl"));
        for (String key : messagejo.keySet()) {
            String value = messagejo.getString(key);
            if (StringUtils.isBlank((CharSequence)value)) {
                value = " ";
            }
            messagejo.put(key, (Object)value);
        }
        logger.info("tempate message :" + messagejo.toString());
        MsgWxLogPO wechatMessageLogPO = new MsgWxLogPO();
        wechatMessageLogPO.set_id(wechatMessageLogId);
        wechatMessageLogPO.setWxPublicId(wxChannelInfoVip.getWxPublicId());
        wechatMessageLogPO.setOpenId(openId);
        wechatMessageLogPO.setMessageBody(messagejo.toString());
        String memberName = jsonObject.getString("memberName");
        wechatMessageLogPO.setMemberName(memberName);
        wechatMessageLogPO.setWxNick(wxChannelInfoVip.getWxNick());
        this.wechatMessageLogService.update(wechatMessageLogPO);
        WxPublicPO wxPublicPO = new WxPublicPO();
        wxPublicPO.setWxPublicId(wxChannelInfoVip.getWxPublicId());
        ResponseData Stringkey = this.wxPublicServiceFeign.getAccessTokenByAppId(wxChannelInfoVip.getAppId());
        wxPublicPO.setAppid((String)Stringkey.getData());
        MsgWxTempPO msgWxTempPO = new MsgWxTempPO();
        msgWxTempPO.setWxTemplateId(jsonObject.getString("wxTemplateId"));
        msgWxTempPO.setFirst(jsonObject.getString("first"));
        msgWxTempPO.setContent(jsonObject.getString("content"));
        msgWxTempPO.setUrl(jsonObject.getString("unl"));
        msgWxTempPO.setTail(jsonObject.getString("tail"));
        ResponseData wxPublicPOlist = this.wxPublicServiceFeign.getWxPublicListBySysBrandId(wxChannelInfoVip.getBrandId());
        if (CollectionUtils.isEmpty((Collection)((Collection)wxPublicPOlist.getData()))) {
            result.setStatus((long)SysRespConstants.WX_VIP_NOT_FOCUS.getStatus());
            result.setMsg(SysRespConstants.WX_VIP_NOT_FOCUS.getMsg());
            return result;
        }
        for (WxPublicPO wxPublic : (List)wxPublicPOlist.getData()) {
            if (!wxPublic.getMiniProgramType().equals("10")) continue;
            msgWxTempPO.setExample(wxPublic.getAppid());
        }
        if (StringUtils.isNotBlank((CharSequence)jsonObject.getString("templateType")) && jsonObject.getString("templateType").equals("ACTIVITY_TEMPLATE_MESSAGE_NEW")) {
            return UseTemplateNot.sendMessage((WxPublicPO)wxPublicPO, (String)"ACTIVITY_TEMPLATE_MESSAGE", (String)openId, (MsgWxTempPO)msgWxTempPO);
        }
        return UseTemplate.sendMessage((WxPublicPO)wxPublicPO, (String)"ACTIVITY_TEMPLATE_MESSAGE", (String)openId, (JSONObject)messagejo);
    }

    public Result<String> sendDingXiangMessageHuoDong(String wechatMessageLogId, JSONObject jsonObject) {
        Result result = new Result();
        Long sysCompanyId = jsonObject.getLongValue("sysCompanyId");
        Long brandId = jsonObject.getLongValue("sysBrandId");
        String memberCode = jsonObject.getString("memberCode");
        WxChannelRelationVo wxChannelRelationVo = new WxChannelRelationVo();
        wxChannelRelationVo.setMemberCode(memberCode);
        wxChannelRelationVo.setSysCompanyId(sysCompanyId);
        wxChannelRelationVo.setBrandId(brandId);
        wxChannelRelationVo.setMiniProgram(Integer.valueOf(1));
        ResponseData wxChannelInfoVonew = this.wxChannelInfoApiService.getWxChannelInfoRelation(wxChannelRelationVo);
        if (null == wxChannelInfoVonew.getData()) {
            result.setStatus((long)SysRespConstants.WX_VIP_NOT_FOCUS.getStatus());
            result.setMsg(SysRespConstants.WX_VIP_NOT_FOCUS.getMsg());
            return result;
        }
        WxChannelInfoModel wxChannelInfoVip = (WxChannelInfoModel)wxChannelInfoVonew.getData();
        JSONObject messagejo = new JSONObject();
        ActivityMessageVO integralMessageVO = (ActivityMessageVO)jsonObject.toJavaObject(ActivityMessageVO.class);
        messagejo.put("firstDY", (Object)integralMessageVO.getNavigation());
        messagejo.put("keyword1", (Object)integralMessageVO.getActivityName());
        messagejo.put("keyword2", (Object)integralMessageVO.getActivityInterests());
        messagejo.put("keyword3", (Object)integralMessageVO.getActivitytime());
        messagejo.put("keyword4", (Object)integralMessageVO.getBusinessman());
        messagejo.put("remarkDY", (Object)integralMessageVO.getRemark());
        messagejo.put("url", (Object)jsonObject.getString("unl"));
        for (String key : messagejo.keySet()) {
            String value = messagejo.getString(key);
            if (StringUtils.isBlank((CharSequence)value)) {
                value = " ";
            }
            messagejo.put(key, (Object)value);
        }
        logger.info("tempate message :" + messagejo.toString());
        MsgWxLogPO wechatMessageLogPO = new MsgWxLogPO();
        wechatMessageLogPO.set_id(wechatMessageLogId);
        wechatMessageLogPO.setWxPublicId(wxChannelInfoVip.getPublicId());
        wechatMessageLogPO.setOpenId(wxChannelInfoVip.getOpenId());
        wechatMessageLogPO.setMessageBody(messagejo.toString());
        String memberName = jsonObject.getString("memberName");
        wechatMessageLogPO.setMemberName(memberName);
        wechatMessageLogPO.setWxNick(wxChannelInfoVip.getWxNick());
        this.wechatMessageLogService.update(wechatMessageLogPO);
        WxPublicPO wxPublicPO = new WxPublicPO();
        wxPublicPO.setWxPublicId(wxChannelInfoVip.getPublicId());
        ResponseData Stringkey = this.wxPublicServiceFeign.getAccessTokenByAppId(wxChannelInfoVip.getAppId());
        wxPublicPO.setAppid((String)Stringkey.getData());
        MsgWxTempPO msgWxTempPO = new MsgWxTempPO();
        msgWxTempPO.setWxTemplateId(jsonObject.getString("wxTemplateId"));
        msgWxTempPO.setFirst(jsonObject.getString("first"));
        msgWxTempPO.setContent(jsonObject.getString("content"));
        msgWxTempPO.setUrl(jsonObject.getString("unl"));
        msgWxTempPO.setTail(jsonObject.getString("tail"));
        ResponseData wxPublicPOlist = this.wxPublicServiceFeign.getWxPublicListBySysBrandId(wxChannelInfoVip.getBrandId());
        if (CollectionUtils.isEmpty((Collection)((Collection)wxPublicPOlist.getData()))) {
            result.setStatus((long)SysRespConstants.WX_VIP_NOT_FOCUS.getStatus());
            result.setMsg(SysRespConstants.WX_VIP_NOT_FOCUS.getMsg());
            return result;
        }
        for (WxPublicPO wxPublic : (List)wxPublicPOlist.getData()) {
            if (!wxPublic.getMiniProgramType().equals("10")) continue;
            msgWxTempPO.setExample(wxPublic.getAppid());
        }
        if (StringUtils.isNotBlank((CharSequence)jsonObject.getString("templateType")) && jsonObject.getString("templateType").equals("ACTIVITY_TEMPLATE_MESSAGE_NEW")) {
            return UseTemplateNot.sendMessage((WxPublicPO)wxPublicPO, (String)"ACTIVITY_TEMPLATE_MESSAGE", (String)wxChannelInfoVip.getOpenId(), (MsgWxTempPO)msgWxTempPO);
        }
        return UseTemplate.sendMessage((WxPublicPO)wxPublicPO, (String)"ACTIVITY_TEMPLATE_MESSAGE", (String)wxChannelInfoVip.getOpenId(), (JSONObject)messagejo);
    }
}

