/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.service.impl.wxtemplatemessage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.WxChannelInfoApiService;
import com.bizvane.members.facade.vo.MemberInfoApiModel;
import com.bizvane.members.facade.vo.WxChannelInfoVo;
import com.bizvane.message.common.utils.DictHelper;
import com.bizvane.message.service.WXTemplateMessageService;
import com.bizvane.message.service.WechatMessageLogService;
import com.bizvane.message.template.UseTemplate;
import com.bizvane.messagebase.common.constants.SysRespConstants;
import com.bizvane.messagebase.model.po.MsgWxLogPO;
import com.bizvane.messagefacade.models.vo.OrderMessageVO;
import com.bizvane.messagefacade.models.vo.Result;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="wXTemplateMessageOrderPaymentServiceImpl")
public class WXTemplateMessageOrderPaymentServiceImpl
implements WXTemplateMessageService {
    private static final Logger logger = LoggerFactory.getLogger(WXTemplateMessageOrderPaymentServiceImpl.class);
    @Autowired
    private WechatMessageLogService wechatMessageLogService;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private WxChannelInfoApiService wxChannelInfoApiService;

    public Result<String> sendMessage(String rocketMsgId, String messageBody) {
        logger.info(this.getClass().getName() + ".sendMessage\u5165\u53c2\uff1a" + messageBody);
        Result result = new Result();
        if (StringUtils.isBlank((CharSequence)messageBody)) {
            logger.error(this.getClass().getName() + ".sendMessage\u5165\u53c2\u4e3a\u7a7a");
            return result;
        }
        JSONObject jsonObject = JSON.parseObject((String)messageBody);
        String bussinessId = jsonObject.getString("rocketMQBussinessId");
        MsgWxLogPO insertPO = new MsgWxLogPO();
        insertPO.setTemplateType(jsonObject.getString("bussinessModuleCode"));
        insertPO.setTemplateTypeName(DictHelper.getDict((String)"template_type_wechat", (String)jsonObject.getString("bussinessModuleCode")).getItemCodeName());
        insertPO.setRocketMsgId(rocketMsgId);
        insertPO.setResultInfo("\u53d1\u9001\u4e2d");
        if (!StringUtils.isBlank((CharSequence)jsonObject.getString("sysBrandId"))) {
            insertPO.setSysBrandId(jsonObject.getLong("sysBrandId"));
        }
        if (!StringUtils.isBlank((CharSequence)jsonObject.getString("memberPhone"))) {
            insertPO.setMemberPhone(jsonObject.getString("memberPhone"));
        }
        insertPO.setBussinessId(bussinessId);
        insertPO.setDataBody(messageBody);
        Result insertResult = this.wechatMessageLogService.insert(insertPO);
        String wechatMessageLogId = (String)insertResult.getData();
        Result sendResult = this.sendMessage(wechatMessageLogId, jsonObject);
        String messageId = null;
        String resultInfo = null;
        String sendState = "05";
        if ((long)SysRespConstants.SUCCESS.getStatus() == sendResult.getStatus()) {
            sendState = "10";
            resultInfo = (String)sendResult.getData();
            messageId = String.valueOf(JSON.parseObject((String)resultInfo).getLong("msgid"));
        } else {
            resultInfo = sendResult.getMsg();
        }
        MsgWxLogPO updatePO = new MsgWxLogPO();
        updatePO.set_id(wechatMessageLogId);
        updatePO.setMessageId(messageId);
        updatePO.setResultInfo(resultInfo);
        updatePO.setSendState(sendState);
        this.wechatMessageLogService.update(updatePO);
        return result;
    }

    public Result<String> sendMessage(String wechatMessageLogId, JSONObject jsonObject) {
        Result result = new Result();
        String memberCode = jsonObject.getString("memberCode");
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            result.setStatus((long)SysRespConstants.WX_MESSAGETEMP_USER_INFO_NOT_EMPTY.getStatus());
            result.setMsg(SysRespConstants.WX_MESSAGETEMP_USER_INFO_NOT_EMPTY.getMsg());
            return result;
        }
        MemberInfoApiModel infoModel = new MemberInfoApiModel();
        infoModel.setPageNumber(Integer.valueOf(1));
        infoModel.setPageSize(Integer.valueOf(10));
        infoModel.setMemberCode(memberCode);
        ResponseData memberResult = this.memberInfoApiService.getMemberInfo(infoModel);
        List memberList = ((PageInfo)memberResult.getData()).getList();
        if (null == memberList || memberList.size() == 0) {
            result.setStatus((long)SysRespConstants.WX_VIP_NOT_FOCUS.getStatus());
            result.setMsg(SysRespConstants.WX_VIP_NOT_FOCUS.getMsg());
            return result;
        }
        ObjectMapper mapper = new ObjectMapper();
        MemberInfoModel wxVip = (MemberInfoModel)mapper.convertValue(memberList.get(0), MemberInfoModel.class);
        WxChannelInfoVo wxChannelInfoModel = new WxChannelInfoVo();
        wxChannelInfoModel.setMemberCode(memberCode);
        ResponseData channelResult = this.wxChannelInfoApiService.getWxChannelInfo(wxChannelInfoModel);
        WxChannelInfoVo channelInfoModel = (WxChannelInfoVo)channelResult.getData();
        WxChannelInfoVo channelVal = null;
        if (null != channelInfoModel) {
            channelVal = (WxChannelInfoVo)mapper.convertValue((Object)channelInfoModel, WxChannelInfoVo.class);
        }
        if (wxVip == null) {
            result.setStatus((long)SysRespConstants.WX_VIP_NOT_FOCUS.getStatus());
            result.setMsg(SysRespConstants.WX_VIP_NOT_FOCUS.getMsg());
            return result;
        }
        JSONObject messagejo = new JSONObject();
        OrderMessageVO vo = (OrderMessageVO)jsonObject.toJavaObject(OrderMessageVO.class);
        messagejo.put("first", (Object)"\u5c0a\u656c\u7684\u4f1a\u5458\uff0c\u60a8\u7684\u8ba2\u5355\u5df2\u4ed8\u6b3e\u6210\u529f\u3002");
        messagejo.put("keyword1", (Object)vo.getOrderNo());
        messagejo.put("keyword2", (Object)vo.getMoney());
        messagejo.put("keyword3", (Object)vo.getDate());
        messagejo.put("keyword4", (Object)vo.getPosition());
        messagejo.put("remark", (Object)"\u611f\u8c22\u60a8\u7684\u652f\u6301");
        for (String key : messagejo.keySet()) {
            String value = messagejo.getString(key);
            if (StringUtils.isBlank((CharSequence)value)) {
                value = " ";
            }
            messagejo.put(key, (Object)value);
        }
        logger.info("tempate message :" + messagejo.toString());
        String openId = wxVip.getWxOpenId();
        String templateType = "ORDER_PAYMENT";
        MsgWxLogPO wechatMessageLogPO = new MsgWxLogPO();
        wechatMessageLogPO.set_id(wechatMessageLogId);
        wechatMessageLogPO.setWxPublicId(wxVip.getWxPublicId());
        wechatMessageLogPO.setOpenId(openId);
        wechatMessageLogPO.setMemberName(wxVip.getName());
        wechatMessageLogPO.setMemberPhone(wxVip.getPhone());
        if (channelVal != null) {
            wechatMessageLogPO.setWxNick(channelVal.getWxNick());
        }
        wechatMessageLogPO.setMessageBody(messagejo.toString());
        this.wechatMessageLogService.update(wechatMessageLogPO);
        WxPublicPO wxPublicPO = new WxPublicPO();
        wxPublicPO.setWxPublicId(wxVip.getWxPublicId());
        return UseTemplate.sendMessage((WxPublicPO)wxPublicPO, (String)"ORDER_PAYMENT", (String)openId, (JSONObject)messagejo);
    }
}

