/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.service.impl.wxtemplatemessage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.WxChannelInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.service.api.WxChannelInfoApiService;
import com.bizvane.members.facade.vo.WxChannelInfoVo;
import com.bizvane.members.facade.vo.WxChannelRelationVo;
import com.bizvane.message.common.utils.DictHelper;
import com.bizvane.message.service.WXTemplateMessageService;
import com.bizvane.message.service.WechatMessageLogService;
import com.bizvane.message.template.UseTemplateNew;
import com.bizvane.messagebase.common.constants.SysRespConstants;
import com.bizvane.messagebase.model.po.MsgWxLogPO;
import com.bizvane.messagefacade.models.vo.OrderMessageVO;
import com.bizvane.messagefacade.models.vo.Result;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatfacade.interfaces.WxPublicServiceFeign;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.SimpleDateFormat;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="wXTemplateMessageOrderOfflineConsumeServiceImpl")
public class WXTemplateMessageOrderOfflineConsumeServiceImpl
implements WXTemplateMessageService {
    private static final Logger logger = LoggerFactory.getLogger(WXTemplateMessageOrderOfflineConsumeServiceImpl.class);
    @Autowired
    private WechatMessageLogService wechatMessageLogService;
    @Autowired
    private WxChannelInfoApiService wxChannelInfoApiService;
    @Autowired
    private WxPublicServiceFeign wxPublicServiceFeign;
    @Autowired
    private MemberInfoApiService memberInfoApiService;

    public Result<String> sendMessage(String rocketMsgId, String messageBody) {
        logger.info(this.getClass().getName() + ".sendMessage\u5165\u53c2\uff1a" + messageBody);
        Result result = new Result();
        if (StringUtils.isBlank((CharSequence)messageBody)) {
            logger.error(this.getClass().getName() + ".sendMessage\u5165\u53c2\u4e3a\u7a7a");
            return result;
        }
        JSONObject jsonObject = JSON.parseObject((String)messageBody);
        String bussinessId = jsonObject.getString("rocketMQBussinessId");
        MsgWxLogPO insertPO = new MsgWxLogPO();
        insertPO.setTemplateType(jsonObject.getString("bussinessModuleCode"));
        insertPO.setTemplateTypeName(DictHelper.getDict((String)"template_type_wechat", (String)jsonObject.getString("bussinessModuleCode")).getItemCodeName());
        insertPO.setRocketMsgId(rocketMsgId);
        insertPO.setResultInfo("\u53d1\u9001\u4e2d");
        if (!StringUtils.isBlank((CharSequence)jsonObject.getString("sysBrandId"))) {
            insertPO.setSysBrandId(jsonObject.getLong("sysBrandId"));
        }
        if (!StringUtils.isBlank((CharSequence)jsonObject.getString("memberPhone"))) {
            insertPO.setMemberPhone(jsonObject.getString("memberPhone"));
        }
        insertPO.setBussinessId(bussinessId);
        insertPO.setDataBody(messageBody);
        Result insertResult = this.wechatMessageLogService.insert(insertPO);
        String wechatMessageLogId = (String)insertResult.getData();
        Result sendResult = this.sendMessage(wechatMessageLogId, jsonObject);
        String messageId = null;
        String resultInfo = null;
        String sendState = "05";
        if ((long)SysRespConstants.SUCCESS.getStatus() == sendResult.getStatus()) {
            sendState = "10";
            resultInfo = (String)sendResult.getData();
            messageId = String.valueOf(JSON.parseObject((String)resultInfo).getLong("msgid"));
        } else {
            resultInfo = sendResult.getMsg();
        }
        MsgWxLogPO updatePO = new MsgWxLogPO();
        updatePO.set_id(wechatMessageLogId);
        updatePO.setMessageId(messageId);
        updatePO.setResultInfo(resultInfo);
        updatePO.setSendState(sendState);
        this.wechatMessageLogService.update(updatePO);
        return result;
    }

    public Result<String> sendMessage(String wechatMessageLogId, JSONObject jsonObject) {
        Result result = new Result();
        String memberCode = jsonObject.getString("memberCode");
        if (StringUtils.isBlank((CharSequence)memberCode)) {
            result.setStatus((long)SysRespConstants.WX_MESSAGETEMP_USER_INFO_NOT_EMPTY.getStatus());
            result.setMsg(SysRespConstants.WX_MESSAGETEMP_USER_INFO_NOT_EMPTY.getMsg());
            return result;
        }
        Long sysCompanyId = jsonObject.getLongValue("sysCompanyId");
        Long brandId = jsonObject.getLongValue("sysBrandId");
        WxChannelRelationVo wxChannelRelationVo = new WxChannelRelationVo();
        wxChannelRelationVo.setMemberCode(memberCode);
        wxChannelRelationVo.setSysCompanyId(sysCompanyId);
        wxChannelRelationVo.setBrandId(brandId);
        wxChannelRelationVo.setMiniProgram(Integer.valueOf(1));
        ResponseData memberResult = this.wxChannelInfoApiService.getWxChannelInfoRelation(wxChannelRelationVo);
        WxChannelInfoModel wxChannelInfoVip = (WxChannelInfoModel)memberResult.getData();
        if (null == wxChannelInfoVip) {
            result.setStatus((long)SysRespConstants.WX_VIP_NOT_FOCUS.getStatus());
            result.setMsg(SysRespConstants.WX_VIP_NOT_FOCUS.getMsg());
            return result;
        }
        ObjectMapper mapper = new ObjectMapper();
        WxChannelInfoVo wxChannelInfoModel = new WxChannelInfoVo();
        wxChannelInfoModel.setMemberCode(memberCode);
        ResponseData channelResult = this.wxChannelInfoApiService.getWxChannelInfo(wxChannelInfoModel);
        WxChannelInfoVo channelInfoModel = (WxChannelInfoVo)channelResult.getData();
        WxChannelInfoVo channelVal = null;
        if (null != channelInfoModel) {
            channelVal = (WxChannelInfoVo)mapper.convertValue((Object)channelInfoModel, WxChannelInfoVo.class);
        }
        JSONObject messagejo = new JSONObject();
        OrderMessageVO vo = (OrderMessageVO)jsonObject.toJavaObject(OrderMessageVO.class);
        messagejo.put("first", (Object)("\u5c0a\u656c\u7684\u4f1a\u5458\uff0c\u60a8\u521a\u521a\u5728" + vo.getBrandName() + "\u95e8\u5e97\u8fdb\u884c\u6d88\u8d39\u3002"));
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        messagejo.put("keyword1", (Object)vo.getMerchantsName());
        messagejo.put("keyword2", (Object)(vo.getMoney() + "\u5143"));
        messagejo.put("keyword3", (Object)(vo.getPayMoney() + "\u5143"));
        messagejo.put("keyword4", (Object)vo.getOrderNo());
        messagejo.put("keyword5", (Object)formatter.format(vo.getDate()));
        messagejo.put("remark", (Object)"\u611f\u8c22\u60a8\u7684\u652f\u6301");
        for (String key : messagejo.keySet()) {
            String value = messagejo.getString(key);
            if (StringUtils.isBlank((CharSequence)value)) {
                value = " ";
            }
            messagejo.put(key, (Object)value);
        }
        logger.info("tempate message :" + messagejo.toString());
        String openId = wxChannelInfoVip.getOpenId();
        MsgWxLogPO wechatMessageLogPO = new MsgWxLogPO();
        wechatMessageLogPO.set_id(wechatMessageLogId);
        wechatMessageLogPO.setWxPublicId(wxChannelInfoVip.getPublicId());
        wechatMessageLogPO.setOpenId(openId);
        wechatMessageLogPO.setMessageBody(messagejo.toString());
        wechatMessageLogPO.setMemberName(channelInfoModel.getName());
        if (channelVal != null) {
            wechatMessageLogPO.setWxNick(channelVal.getWxNick());
        }
        this.wechatMessageLogService.update(wechatMessageLogPO);
        WxPublicPO wxPublicPO = new WxPublicPO();
        wxPublicPO.setWxPublicId(wxChannelInfoVip.getPublicId());
        ResponseData Stringkey = this.wxPublicServiceFeign.getAccessTokenByPublicId(wxChannelInfoVip.getPublicId());
        wxPublicPO.setAppid((String)Stringkey.getData());
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setSysCompanyId(sysCompanyId);
        memberInfoModel.setBrandId(brandId);
        memberInfoModel.setMemberCode(memberCode);
        ResponseData memberModel = this.memberInfoApiService.getMemberModel(memberInfoModel);
        String cardNo = "";
        String phone = "";
        if (memberModel.getCode() == SysResponseEnum.SUCCESS.getCode() && memberModel.getData() != null) {
            cardNo = ((MemberInfoModel)memberModel.getData()).getCardNo();
            phone = ((MemberInfoModel)memberModel.getData()).getPhone();
        }
        messagejo.put("\u8ba2\u5355\u53f7", (Object)vo.getOrderNo());
        messagejo.put("\u6d88\u8d39\u95e8\u5e97", (Object)vo.getStoresName());
        messagejo.put("\u6d88\u8d39\u91d1\u989d", (Object)vo.getMoney());
        messagejo.put("\u6d88\u8d39\u65f6\u95f4", (Object)formatter.format(vo.getDate()));
        messagejo.put("\u4f1a\u5458\u5361\u53f7", (Object)cardNo);
        messagejo.put("\u4f1a\u5458\u624b\u673a\u53f7", (Object)phone);
        return UseTemplateNew.sendMessage((WxPublicPO)wxPublicPO, (String)"ORDER_OFFLINE_CONSUME", (String)openId, (JSONObject)messagejo);
    }
}

