/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.service.impl.wxtemplatemessage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.message.common.constants.SystemConstants;
import com.bizvane.message.common.utils.DictHelper;
import com.bizvane.message.mappers.MsgSmsTempPOMapper;
import com.bizvane.message.mappers.SysSmsConfigPOMapper;
import com.bizvane.message.service.SmsMessageLogService;
import com.bizvane.message.service.SmsTemplateMessageService;
import com.bizvane.message.service.impl.centerMsg.SendCommonMessageImpl;
import com.bizvane.messagebase.common.constants.SysRespConstants;
import com.bizvane.messagebase.model.po.MsgSmsLogPO;
import com.bizvane.messagebase.model.po.MsgSmsTempPO;
import com.bizvane.messagebase.model.po.MsgSmsTempPOExample;
import com.bizvane.messagebase.model.po.SysSmsConfigPOExample;
import com.bizvane.messagefacade.interfaces.SendBatchMessageFeign;
import com.bizvane.messagefacade.models.vo.Result;
import com.bizvane.messagefacade.models.vo.SysSmsConfigVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="smsGenYeTemplateMessageServiceImpl")
public class SmsGenYeTemplateMessageServiceImpl
implements SmsTemplateMessageService {
    private static final Logger logger = LoggerFactory.getLogger(SmsGenYeTemplateMessageServiceImpl.class);
    @Autowired
    private SmsMessageLogService smsMessageLogService;
    @Autowired
    private SendCommonMessageImpl SendCommonMessageImpl;
    @Autowired
    private SendBatchMessageFeign sendBatchMessage;
    @Autowired
    private SysSmsConfigPOMapper sysSmsConfigPOMapper;
    @Autowired
    private MsgSmsTempPOMapper msgSmsTempPOMapper;

    public Result<String> sendMessage(String rocketMsgId, String messageBody) {
        Result result = new Result();
        try {
            logger.info("SmsGenYeTemplateMessageServiceImpl sendMessage messagebody \uff1a" + messageBody);
            if (StringUtils.isBlank((CharSequence)messageBody)) {
                logger.error(this.getClass().getName() + ".sendMessage\u5165\u53c2\u4e3a\u7a7a");
                return result;
            }
            JSONObject jsonObject = JSON.parseObject((String)messageBody);
            String phoneStr = jsonObject.getString("phoneStr");
            String templateType = jsonObject.getString("templateType");
            Result sendResult = new Result();
            sendResult = templateType.equals("BATCH_TEMPLATE_MESSAGE_NOT_SMS_TEMP") ? this.sendMessageNotTem(jsonObject, phoneStr) : this.sendMessageDoing(jsonObject, phoneStr);
            String resultInfoDetail = null;
            String resultInfo = null;
            Integer sendState = SystemConstants.SMS_MESSAGE_LOG_SEND_STATE_FAIL;
            if ((long)SysRespConstants.SUCCESS.getStatus() == sendResult.getStatus()) {
                sendState = SystemConstants.SMS_MESSAGE_LOG_SEND_STATE_SUCCESS;
                resultInfo = "\u6210\u529f";
            } else {
                resultInfoDetail = sendResult.getMsg();
                resultInfo = "\u5931\u8d25";
            }
            ArrayList<MsgSmsLogPO> MsgSmsLogPOlist = new ArrayList<MsgSmsLogPO>();
            for (String memberPhone : phoneStr.split(",")) {
                MsgSmsLogPO insertPO = new MsgSmsLogPO();
                insertPO.setBussinessId(jsonObject.getString("rocketMQBussinessId"));
                insertPO.setTemplateType(jsonObject.getString("bussinessModuleCode"));
                if (StringUtils.isNotBlank((CharSequence)jsonObject.getString("templateType"))) {
                    insertPO.setTemplateType(jsonObject.getString("templateType"));
                    insertPO.setTemplateTypeName(DictHelper.getDict((String)"template_type_wechat", (String)jsonObject.getString("templateType")).getItemCodeName());
                }
                insertPO.setSysBrandId(jsonObject.getLong("sysBrandId"));
                insertPO.setMessageBody(messageBody);
                insertPO.setResultInfoDetail(resultInfoDetail);
                insertPO.setSendState(sendState);
                insertPO.setResultInfo(resultInfo);
                insertPO.setMemberName(jsonObject.getString("memberName"));
                insertPO.setCreateDate(new Date());
                insertPO.setMemberPhone(memberPhone);
                MsgSmsLogPOlist.add(insertPO);
            }
            Result result2 = this.smsMessageLogService.insertCreateDate(MsgSmsLogPOlist);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38=====" + e.getMessage().toString());
        }
        return result;
    }

    public Result<String> sendMessageDoing(JSONObject jsonObject, String memberPhone) {
        Result result = new Result();
        Long sysBrandId = jsonObject.getLong("sysBrandId");
        if (sysBrandId == null) {
            logger.error(this.getClass().getName() + ".sendMessage.sysBrandId:\u54c1\u724cid\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            result.setStatus((long)SysRespConstants.SYSBRANDID_MODEL_CODE_NOT_EMPTY.getStatus());
            result.setMsg(SysRespConstants.SYSBRANDID_MODEL_CODE_NOT_EMPTY.getMsg());
            return result;
        }
        MsgSmsTempPOExample msgSmsTempPOExample = new MsgSmsTempPOExample();
        msgSmsTempPOExample.createCriteria().andSysBrandIdEqualTo(sysBrandId).andTemplateTypeEqualTo(jsonObject.getString("templateType")).andValidEqualTo(Boolean.TRUE);
        List smsTempPOList = this.msgSmsTempPOMapper.selectByExample(msgSmsTempPOExample);
        if (null == smsTempPOList || smsTempPOList.size() == 0) {
            result.setStatus((long)SysRespConstants.SMS_MESSAGETEMP_NOT_EXISTS.getStatus());
            result.setMsg(SysRespConstants.SMS_MESSAGETEMP_NOT_EXISTS.getMsg());
            return result;
        }
        if (!((MsgSmsTempPO)smsTempPOList.get(0)).getStatus().booleanValue() && "CHU_ZHI_GEN_WXTEMPLATE_MESSAGE".equals(jsonObject.getString("templateType"))) {
            result.setStatus((long)SysRespConstants.SMS_MESSAGETEMP_OFF.getStatus());
            result.setMsg(SysRespConstants.SMS_MESSAGETEMP_OFF.getMsg());
            return result;
        }
        SysSmsConfigPOExample sysSmsConfigPOExample = new SysSmsConfigPOExample();
        sysSmsConfigPOExample.createCriteria().andSysBrandIdEqualTo(sysBrandId).andChannelTypeEqualTo(Integer.valueOf(10)).andValidEqualTo(Boolean.TRUE);
        List sysSmsConfigList = this.sysSmsConfigPOMapper.selectByExample(sysSmsConfigPOExample);
        ResponseData sendResults = new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage(), null);
        if (CollectionUtils.isNotEmpty((Collection)sysSmsConfigList)) {
            ObjectMapper mapper = new ObjectMapper();
            SysSmsConfigVO syssmsconfigvo = (SysSmsConfigVO)mapper.convertValue(sysSmsConfigList.get(0), SysSmsConfigVO.class);
            syssmsconfigvo.setMsgContent(this.getMsgContent(((MsgSmsTempPO)smsTempPOList.get(0)).getContent(), jsonObject) + " \u9000\u8ba2\u56de\u590dTD");
            result.setData((Object)syssmsconfigvo.getMsgContent());
            String phoneStr = jsonObject.getString("phoneStr");
            syssmsconfigvo.setPhones(phoneStr);
            syssmsconfigvo.setMsgId(jsonObject.getString("rocketMQBussinessId"));
            sendResults = this.sendBatchMessage.sendSmgBatch(syssmsconfigvo);
            if (SysResponseEnum.SUCCESS.getCode() == sendResults.getCode()) {
                result.setStatus((long)SysRespConstants.SUCCESS.getStatus());
                result.setMsg(sendResults.getMessage());
            } else {
                result.setStatus((long)SysRespConstants.FAILED.getStatus());
                result.setMsg("\u53d1\u9001\u5f02\u5e38\uff1a" + sendResults.getMessage());
            }
        } else {
            result.setStatus((long)SysRespConstants.SMS_CONFIG_MESSAGETEMP_NOT_EXISTS.getStatus());
            result.setMsg(SysRespConstants.SMS_CONFIG_MESSAGETEMP_NOT_EXISTS.getMsg());
            return result;
        }
        return result;
    }

    public String getMsgContent(String msgContent, JSONObject json) {
        if (StringUtils.isEmpty((CharSequence)json.getString("messagejo"))) {
            return msgContent;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)json.getString("messagejo"));
        if ("CHU_ZHI_GEN_WXTEMPLATE_MESSAGE".equals(json.getString("templateType"))) {
            msgContent = StringUtils.isNotEmpty((CharSequence)jsonObject.getString("keyword8")) ? msgContent.replace("@[\u4f1a\u5458\u59d3\u540d]", jsonObject.getString("keyword8")) : msgContent.replace("@[\u4f1a\u5458\u59d3\u540d]", "");
            if (StringUtils.isNotEmpty((CharSequence)jsonObject.getString("keyword5"))) {
                msgContent = msgContent.replace("@[\u4f59\u989d\u53d8\u52a8\u65f6\u95f4]", jsonObject.getString("keyword5"));
            }
            if (StringUtils.isNotEmpty((CharSequence)jsonObject.getString("keyword1"))) {
                msgContent = msgContent.replace("@[\u4f59\u989d\u53d8\u52a8\u7c7b\u578b]", jsonObject.getString("keyword1"));
            }
            if (StringUtils.isNotEmpty((CharSequence)jsonObject.getString("keyword3"))) {
                msgContent = msgContent.replace("@[\u5f53\u524d\u4f59\u989d\u5143]", jsonObject.getString("keyword3") + "\u5143");
            }
            if (StringUtils.isNotEmpty((CharSequence)jsonObject.getString("keyword2"))) {
                msgContent = msgContent.replace("@[\u4f59\u989d\u53d8\u52a8\u989d\u5143]", jsonObject.getString("keyword2") + "\u5143");
            }
            if (StringUtils.isNotEmpty((CharSequence)jsonObject.getString("keyword6"))) {
                msgContent = msgContent.replace("@[\u4f1a\u5458\u5361\u53f7]", jsonObject.getString("keyword6"));
            }
            if (StringUtils.isNotEmpty((CharSequence)jsonObject.getString("keyword7"))) {
                msgContent = msgContent.replace("@[\u5173\u8054\u8ba2\u5355\u53f7]", jsonObject.getString("keyword7"));
            }
        }
        return msgContent;
    }

    public Result<String> sendMessageNotTem(JSONObject jsonObject, String memberPhone) {
        Result result = new Result();
        Long sysBrandId = jsonObject.getLong("sysBrandId");
        if (sysBrandId == null) {
            logger.error(this.getClass().getName() + ".sendMessage.sysBrandId:\u54c1\u724cid\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            result.setStatus((long)SysRespConstants.SYSBRANDID_MODEL_CODE_NOT_EMPTY.getStatus());
            result.setMsg(SysRespConstants.SYSBRANDID_MODEL_CODE_NOT_EMPTY.getMsg());
            return result;
        }
        SysSmsConfigPOExample sysSmsConfigPOExample = new SysSmsConfigPOExample();
        sysSmsConfigPOExample.createCriteria().andSysBrandIdEqualTo(sysBrandId).andChannelTypeEqualTo(Integer.valueOf(10)).andValidEqualTo(Boolean.TRUE);
        List sysSmsConfigList = this.sysSmsConfigPOMapper.selectByExample(sysSmsConfigPOExample);
        ResponseData sendResults = new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage(), null);
        if (CollectionUtils.isNotEmpty((Collection)sysSmsConfigList)) {
            ObjectMapper mapper = new ObjectMapper();
            SysSmsConfigVO syssmsconfigvo = (SysSmsConfigVO)mapper.convertValue(sysSmsConfigList.get(0), SysSmsConfigVO.class);
            String messageBody = jsonObject.getString("messageBody");
            syssmsconfigvo.setMsgContent(messageBody + " \u9000\u8ba2\u56de\u590dTD");
            result.setData((Object)syssmsconfigvo.getMsgContent());
            String phoneStr = jsonObject.getString("phoneStr");
            syssmsconfigvo.setPhones(phoneStr);
            syssmsconfigvo.setMsgId(jsonObject.getString("rocketMQBussinessId"));
            sendResults = this.sendBatchMessage.sendSmgBatch(syssmsconfigvo);
            if (SysResponseEnum.SUCCESS.getCode() == sendResults.getCode()) {
                result.setStatus((long)SysRespConstants.SUCCESS.getStatus());
                result.setMsg(sendResults.getMessage());
            } else {
                result.setStatus((long)SysRespConstants.FAILED.getStatus());
                result.setMsg("\u53d1\u9001\u5f02\u5e38\uff1a" + sendResults.getMessage());
            }
        } else {
            result.setStatus((long)SysRespConstants.SMS_CONFIG_MESSAGETEMP_NOT_EXISTS.getStatus());
            result.setMsg(SysRespConstants.SMS_CONFIG_MESSAGETEMP_NOT_EXISTS.getMsg());
            return result;
        }
        return result;
    }
}

