/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.service.impl.messagelisterner;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import com.bizvane.message.common.utils.SpringContextUtil;
import com.bizvane.message.mappers.RocketConfigPOMapper;
import com.bizvane.messagebase.model.po.RocketConfigPO;
import com.bizvane.messagebase.model.po.RocketConfigPOExample;
import com.bizvane.trace.service.ProvisionalTraceService;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AllMessageListener
implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(AllMessageListener.class);
    @Autowired
    private RocketConfigPOMapper rocketConfigPOMapper;
    @Autowired
    private ProvisionalTraceService provisionalTraceService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Action consume(Message message, ConsumeContext consumeContext) {
        this.provisionalTraceService.start();
        logger.info("AllMessageListener\u6d88\u8d39\u6d88\u606f Tag:" + message.getTag() + " messageId:" + message.getMsgID());
        try {
            JSONObject jsonObject = JSON.parseObject((String)new String(message.getBody(), "UTF-8"));
            String beanName = jsonObject.getString("bussinessType");
            RocketConfigPOExample example = new RocketConfigPOExample();
            example.createCriteria().andBusinessTypeEqualTo(beanName).andModelNameEqualTo("message").andValidEqualTo(Boolean.TRUE);
            List rocketConfigPOList = this.rocketConfigPOMapper.selectByExample(example);
            if (CollectionUtils.isEmpty((Collection)rocketConfigPOList)) {
                logger.info("AllMessageListenerbeanName\u6d88\u8d39\u6d88\u606f,\u6ca1\u6709\u914d\u7f6e\u8be5tag :" + beanName + " messageId:" + message.getMsgID());
                Action action = Action.CommitMessage;
                return action;
            }
            Object messageListener = SpringContextUtil.getBean((String)((RocketConfigPO)rocketConfigPOList.get(0)).getMessageListenerBean());
            Action action = ((MessageListener)messageListener).consume(message, consumeContext);
            return action;
        }
        catch (Exception e) {
            logger.info("AllMessageListener\u6d88\u8d39\u6709\u8bef\u6709\u8bef\u6709\u8bef\u6709\u8bef\u6d88\u606f Tag:" + message.getTag() + " messageId:" + message.getMsgID() + " \u9519\u8bef\u4fe1\u606f:" + e);
            e.printStackTrace();
        }
        finally {
            this.provisionalTraceService.finish();
            return Action.CommitMessage;
        }
    }
}

