/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.service.impl;

import com.bizvane.message.mongo.WechatLogPOMongoDao;
import com.bizvane.message.service.WechatMessageLogService;
import com.bizvane.messagebase.common.constants.SysResponseEnum;
import com.bizvane.messagebase.model.po.MsgWxLogPO;
import com.bizvane.messagefacade.models.vo.PageForm;
import com.bizvane.messagefacade.models.vo.Result;
import com.bizvane.messagefacade.models.vo.SmsStatisticsVO;
import com.bizvane.messagefacade.models.vo.WechatMessageLogVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.math.BigDecimal;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WechatMessageLogServiceImpl
implements WechatMessageLogService {
    @Autowired
    private WechatLogPOMongoDao wechatLogPOMongoDao;

    public Result<String> insert(MsgWxLogPO po) {
        po.setSendState("00");
        po.setCreateDate(new Date());
        String logid = this.wechatLogPOMongoDao.saveRocketLogPO(po);
        Result result = new Result();
        result.setData((Object)logid);
        return result;
    }

    public Result<Object> update(MsgWxLogPO po) {
        po.setUpdateDate(new Date());
        if ("10".equals(po.getSendState())) {
            po.setResultInfo("\u6210\u529f");
            po.setResultInfoDetail("");
        } else {
            po.setResultInfoDetail(po.getResultInfo());
            po.setResultInfo("\u5931\u8d25");
        }
        po.setUpdateDate(new Date());
        this.wechatLogPOMongoDao.updateRocketLogPO(po);
        return new Result();
    }

    public ResponseData<Object> findPage(WechatMessageLogVO vo) {
        ResponseData responseData = new ResponseData();
        PageInfo pageInfo = this.wechatLogPOMongoDao.getRocketLogPOList(vo);
        responseData.setData((Object)pageInfo);
        return responseData;
    }

    public ResponseData getStatistics(WechatMessageLogVO smsMessageLogVo) {
        ResponseData responseData = new ResponseData();
        PageForm pageForm = new PageForm();
        pageForm.setPageNum(smsMessageLogVo.getPageNumber());
        pageForm.setPageSize(smsMessageLogVo.getPageSize());
        PageInfo pageInfolist = this.wechatLogPOMongoDao.getRocketLogPOList(smsMessageLogVo);
        Long allCountSms = pageInfolist.getTotal();
        smsMessageLogVo.setSendState("10");
        PageInfo pageInfosuccessSmslist = this.wechatLogPOMongoDao.getRocketLogPOList(smsMessageLogVo);
        Long successSms = pageInfosuccessSmslist.getTotal();
        Long failedSms = allCountSms - successSms;
        SmsStatisticsVO smsStatisticsVO = new SmsStatisticsVO();
        if (allCountSms != 0L) {
            BigDecimal b = new BigDecimal(successSms);
            b = b.divide(new BigDecimal(allCountSms), 4, 4).multiply(new BigDecimal(100));
            String endPercent = b.setScale(2, 4).toString();
            if (successSms == 0L) {
                endPercent = "0.00";
            }
            smsStatisticsVO.setAllCountSms(allCountSms);
            smsStatisticsVO.setFailedSms(failedSms);
            smsStatisticsVO.setSuccessSms(successSms);
            smsStatisticsVO.setSuccessPercent(endPercent);
        } else {
            smsStatisticsVO.setAllCountSms(Long.valueOf(0L));
            smsStatisticsVO.setFailedSms(Long.valueOf(0L));
            smsStatisticsVO.setSuccessSms(Long.valueOf(0L));
            smsStatisticsVO.setSuccessPercent("0.00");
        }
        responseData.setData((Object)smsStatisticsVO);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }
}

