/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.service.impl;

import com.bizvane.message.common.constants.SystemConstants;
import com.bizvane.message.common.utils.PageForm;
import com.bizvane.message.mongo.MsgSmsLogPOMongoDao;
import com.bizvane.message.service.SmsMessageLogService;
import com.bizvane.messagebase.common.constants.SysResponseEnum;
import com.bizvane.messagebase.model.po.MsgSmsLogPO;
import com.bizvane.messagefacade.models.vo.GenrealGetMessageVO;
import com.bizvane.messagefacade.models.vo.Result;
import com.bizvane.messagefacade.models.vo.SmsMessageLogVo;
import com.bizvane.messagefacade.models.vo.SmsStatisticsVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmsMessageLogServiceImpl
implements SmsMessageLogService {
    private static final Logger log = LoggerFactory.getLogger(SmsMessageLogServiceImpl.class);
    @Autowired
    private MsgSmsLogPOMongoDao msgSmsLogPOMongoDao;

    public Result<String> insert(MsgSmsLogPO po) {
        po.setSendState(SystemConstants.SMS_MESSAGE_LOG_SEND_STATE_CREATE);
        po.setCreateDate(new Date());
        this.msgSmsLogPOMongoDao.saveRocketLogPO(po);
        Result result = new Result();
        result.setData((Object)po.get_id());
        return result;
    }

    public Result<String> insertCreateDate(List<MsgSmsLogPO> po) {
        this.msgSmsLogPOMongoDao.saveMsgSmsLogPOList(po);
        Result result = new Result();
        result.setData((Object)"1");
        return result;
    }

    public Result<Object> update(MsgSmsLogPO po) {
        po.setUpdateDate(new Date());
        if (po.getSendState() == 1) {
            po.setResultInfo("\u6210\u529f");
            po.setResultInfoDetail("");
        } else {
            po.setResultInfo("\u5931\u8d25");
        }
        po.setUpdateDate(new Date());
        this.msgSmsLogPOMongoDao.updateRocketLogPO(po);
        return new Result();
    }

    public PageInfo<MsgSmsLogPO> rocketLogPOList(SmsMessageLogVo msgSmsLogPO, PageForm pageForm) {
        return this.msgSmsLogPOMongoDao.getRocketLogPOList(msgSmsLogPO, pageForm);
    }

    public ResponseData<Object> getMsgLogPage(SmsMessageLogVo smsMessageLogVo, PageForm pageForm) {
        ResponseData responseData = new ResponseData();
        try {
            PageInfo pageInfo = this.msgSmsLogPOMongoDao.getRocketLogPOList(smsMessageLogVo, pageForm);
            responseData.setData((Object)pageInfo);
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        return responseData;
    }

    public ResponseData getStatistics(SmsMessageLogVo smsMessageLogVo) {
        ResponseData responseData = new ResponseData();
        PageForm pageForm = new PageForm();
        pageForm.setPageNum(smsMessageLogVo.getPageNumber());
        pageForm.setPageSize(smsMessageLogVo.getPageSize());
        PageInfo pageInfolist = this.msgSmsLogPOMongoDao.getRocketLogPOList(smsMessageLogVo, pageForm);
        Long allCountSms = pageInfolist.getTotal();
        smsMessageLogVo.setSendState(Integer.valueOf(1));
        PageInfo pageInfosuccessSmslist = this.msgSmsLogPOMongoDao.getRocketLogPOList(smsMessageLogVo, pageForm);
        Long successSms = pageInfosuccessSmslist.getTotal();
        Long failedSms = allCountSms - successSms;
        SmsStatisticsVO smsStatisticsVO = new SmsStatisticsVO();
        if (allCountSms != 0L) {
            BigDecimal b = new BigDecimal(successSms);
            b = b.divide(new BigDecimal(allCountSms), 4, 4).multiply(new BigDecimal(100));
            String endPercent = b.setScale(2, 4).toString();
            if (successSms == 0L) {
                endPercent = "0.00";
            }
            smsStatisticsVO.setAllCountSms(allCountSms);
            smsStatisticsVO.setFailedSms(failedSms);
            smsStatisticsVO.setSuccessSms(successSms);
            smsStatisticsVO.setSuccessPercent(endPercent);
        } else {
            smsStatisticsVO.setAllCountSms(Long.valueOf(0L));
            smsStatisticsVO.setFailedSms(Long.valueOf(0L));
            smsStatisticsVO.setSuccessSms(Long.valueOf(0L));
            smsStatisticsVO.setSuccessPercent("0.00");
        }
        responseData.setData((Object)smsStatisticsVO);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public ResponseData<Object> getReturnMessage(GenrealGetMessageVO genrealGetMessageVO) {
        ResponseData responseData = new ResponseData();
        PageForm pageForm = new PageForm();
        pageForm.setPageNum(Integer.valueOf(1));
        pageForm.setPageSize(Integer.valueOf(10));
        PageInfo pageInfolist = this.msgSmsLogPOMongoDao.getReturnMessage(genrealGetMessageVO, null, pageForm);
        Long allCountSms = pageInfolist.getTotal();
        PageInfo pageInfosuccessSmslist = this.msgSmsLogPOMongoDao.getReturnMessage(genrealGetMessageVO, Integer.valueOf(1), pageForm);
        Long successSms = pageInfosuccessSmslist.getTotal();
        Long failedSms = allCountSms - successSms;
        SmsStatisticsVO smsStatisticsVO = new SmsStatisticsVO();
        if (allCountSms != 0L) {
            BigDecimal b = new BigDecimal(successSms);
            b = b.divide(new BigDecimal(allCountSms), 4, 4).multiply(new BigDecimal(100));
            String endPercent = b.setScale(2, 4).toString();
            if (successSms == 0L) {
                endPercent = "0.00";
            }
            smsStatisticsVO.setAllCountSms(allCountSms);
            smsStatisticsVO.setFailedSms(failedSms);
            smsStatisticsVO.setSuccessSms(successSms);
            smsStatisticsVO.setSuccessPercent(endPercent);
        } else {
            smsStatisticsVO.setAllCountSms(Long.valueOf(0L));
            smsStatisticsVO.setFailedSms(Long.valueOf(0L));
            smsStatisticsVO.setSuccessSms(Long.valueOf(0L));
            smsStatisticsVO.setSuccessPercent("0.00");
        }
        responseData.setData((Object)smsStatisticsVO);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }
}

