/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.bizvane.message.common.utils.DateUtil;
import com.bizvane.message.mappers.MsgSendTimePOMapper;
import com.bizvane.message.service.RocketMQProducerService;
import com.bizvane.message.service.impl.RocketMQManager;
import com.bizvane.messagebase.model.po.MsgSendTimePO;
import com.bizvane.messagebase.model.po.MsgSendTimePOExample;
import com.bizvane.messagefacade.models.vo.Result;
import com.bizvane.utils.redisutils.RedisClient;
import com.bizvane.utils.responseinfo.ResponseData;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class RocketMQProducerServiceImpl
implements RocketMQProducerService {
    private static final Logger log = LoggerFactory.getLogger(RocketMQProducerServiceImpl.class);
    @Value(value="${rocketmq.topic}")
    private String rocketmqTopic;
    @Value(value="${rocketmq.producerId}")
    private String rocketmqProducerId;
    @Value(value="${rocketmq.consumerId}")
    private String rocketmqConsumerId;
    @Autowired
    private MsgSendTimePOMapper msgSendTimePOMapper;
    @Autowired
    private RedisClient redisClient;

    public ResponseData<String> sendMessage(String topic, String tag, String rocketmqKey, byte[] messageBody) {
        log.info("RocketMQProducerServiceImpl.sendMessage:topic:{},tag:{}", (Object)this.rocketmqTopic, (Object)tag);
        if (StringUtils.isBlank((CharSequence)topic) || StringUtils.isBlank((CharSequence)tag)) {
            log.error("RocketMQProducerServiceImpl.sendMessage:topic\u3001tag\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ResponseData result = new ResponseData();
        Producer producer = RocketMQManager.getProducer((String)this.rocketmqTopic);
        Message message = new Message(this.rocketmqTopic, tag, messageBody);
        try {
            message.setKey(rocketmqKey);
            Result sendcheck = this.checkID(new String(messageBody));
            if (sendcheck.getStatus() == 0L) {
                this.setDeliveryTime(sendcheck, message);
            } else if (sendcheck.getStatus() == 12121L) {
                String dfd = ((JSONObject)sendcheck.getData()).getString("sendtime");
                message.setStartDeliverTime(Long.parseLong(dfd));
            }
            SendResult sendResult = producer.send(message);
            String messageId = sendResult.getMessageId();
            result.setData((Object)messageId);
            log.info("RocketMQProducerServiceImpl.sendMessage\u6d88\u606f\u53d1\u9001\u5b8c\u6210\uff0cmsgId\uff1a" + messageId + "   \u6d88\u606f\u7684MessageKey:" + rocketmqKey);
        }
        catch (ONSClientException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public Result<JSONObject> checkID(String messageBody) {
        log.info("RocketMQProducerServiceImpl checkID \uff1a{}", (Object)messageBody);
        Result result = new Result();
        result.setStatus(1L);
        JSONObject jsonObject = JSON.parseObject((String)messageBody);
        if (!StringUtils.isBlank((CharSequence)jsonObject.getString("sendtype")) && jsonObject.getString("sendtype").equals("0")) {
            JSONObject sendtype = new JSONObject();
            sendtype.put("sendtime", (Object)jsonObject.getString("sendtime"));
            result.setStatus(12121L);
            result.setData((Object)sendtype);
            return result;
        }
        Long sysBrandId = jsonObject.getLong("sysBrandId");
        String bussinessModuleCode = jsonObject.getString("bussinessModuleCode");
        if (null != sysBrandId && (bussinessModuleCode.equals("ACTIVITY_TEMPLATE_MESSAGE") || bussinessModuleCode.equals("SMS_COUPON_RECEIVE") || bussinessModuleCode.equals("SMS_COUPON_EXPIRE") || bussinessModuleCode.equals("SMS_INTEGRAL_ADD"))) {
            Object sysBrandIdVal = this.redisClient.get("send_message_sysBrandId:" + sysBrandId);
            if (sysBrandIdVal == null) {
                MsgSendTimePOExample msgSendTimePOExample = new MsgSendTimePOExample();
                msgSendTimePOExample.createCriteria().andSysBrandIdEqualTo(sysBrandId).andValidEqualTo(Boolean.valueOf(true));
                List msgSendTimePOS = this.msgSendTimePOMapper.selectByExample(msgSendTimePOExample);
                if (null != msgSendTimePOS && msgSendTimePOS.size() > 0) {
                    MsgSendTimePO msgSendTimePO = (MsgSendTimePO)msgSendTimePOS.get(0);
                    result.setStatus(0L);
                    JSONObject jsonObjectSms = JSONObject.parseObject((String)JSONObject.toJSONString((Object)msgSendTimePO));
                    result.setData((Object)jsonObjectSms);
                    this.redisClient.set("send_message_sysBrandId:" + sysBrandId, (Object)jsonObjectSms);
                }
            } else {
                JSONObject sysBrandIdVal0 = (JSONObject)sysBrandIdVal;
                result.setStatus(0L);
                result.setData((Object)sysBrandIdVal0);
            }
        }
        return result;
    }

    private void setDeliveryTime(Result<JSONObject> result, Message message) {
        Date toDay = new Date();
        String nowHMS = DateUtil.format((Date)toDay, (String)"HH:mm:ss");
        String startHMS = ((JSONObject)result.getData()).getString("sendTimeStart");
        String endHMS = ((JSONObject)result.getData()).getString("sendTimeEnd");
        try {
            Date nowTime = DateUtil.getDate((String)nowHMS);
            Date startTime = DateUtil.getDate((String)startHMS);
            Date endTime = DateUtil.getDate((String)endHMS);
            boolean effectiveDate = DateUtil.isEffectiveDate((Date)nowTime, (Date)startTime, (Date)endTime);
            String minTime = DateUtil.format((Date)DateUtil.getMinTime((Date)startTime, (Date)endTime), (String)"HH:mm:ss");
            if (!effectiveDate) {
                if (DateUtil.isBefore((Date)nowTime, (Date)startTime)) {
                    message.setStartDeliverTime(DateUtil.getYmdJoinHms((Date)toDay, (String)minTime).getTime());
                } else {
                    Date nextDay = DateUtil.addDay((Date)toDay, (int)1);
                    message.setStartDeliverTime(DateUtil.getYmdJoinHms((Date)nextDay, (String)minTime).getTime());
                }
            }
        }
        catch (ParseException e) {
            log.info("\u65e5\u671f\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38" + e);
        }
    }
}

