/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.message.mappers.MsgSendTimePOMapper;
import com.bizvane.message.service.MsgSendTimeService;
import com.bizvane.messagebase.common.constants.SysResponseEnum;
import com.bizvane.messagebase.model.po.MsgSendTimePO;
import com.bizvane.messagebase.model.po.MsgSendTimePOExample;
import com.bizvane.messagefacade.models.vo.SendTimeVo;
import com.bizvane.utils.redisutils.RedisClient;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MsgSendTimeServiceImpl
implements MsgSendTimeService {
    @Autowired
    private MsgSendTimePOMapper msgSendTimePOMapper;
    @Autowired
    private RedisClient redisClient;

    @Transactional
    public ResponseData saveSendTime(Date sendTimeStart, Date sendTimeEnd, SysAccountPO stageUser) {
        ResponseData responseData = new ResponseData();
        if (sendTimeStart == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u8bf7\u8f93\u5165\u77ed\u4fe1\u53d1\u9001\u5f00\u59cb\u65f6\u95f4");
            return responseData;
        }
        if (sendTimeEnd == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u8bf7\u8f93\u5165\u77ed\u4fe1\u53d1\u9001\u7ed3\u675f\u65f6\u95f4");
            return responseData;
        }
        if (sendTimeEnd.before(sendTimeStart)) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u7ed3\u675f\u53d1\u9001\u65f6\u95f4\u4e0d\u53ef\u65e9\u4e8e\u5f00\u59cb\u53d1\u9001\u65f6\u95f4");
            return responseData;
        }
        MsgSendTimePOExample msgSendTimePOExample = new MsgSendTimePOExample();
        msgSendTimePOExample.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andSysBrandIdEqualTo(stageUser.getBrandId());
        MsgSendTimePO record = new MsgSendTimePO();
        record.setModifiedDate(new Date());
        record.setModifiedUserId(stageUser.getSysAccountId());
        record.setCreateUserName(stageUser.getModifiedUserName());
        record.setValid(Boolean.valueOf(false));
        this.msgSendTimePOMapper.updateByExampleSelective(record, msgSendTimePOExample);
        MsgSendTimePO msgSendTimePO = new MsgSendTimePO();
        msgSendTimePO.setSendTimeStart(sendTimeStart);
        msgSendTimePO.setSendTimeEnd(sendTimeEnd);
        msgSendTimePO.setCreateDate(new Date());
        msgSendTimePO.setCreateUserId(stageUser.getSysAccountId());
        msgSendTimePO.setCreateUserName(stageUser.getCreateUserName());
        msgSendTimePO.setSysBrandId(stageUser.getBrandId());
        msgSendTimePO.setValid(Boolean.valueOf(true));
        this.msgSendTimePOMapper.insert(msgSendTimePO);
        this.redisClient.set("send_message_sysBrandId:" + stageUser.getBrandId(), (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)msgSendTimePO)));
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    @Transactional
    public ResponseData getSendTime(Long sysBrandId) {
        ResponseData responseData = new ResponseData();
        if (sysBrandId == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u8bf7\u8f93\u5165\u54c1\u724cid");
            return responseData;
        }
        MsgSendTimePOExample msgSendTimePOExample = new MsgSendTimePOExample();
        msgSendTimePOExample.createCriteria().andSysBrandIdEqualTo(sysBrandId).andValidEqualTo(Boolean.valueOf(true));
        List msgSendTimePOS = this.msgSendTimePOMapper.selectByExample(msgSendTimePOExample);
        MsgSendTimePO msgSendTimePO = null;
        if (msgSendTimePOS != null & msgSendTimePOS.size() > 0) {
            msgSendTimePO = (MsgSendTimePO)msgSendTimePOS.get(0);
        }
        responseData.setData(msgSendTimePO);
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    public ResponseData initSendTime(SendTimeVo vo) {
        ResponseData responseData = new ResponseData();
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        MsgSendTimePO msgSendTimePO = new MsgSendTimePO();
        try {
            msgSendTimePO.setSendTimeStart(sdf.parse("09:00:00"));
            msgSendTimePO.setSendTimeEnd(sdf.parse("22:00:00"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        msgSendTimePO.setCreateDate(new Date());
        msgSendTimePO.setCreateUserId(vo.getCreateUserId());
        msgSendTimePO.setCreateUserName(vo.getCreateUserName());
        msgSendTimePO.setSysBrandId(vo.getSysBrandId());
        msgSendTimePO.setValid(Boolean.valueOf(true));
        this.msgSendTimePOMapper.insert(msgSendTimePO);
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }
}

