/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.service.impl;

import com.bizvane.message.common.utils.DictHelper;
import com.bizvane.message.mappers.SysCodeValuePOMapper;
import com.bizvane.message.service.DictService;
import com.bizvane.messagebase.model.po.SysCodeValuePO;
import com.bizvane.messagebase.model.po.SysCodeValuePOExample;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DictServiceImpl
implements DictService {
    private static final Logger logger = LoggerFactory.getLogger(DictServiceImpl.class);
    @Autowired
    private SysCodeValuePOMapper sysCodeValuePOMapper;

    public List<SysCodeValuePO> getDicts(String dictType) {
        return DictHelper.getDicts((String)dictType);
    }

    public Map<String, SysCodeValuePO> getDictMap(String dictType) {
        return DictHelper.getDictMap((String)dictType);
    }

    public void init() {
        SysCodeValuePOExample sysCodeValueExample = new SysCodeValuePOExample();
        List list = this.sysCodeValuePOMapper.selectByExample(sysCodeValueExample);
        DictHelper.getDictMap().clear();
        for (SysCodeValuePO dict : list) {
            this.initData(dict);
        }
    }

    protected void initData(SysCodeValuePO dict) {
        List list = (List)DictHelper.getDictMap().get(dict.getCodeType());
        if (list == null || list.isEmpty()) {
            ArrayList<SysCodeValuePO> dicts = new ArrayList<SysCodeValuePO>();
            dicts.add(dict);
            DictHelper.getDictMap().put(dict.getCodeType(), dicts);
        } else {
            ((List)DictHelper.getDictMap().get(dict.getCodeType())).add(dict);
        }
    }

    public void reload() {
        logger.info("======================================reload dict data start================================");
        this.init();
        logger.info("======================================reload dict data end================================");
    }

    public SysCodeValuePO getSysCodeValue(String dictType, String itemCode) {
        List sysCodeValues = DictHelper.getDicts((String)dictType);
        for (SysCodeValuePO sysCodeValue : sysCodeValues) {
            String item = sysCodeValue.getItemCode();
            if (!item.contains(itemCode)) continue;
            return sysCodeValue;
        }
        return null;
    }
}

