/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.controller;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.message.service.RocketMQSendOrderSmsService;
import com.bizvane.message.service.RocketMQWechatService;
import com.bizvane.messagefacade.models.vo.OrderMessageVO;
import com.bizvane.messagefacade.models.vo.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/wechatOrder"})
public class WechatOrderController {
    @Autowired
    private RocketMQWechatService rocketMQWechatService;
    @Autowired
    private RocketMQSendOrderSmsService rocketMQSendOrderSmsService;

    @PostMapping(value={"/orderOfflineConsume"})
    public Result<String> orderOfflineConsume(@RequestBody(required=false) OrderMessageVO vo) {
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)vo));
        jsonObject.put("rocketMQTopic", (Object)"public_bizvane_message");
        jsonObject.put("rocketMQTag", (Object)"ORDER_OFFLINE_CONSUME");
        jsonObject.put("bussinessModuleCode", (Object)"ORDER_OFFLINE_CONSUME");
        jsonObject.put("bussinessType", (Object)"wechatOrderOfflineMessage");
        jsonObject.put("rocketMQBussinessId", (Object)vo.getOrderNo());
        return this.rocketMQWechatService.sendMessage(jsonObject.toJSONString());
    }

    @PostMapping(value={"/orderPayment"})
    public Result<String> orderPayment(@RequestBody(required=false) OrderMessageVO vo) {
        if (null == vo) {
            vo = new OrderMessageVO();
        }
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)vo));
        jsonObject.put("rocketMQTopic", (Object)"public_bizvane_message");
        jsonObject.put("rocketMQTag", (Object)"ORDER_PAYMENT");
        jsonObject.put("bussinessModuleCode", (Object)"ORDER_PAYMENT");
        jsonObject.put("bussinessType", (Object)"wechatOrderPaymentMessage");
        jsonObject.put("rocketMQBussinessId", (Object)vo.getOrderNo());
        return this.rocketMQWechatService.sendMessage(jsonObject.toJSONString());
    }

    @PostMapping(value={"/orderShip"})
    public Result<String> orderShip(@RequestBody OrderMessageVO vo) {
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)vo));
        jsonObject.put("rocketMQTopic", (Object)"public_bizvane_message");
        jsonObject.put("rocketMQTag", (Object)"ORDER_SHIP");
        jsonObject.put("bussinessModuleCode", (Object)"ORDER_SHIP");
        jsonObject.put("bussinessType", (Object)"wechatOrderShipMessage");
        jsonObject.put("rocketMQBussinessId", (Object)vo.getOrderNo());
        this.rocketMQWechatService.sendMessage(jsonObject.toJSONString());
        JSONObject jsonObjectsms = JSONObject.parseObject((String)JSONObject.toJSONString((Object)vo));
        jsonObjectsms.put("rocketMQTopic", (Object)"public_bizvane_message");
        jsonObjectsms.put("rocketMQTag", (Object)"ORDER_SMS_SHIP");
        jsonObjectsms.put("bussinessModuleCode", (Object)"ORDER_SMS_SHIP");
        jsonObjectsms.put("bussinessType", (Object)"smsOrderShipMessage");
        jsonObjectsms.put("rocketMQBussinessId", (Object)vo.getOrderNo());
        return this.rocketMQSendOrderSmsService.sendMessage(jsonObjectsms.toJSONString());
    }

    @PostMapping(value={"/orderCancel"})
    public Result<String> orderCancel(@RequestBody(required=false) OrderMessageVO vo) {
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)vo));
        jsonObject.put("rocketMQTopic", (Object)"public_bizvane_message");
        jsonObject.put("rocketMQTag", (Object)"ORDER_CANCEL");
        jsonObject.put("bussinessModuleCode", (Object)"ORDER_CANCEL");
        jsonObject.put("bussinessType", (Object)"wechatOrderCancelMessage");
        jsonObject.put("rocketMQBussinessId", (Object)vo.getOrderNo());
        return this.rocketMQWechatService.sendMessage(jsonObject.toJSONString());
    }

    @PostMapping(value={"/integralOrderShip"})
    public Result<String> integralOrderShip(@RequestBody(required=false) OrderMessageVO vo) {
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)vo));
        jsonObject.put("rocketMQTopic", (Object)"public_bizvane_message");
        jsonObject.put("rocketMQTag", (Object)"ORDER_INTEGRAL_SHIP");
        jsonObject.put("bussinessModuleCode", (Object)"ORDER_INTEGRAL_SHIP");
        jsonObject.put("bussinessType", (Object)"wechatOrderIntegralShipMessage");
        jsonObject.put("rocketMQBussinessId", (Object)vo.getOrderNo());
        return this.rocketMQWechatService.sendMessage(jsonObject.toJSONString());
    }
}

