/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.message.cache.MerchantCacheCompoent;
import com.bizvane.message.cache.TemplateCacheComponent;
import com.bizvane.message.component.CallBackComponent;
import com.bizvane.message.component.bean.AliReportResp;
import com.bizvane.message.component.bean.AliStatusEnum;
import com.bizvane.message.component.bean.AliTemplateReportResponse;
import com.bizvane.message.component.bean.MessageCallBackDto;
import com.bizvane.message.component.bean.MessageNotifyStatusEnum;
import com.bizvane.message.component.bean.MessageStrategyEnum;
import com.bizvane.message.entity.Template;
import com.bizvane.message.service.TemplateService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/message"})
@Validated
public class AliCallBackController {
    private static final Logger log = LoggerFactory.getLogger(AliCallBackController.class);
    @Autowired
    private TemplateService templateService;
    @Autowired
    private MerchantCacheCompoent merchantCacheCompoent;
    @Autowired
    private CallBackComponent callBackComponent;
    @Autowired
    private TemplateCacheComponent templateCacheComponent;

    @RequestMapping(method={RequestMethod.POST}, value={"/receiveTemplateReport"})
    public AliReportResp receiveTemplateReport(@RequestBody JSONArray array) {
        log.info("\u63a5\u6536\u5230\u7684\u6a21\u677f\u4fe1\u606f\u4e3a:{}", (Object)array);
        AliReportResp aliReportResp = new AliReportResp();
        AliTemplateReportResponse response = (AliTemplateReportResponse)JSONObject.parseObject((String)JSONObject.toJSONString((Object)array.get(0)), AliTemplateReportResponse.class);
        Integer statusByAlistatus = AliStatusEnum.getStatusByAlistatus((String)response.getTemplateStatus());
        int count = this.templateService.updateTemplateStatus(response.getTemplateCode(), statusByAlistatus, response.getReason());
        if (statusByAlistatus != 0) {
            try {
                Template template = this.templateService.getTemplate(response.getTemplateCode());
                if (template != null) {
                    this.templateCacheComponent.set(template);
                }
            }
            catch (Exception e) {
                log.error("\u963f\u91cc\u6a21\u677f\u5ba1\u6838\u72b6\u6001\u56de\u8c03 set\u7f13\u5b58\u5931\u8d25:{},{}", (Object)e.getMessage(), (Object)e);
            }
        }
        if (count > 0) {
            aliReportResp.setCode(Integer.valueOf(0));
            aliReportResp.setMsg("\u63a5\u6536\u6210\u529f");
        }
        return aliReportResp;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/receiveSignReport"})
    public AliReportResp receiveSignReport(@RequestBody JSONArray array) {
        log.info("\u63a5\u6536\u5230\u7684\u7b7e\u540d\u6d88\u606f\u4e3a:{}", (Object)array);
        AliReportResp aliReportResp = new AliReportResp();
        aliReportResp.setCode(Integer.valueOf(0));
        aliReportResp.setMsg("\u63a5\u6536\u6210\u529f");
        return aliReportResp;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/receiveSmsUp"})
    public AliReportResp receiveSmsUp(@RequestBody JSONArray array) {
        log.info("\u63a5\u6536\u5230\u7684\u77ed\u4fe1\u7684\u4e0a\u884c\u6d88\u606f\u4e3a:{}", (Object)array);
        AliReportResp aliReportResp = new AliReportResp();
        aliReportResp.setCode(Integer.valueOf(0));
        aliReportResp.setMsg("\u63a5\u6536\u6210\u529f");
        return aliReportResp;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/receiveSmsReport"})
    public AliReportResp receiveSmsReport(@RequestBody JSONArray array) {
        log.info("\u63a5\u6536\u5230\u7684\u77ed\u4fe1\u7684\u4e0b\u884c\u6d88\u606f\u4e3a:{},{}", (Object)array, (Object)array.size());
        AliReportResp aliReportResp = new AliReportResp();
        aliReportResp.setCode(Integer.valueOf(0));
        aliReportResp.setMsg("\u63a5\u6536\u6210\u529f");
        for (int i = 0; i < array.size(); ++i) {
            String midAndBid;
            log.info("\u5904\u7406\u77ed\u4fe1\u6570\u636e:" + i);
            JSONObject jsonObject = array.getJSONObject(i);
            if (jsonObject == null) {
                return aliReportResp;
            }
            String out_id = jsonObject.getString("out_id");
            String biz_id = jsonObject.getString("biz_id");
            String string = midAndBid = StringUtils.isNotBlank((CharSequence)out_id) ? out_id : this.merchantCacheCompoent.getBizMerchantRelation(biz_id);
            if (StringUtils.isBlank((CharSequence)midAndBid)) {
                log.error("\u963f\u91cc\u77ed\u4fe1\u56de\u8c03\u63a5\u53e3\uff0c\u67e5\u8be2\u5546\u6237id\u5931\u8d25,out_id:{},biz_id:{}", (Object)out_id, (Object)biz_id);
                return aliReportResp;
            }
            try {
                String[] s = midAndBid.split("_");
                MessageCallBackDto dto = AliCallBackController.convertToDto((JSONObject)jsonObject);
                if (!jsonObject.getString("success").equals("true")) continue;
                this.callBackComponent.callBack(s[0], MessageStrategyEnum.ALI_STRATEGY.getType(), s[1], JSON.toJSONString((Object)dto));
                continue;
            }
            catch (Exception e) {
                log.error("ALI\u77ed\u4fe1\u56de\u8c03\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
            }
        }
        return aliReportResp;
    }

    private static MessageCallBackDto convertToDto(JSONObject json) {
        MessageCallBackDto dto = new MessageCallBackDto();
        dto.setReportTime(json.getString("report_time"));
        dto.setLength(json.getString("sms_size"));
        dto.setPhone(json.getString("phone_number"));
        String status = json.getString("err_code");
        String statusValue = MessageNotifyStatusEnum.getStatusValue((String)status);
        dto.setStatus(statusValue);
        dto.setStatusDesc(json.getString("err_msg"));
        return dto;
    }
}

