/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.client.web;

import com.bizvane.base.common.bean.ResultBean;
import com.bizvane.base.remote.dto.ChannelDto;
import com.bizvane.base.remote.dto.MerchantDto;
import com.bizvane.message.client.api.RemoteMerchantService;
import java.util.ArrayList;
import javax.validation.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/message"})
@Validated
public class RemoteMerchantController {
    private static final Logger log = LoggerFactory.getLogger(RemoteMerchantController.class);
    @Autowired
    private RemoteMerchantService service;

    @RequestMapping(method={RequestMethod.POST}, value={"/saveMerchant"}, consumes={"application/json;charset=UTF-8"}, produces={"application/json"})
    public ResultBean<MerchantDto> saveMerchant(@RequestParam(value="companyName") @NotBlank(message="companyName not null") @NotBlank(message="companyName not null") String companyName, @RequestParam(value="brandName") @NotBlank(message="brandName not null") @NotBlank(message="brandName not null") String brandName, @RequestParam(value="notifyUrl") @NotBlank(message="notifyUrl not null") @NotBlank(message="notifyUrl not null") String notifyUrl) {
        return this.service.saveMerchant(companyName, brandName, notifyUrl);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/updateMerchant"}, consumes={"application/json;charset=UTF-8"}, produces={"application/json"})
    public ResultBean<MerchantDto> updateMerchant(@RequestParam(value="merchantId") @NotBlank(message="merchantId not null") @NotBlank(message="merchantId not null") String merchantId, @RequestParam(value="companyName", required=false) String companyName, @RequestParam(value="brandName", required=false) String brandName, @RequestParam(value="notifyUrl", required=false) String notifyUrl) {
        return this.service.updateMerchant(merchantId, companyName, brandName, notifyUrl);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/getMerchant"}, consumes={"application/json;charset=UTF-8"}, produces={"application/json"})
    public ResultBean<MerchantDto> getMerchant(@RequestParam(value="merchantId") @NotBlank(message="merchantId not null") @NotBlank(message="merchantId not null") String merchantId) {
        return this.service.getMerchant(merchantId);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/deleteMerchant"}, consumes={"application/json;charset=UTF-8"}, produces={"application/json"})
    public ResultBean deleteMerchant(@RequestParam(value="merchantId") @NotBlank(message="merchantId not null") @NotBlank(message="merchantId not null") String merchantId) {
        return this.service.deleteMerchant(merchantId);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/saveChannel"}, consumes={"application/json;charset=UTF-8"}, produces={"application/json"})
    public ResultBean<ChannelDto> saveChannel(@RequestParam(value="merchantId") @NotBlank(message="merchantId not null") @NotBlank(message="merchantId not null") String merchantId, @RequestParam(value="channelName") @NotBlank(message="channelName not null") @NotBlank(message="channelName not null") String channelName, @RequestParam(value="channelType") @NotBlank(message="channelType not null") @NotBlank(message="channelType not null") String channelType, @RequestParam(value="accountJson") @NotBlank(message="accountJson not null") @NotBlank(message="accountJson not null") String accountJson) {
        return this.service.saveChannel(merchantId, channelName, channelType, accountJson);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/findByMerchantId"}, consumes={"application/json;charset=UTF-8"}, produces={"application/json"})
    public ResultBean<ArrayList<ChannelDto>> findByMerchantId(@RequestParam(value="merchantId") @NotBlank(message="merchantId not null") @NotBlank(message="merchantId not null") String merchantId) {
        return this.service.findByMerchantId(merchantId);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/updateChannel"}, consumes={"application/json;charset=UTF-8"}, produces={"application/json"})
    public ResultBean<ChannelDto> updateChannel(@RequestParam(value="merchantId") @NotBlank(message="merchantId not null") @NotBlank(message="merchantId not null") String merchantId, @RequestParam(value="channelName") @NotBlank(message="channelName not null") @NotBlank(message="channelName not null") String channelName, @RequestParam(value="channelType") @NotBlank(message="channelType not null") @NotBlank(message="channelType not null") String channelType, @RequestParam(value="accountJson") @NotBlank(message="accountJson not null") @NotBlank(message="accountJson not null") String accountJson) {
        return this.service.updateChannel(merchantId, channelName, channelType, accountJson);
    }
}

