/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.component;

import com.alibaba.fastjson.JSON;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.bizvane.base.common.bean.SmsResBean;
import com.bizvane.message.cache.entity.ChannelConfigCache;
import com.bizvane.message.component.BaseComponent;
import com.bizvane.message.component.BatchOperationMessage;
import com.bizvane.message.component.MessageAccount;
import com.bizvane.message.component.bean.AliSmsResponse;
import com.bizvane.message.component.bean.AliSmsSignResponse;
import com.bizvane.message.component.bean.AliSmsTemplateResponse;
import com.bizvane.message.component.bean.BizvaneExceptionEnum;
import com.bizvane.message.component.bean.MessageException;
import com.bizvane.message.component.bean.SignatureBean;
import com.bizvane.message.component.bean.TemplateBean;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="ALIBABA_STRATEGY")
public class AliSmsComponent
extends BaseComponent {
    private static final Logger log = LoggerFactory.getLogger(AliSmsComponent.class);

    private IAcsClient getClient(String accountJson) {
        MessageAccount account = (MessageAccount)JSON.parseArray((String)accountJson, MessageAccount.class).get(0);
        DefaultProfile profile = DefaultProfile.getProfile((String)account.getRegionId(), (String)account.getAccessKeyId(), (String)account.getSecret());
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        return client;
    }

    private CommonRequest createCommonRequest(String action, Map<String, String> para) {
        CommonRequest request = new CommonRequest();
        request.setSysMethod(MethodType.POST);
        request.setSysDomain("dysmsapi.aliyuncs.com");
        request.setSysVersion("2017-05-25");
        request.setSysAction(action);
        Set<String> keys = para.keySet();
        for (String key : keys) {
            request.putQueryParameter(key, para.get(key));
        }
        return request;
    }

    public TemplateBean callUpdateTemplate(ChannelConfigCache channelConfig, String templateName, String templateContent, String templateType, String remark, String templateCode, String sign, String postFix) throws MessageException {
        IAcsClient client = this.getClient(channelConfig.getAccountJson());
        HashMap map = Maps.newHashMap();
        map.put("TemplateType", templateType);
        map.put("TemplateName", templateName);
        map.put("TemplateCode", templateCode);
        map.put("TemplateContent", templateContent);
        map.put("Remark", remark);
        CommonRequest request = this.createCommonRequest("ModifySmsTemplate", (Map)map);
        TemplateBean templateBean = null;
        try {
            log.info("\u66f4\u65b0\u77ed\u4fe1\u6a21\u677f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)request));
            CommonResponse response = client.getCommonResponse(request);
            log.info("\u77ed\u4fe1\u6a21\u7248\u66f4\u65b0\u7ed3\u679c: {}", (Object)response.getData());
            AliSmsTemplateResponse templateResponse = (AliSmsTemplateResponse)JSON.parseObject((String)response.getData(), AliSmsTemplateResponse.class);
            if (!"OK".equals(templateResponse.getCode())) {
                log.info("\u66f4\u65b0\u6a21\u677f\u5931\u8d25:requestId:{},code:{},message:{}", new Object[]{templateResponse.getRequestId(), templateResponse.getCode(), templateResponse.getMessage()});
                throw MessageException.newBuilder().errCode(templateResponse.getCode()).errCodeDes(templateResponse.getMessage()).build();
            }
            templateBean = TemplateBean.builder().templateCode(templateResponse.getTemplateCode()).templateName(templateName).content(templateContent).remark(remark).templateType(templateType).auditReason(templateResponse.getReason()).build();
        }
        catch (ServerException e) {
            log.error("\u77ed\u4fe1\u6a21\u7248\u66f4\u65b0server\u5f02\u5e38: {}", (Throwable)e);
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.ALI_ERROR.getErrCode()).errCodeDes("\u66f4\u65b0\u6a21\u677fserver:" + e.getMessage()).build();
        }
        catch (ClientException e) {
            log.error("\u77ed\u4fe1\u6a21\u7248\u66f4\u65b0client\u5f02\u5e38: {}", (Throwable)e);
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.ALI_ERROR.getErrCode()).errCodeDes("\u66f4\u65b0\u6a21\u677fclient:" + e.getMessage()).build();
        }
        return templateBean;
    }

    public TemplateBean callDeleteTemplate(ChannelConfigCache channelConfig, String templateCode) throws MessageException {
        IAcsClient client = this.getClient(channelConfig.getAccountJson());
        HashMap map = Maps.newHashMap();
        map.put("TemplateCode", templateCode);
        CommonRequest request = this.createCommonRequest("DeleteSmsTemplate", (Map)map);
        TemplateBean templateBean = null;
        try {
            log.info("\u5220\u9664\u77ed\u4fe1\u6a21\u677f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)request));
            CommonResponse response = client.getCommonResponse(request);
            log.info("\u5220\u9664\u6a21\u677f\u540e\u7684\u7ed3\u679c:{}", (Object)response.getData());
            AliSmsTemplateResponse templateResponse = (AliSmsTemplateResponse)JSON.parseObject((String)response.getData(), AliSmsTemplateResponse.class);
            if (!"OK".equals(templateResponse.getCode())) {
                log.info("\u5220\u9664\u6a21\u677f\u5931\u8d25:requestId:{},code:{},message:{}", new Object[]{templateResponse.getRequestId(), templateResponse.getCode(), templateResponse.getMessage()});
                throw MessageException.newBuilder().errCode(templateResponse.getCode()).errCodeDes(templateResponse.getMessage()).build();
            }
            templateBean = TemplateBean.builder().templateCode(templateResponse.getTemplateCode()).build();
        }
        catch (ServerException e) {
            log.info("\u5220\u9664\u6a21\u677f\u540e\u5931\u8d25:{}", (Throwable)e);
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.ALI_ERROR.getErrCode()).errCodeDes("\u5220\u9664\u6a21\u677fserver:" + e.getMessage()).build();
        }
        catch (ClientException e) {
            log.info("\u5220\u9664\u6a21\u677f\u540e\u5931\u8d25:{}", (Throwable)e);
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.ALI_ERROR.getErrCode()).errCodeDes("\u5220\u9664\u6a21\u677fclient:" + e.getMessage()).build();
        }
        return templateBean;
    }

    public TemplateBean callCreateTemplate(ChannelConfigCache channelConfig, String templateName, String templateType, String content, String remark, String sign, String postFix) throws MessageException {
        IAcsClient client = this.getClient(channelConfig.getAccountJson());
        HashMap map = Maps.newHashMap();
        map.put("TemplateType", templateType);
        map.put("TemplateName", templateName);
        map.put("TemplateContent", StringUtils.isBlank((CharSequence)postFix) ? content : content + " " + postFix);
        map.put("Remark", remark);
        CommonRequest request = this.createCommonRequest("AddSmsTemplate", (Map)map);
        TemplateBean templateBean = null;
        try {
            log.info("\u521b\u5efa\u77ed\u4fe1\u6a21\u677f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)request));
            CommonResponse response = client.getCommonResponse(request);
            log.info("\u77ed\u4fe1\u6a21\u7248\u521b\u5efa\u7ed3\u679c: {}", (Object)response.getData());
            AliSmsTemplateResponse templateResponse = (AliSmsTemplateResponse)JSON.parseObject((String)response.getData(), AliSmsTemplateResponse.class);
            if (!"OK".equals(templateResponse.getCode())) {
                log.info("\u521b\u5efa\u6a21\u677f\u5931\u8d25:requestId:{},code:{},message:{}", new Object[]{templateResponse.getRequestId(), templateResponse.getCode(), templateResponse.getMessage()});
                throw MessageException.newBuilder().errCode(templateResponse.getCode()).errCodeDes(templateResponse.getMessage()).build();
            }
            templateBean = TemplateBean.builder().templateCode(templateResponse.getTemplateCode()).templateName(templateName).remark(remark).templateType(templateType).content(StringUtils.isBlank((CharSequence)postFix) ? content : content + " " + postFix).postFix(postFix).status("0").build();
        }
        catch (ServerException e) {
            log.error("\u77ed\u4fe1\u6a21\u7248\u521b\u5efaserver\u5f02\u5e38: {}", (Throwable)e);
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.ALI_ERROR.getErrCode()).errCodeDes("\u521b\u5efa\u6a21\u677fserver:" + e.getMessage()).build();
        }
        catch (ClientException e) {
            log.error("\u77ed\u4fe1\u6a21\u7248\u521b\u5efaclient\u5f02\u5e38: {}", (Throwable)e);
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.ALI_ERROR.getErrCode()).errCodeDes("\u521b\u5efa\u6a21\u677fclient:" + e.getMessage()).build();
        }
        return templateBean;
    }

    public TemplateBean callQueryTemplate(ChannelConfigCache channelConfig, String templateId) throws MessageException {
        TemplateBean templateBean = null;
        IAcsClient client = this.getClient(channelConfig.getAccountJson());
        HashMap map = Maps.newHashMap();
        map.put("RegionId", "cn-hangzhou");
        map.put("TemplateCode", templateId);
        CommonRequest request = this.createCommonRequest("QuerySmsTemplate", (Map)map);
        try {
            log.info("\u67e5\u8be2\u77ed\u4fe1\u6a21\u677f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)request));
            CommonResponse response = client.getCommonResponse(request);
            log.info("\u77ed\u4fe1\u6a21\u7248\u67e5\u8be2\u7ed3\u679c: {}", (Object)response.getData());
            AliSmsTemplateResponse templateResponse = (AliSmsTemplateResponse)JSON.parseObject((String)response.getData(), AliSmsTemplateResponse.class);
            if (!"OK".equals(templateResponse.getCode())) {
                log.info("\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u5931\u8d25:requestId:{},code:{},message:{}", new Object[]{templateResponse.getRequestId(), templateResponse.getCode(), templateResponse.getMessage()});
                throw MessageException.newBuilder().errCode(templateResponse.getCode()).errCodeDes(templateResponse.getMessage()).build();
            }
            templateBean = TemplateBean.builder().auditReason(templateResponse.getReason()).templateType(String.valueOf(templateResponse.getTemplateType())).status(String.valueOf(templateResponse.getTemplateStatus())).templateName(templateResponse.getTemplateName()).content(templateResponse.getTemplateContent()).createTime(templateResponse.getCreateDate()).templateCode(templateId).auditReason(templateResponse.getReason()).build();
        }
        catch (ServerException e) {
            log.error("\u77ed\u4fe1\u6a21\u7248\u67e5\u8be2server\u5f02\u5e38: {}", (Throwable)e);
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.ALI_ERROR.getErrCode()).errCodeDes("\u67e5\u8be2\u6a21\u677fserver:" + e.getMessage()).build();
        }
        catch (ClientException e) {
            log.error("\u77ed\u4fe1\u6a21\u7248\u67e5\u8be2client\u5f02\u5e38: {}", (Throwable)e);
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.ALI_ERROR.getErrCode()).errCodeDes("\u67e5\u8be2\u6a21\u677fClient:" + e.getMessage()).build();
        }
        return templateBean;
    }

    public SignatureBean callCreateSignature(ChannelConfigCache channelConfig, String signName, String signSource, String remark, String fileSuffix, String fileContents, String sceneType, String isOnline, String webSite, String app) throws MessageException {
        IAcsClient client = this.getClient(channelConfig.getAccountJson());
        HashMap map = Maps.newHashMap();
        map.put("SignName", signName);
        map.put("SignSource", signSource);
        map.put("Remark", remark);
        map.put("SignFileList.1.FileSuffix", fileSuffix);
        map.put("SignFileList.1.FileContents", fileContents);
        CommonRequest request = this.createCommonRequest("AddSmsSign", (Map)map);
        SignatureBean signatureBean = null;
        try {
            log.info("\u65b0\u5efa\u77ed\u4fe1\u7b7e\u540d\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)request));
            CommonResponse response = client.getCommonResponse(request);
            log.info("\u77ed\u4fe1\u7b7e\u540d\u65b0\u5efa\u7ed3\u679c: {}", (Object)response.getData());
            AliSmsSignResponse aliSmsSignResponse = (AliSmsSignResponse)JSON.parseObject((String)response.getData(), AliSmsSignResponse.class);
            if (!"OK".equals(aliSmsSignResponse.getCode())) {
                log.info("\u65b0\u5efa\u7b7e\u540d\u5931\u8d25:requestId:{},code:{},message:{}", new Object[]{aliSmsSignResponse.getRequestId(), aliSmsSignResponse.getCode(), aliSmsSignResponse.getMessage()});
                throw MessageException.newBuilder().errCode(aliSmsSignResponse.getCode()).errCodeDes(aliSmsSignResponse.getMessage()).build();
            }
            signatureBean = SignatureBean.builder().signStatus(Integer.valueOf(0)).signName(aliSmsSignResponse.getSignName()).build();
        }
        catch (ServerException e) {
            log.error("\u77ed\u4fe1\u7b7e\u540d\u65b0\u5efa\u7ed3\u679c: {}", (Throwable)e);
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.ALI_ERROR.getErrCode()).errCodeDes("\u65b0\u5efa\u7b7e\u540dServer:" + e.getMessage()).build();
        }
        catch (ClientException e) {
            log.error("\u77ed\u4fe1\u7b7e\u540d\u65b0\u5efa\u7ed3\u679c: {}", (Throwable)e);
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.ALI_ERROR.getErrCode()).errCodeDes("\u65b0\u5efa\u7b7e\u540dClient:" + e.getMessage()).build();
        }
        return signatureBean;
    }

    public SignatureBean callUpdateSignature(ChannelConfigCache channelConfig, String signName, String signSource, String remark, String fileSuffix, String fileContents) throws MessageException {
        IAcsClient client = this.getClient(channelConfig.getAccountJson());
        HashMap map = Maps.newHashMap();
        map.put("SignName", signName);
        map.put("SignSource", signSource);
        map.put("Remark", remark);
        map.put("SignFileList.1.FileSuffix", "\u8bc1\u4e66.jpg");
        map.put("SignFileList.1.FileContents", "\u7b7e\u540d\u7684\u8d28\u8bc1\u660e\u6587\u4ef6\u7ecfbase64\u7f16\u7801\u540e\u7684\u5b57\u7b26\u4e32\uff0c\u56fe\u7247\u4e0d\u8d85\u8fc72 MB");
        CommonRequest request = this.createCommonRequest("ModifySmsSign", (Map)map);
        SignatureBean signatureBean = null;
        try {
            log.info("\u66f4\u6539\u77ed\u4fe1\u7b7e\u540d\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)request));
            CommonResponse response = client.getCommonResponse(request);
            log.info("\u66f4\u6539\u7b7e\u540d\u540e\u7684\u7ed3\u679c:{}", (Object)response.getData());
            AliSmsSignResponse aliSmsSignResponse = (AliSmsSignResponse)JSON.parseObject((String)response.getData(), AliSmsSignResponse.class);
            if (!"OK".equals(aliSmsSignResponse.getCode())) {
                log.info("\u66f4\u6539\u7b7e\u540d\u5931\u8d25:requestId:{},code:{},message:{}", new Object[]{aliSmsSignResponse.getRequestId(), aliSmsSignResponse.getCode(), aliSmsSignResponse.getMessage()});
                throw MessageException.newBuilder().errCode(aliSmsSignResponse.getCode()).errCodeDes(aliSmsSignResponse.getMessage()).build();
            }
            signatureBean = SignatureBean.builder().signStatus(Integer.valueOf(0)).signName(aliSmsSignResponse.getSignName()).build();
        }
        catch (ServerException e) {
            log.error("\u77ed\u4fe1\u7b7e\u540d\u66f4\u65b0Server\u5f02\u5e38:{}, {}", (Object)e.getMessage(), (Object)e);
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.ALI_ERROR.getErrCode()).errCodeDes("\u5220\u9664\u7b7e\u540dServer:" + e.getMessage()).build();
        }
        catch (ClientException e) {
            log.error("\u77ed\u4fe1\u7b7e\u540d\u66f4\u65b0Client\u5f02\u5e38:{}, {}", (Object)e.getMessage(), (Object)e);
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.ALI_ERROR.getErrCode()).errCodeDes("\u5220\u9664\u7b7e\u540dClient:" + e.getMessage()).build();
        }
        return signatureBean;
    }

    public SignatureBean callDeleteSignature(ChannelConfigCache channelConfig, String signature, String signatureId) throws MessageException {
        SignatureBean signatureBean;
        IAcsClient client = this.getClient(channelConfig.getAccountJson());
        HashMap map = Maps.newHashMap();
        map.put("SignName", signature);
        CommonRequest request = this.createCommonRequest("DeleteSmsSign", (Map)map);
        try {
            log.info("\u5220\u9664\u77ed\u4fe1\u7b7e\u540d\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)request));
            CommonResponse response = client.getCommonResponse(request);
            log.info("\u77ed\u4fe1\u7b7e\u540d\u5220\u9664\u7ed3\u679c: {}", (Object)response.getData());
            AliSmsSignResponse aliSmsSignResponse = (AliSmsSignResponse)JSON.parseObject((String)response.getData(), AliSmsSignResponse.class);
            if (!"OK".equals(aliSmsSignResponse.getCode())) {
                log.info("\u5220\u9664\u7b7e\u540d\u5931\u8d25:requestId:{},code:{},message:{}", new Object[]{aliSmsSignResponse.getRequestId(), aliSmsSignResponse.getCode(), aliSmsSignResponse.getMessage()});
                throw MessageException.newBuilder().errCode(aliSmsSignResponse.getCode()).errCodeDes(aliSmsSignResponse.getMessage()).build();
            }
            signatureBean = SignatureBean.builder().signName(aliSmsSignResponse.getSignName()).build();
        }
        catch (ServerException e) {
            log.error("\u77ed\u4fe1\u7b7e\u540d\u5220\u9664server\u5f02\u5e38: {}", (Throwable)e);
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.ALI_ERROR.getErrCode()).errCodeDes("\u5220\u9664\u7b7e\u540dServer:" + e.getMessage()).build();
        }
        catch (ClientException e) {
            log.error("\u77ed\u4fe1\u7b7e\u540d\u5220\u9664Client\u5f02\u5e38: {}", (Throwable)e);
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.ALI_ERROR.getErrCode()).errCodeDes("\u5220\u9664\u7b7e\u540dClient:" + e.getMessage()).build();
        }
        return signatureBean;
    }

    public SignatureBean callQuerySignature(ChannelConfigCache channelConfig) throws MessageException {
        IAcsClient client = this.getClient(channelConfig.getAccountJson());
        HashMap map = Maps.newHashMap();
        map.put("SignName", "\u5546\u5e06");
        CommonRequest request = this.createCommonRequest("QuerySmsSign", (Map)map);
        SignatureBean signatureBean = null;
        try {
            log.info("\u67e5\u8be2\u77ed\u4fe1\u7b7e\u540d\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)request));
            CommonResponse response = client.getCommonResponse(request);
            log.info("\u77ed\u4fe1\u7b7e\u540d\u67e5\u8be2\u7ed3\u679c: {}", (Object)response.getData());
            AliSmsSignResponse aliSmsSignResponse = (AliSmsSignResponse)JSON.parseObject((String)response.getData(), AliSmsSignResponse.class);
            if (!"OK".equals(aliSmsSignResponse.getCode())) {
                log.info("\u67e5\u8be2\u7b7e\u540d\u5931\u8d25:requestId:{},code:{},message:{}", new Object[]{aliSmsSignResponse.getRequestId(), aliSmsSignResponse.getCode(), aliSmsSignResponse.getMessage()});
                throw MessageException.newBuilder().errCode(aliSmsSignResponse.getCode()).errCodeDes(aliSmsSignResponse.getMessage()).build();
            }
            signatureBean = SignatureBean.builder().createDate(aliSmsSignResponse.getCreateDate()).reason(aliSmsSignResponse.getReason()).signName(aliSmsSignResponse.getSignName()).signStatus(aliSmsSignResponse.getSignStatus()).build();
        }
        catch (ServerException e) {
            log.error("\u77ed\u4fe1\u7b7e\u540d\u67e5\u8be2\u7ed3\u679c: {}", (Throwable)e);
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.ALI_ERROR.getErrCode()).errCodeDes("\u67e5\u8be2\u7b7e\u540dServer:" + e.getMessage()).build();
        }
        catch (ClientException e) {
            log.error("\u77ed\u4fe1\u7b7e\u540d\u67e5\u8be2\u7ed3\u679c: {}", (Throwable)e);
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.ALI_ERROR.getErrCode()).errCodeDes("\u67e5\u8be2\u7b7e\u540dClient:" + e.getMessage()).build();
        }
        return signatureBean;
    }

    public SmsResBean callSendSms(ChannelConfigCache channelConfig, String phone, String templateCode, Map<String, String> param, String templateContent, String signature, String batchid) throws MessageException {
        if (StringUtils.isBlank((CharSequence)templateCode)) {
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.EMPTY_PARAM_ERROR.getErrCode()).errCodeDes(BizvaneExceptionEnum.EMPTY_PARAM_ERROR.getErrCodeDes()).build();
        }
        IAcsClient client = this.getClient(channelConfig.getAccountJson());
        HashMap map = Maps.newHashMap();
        map.put("PhoneNumbers", phone);
        map.put("SignName", signature);
        map.put("TemplateCode", templateCode);
        map.put("TemplateParam", JSON.toJSONString(param));
        map.put("OutId", channelConfig.getMerchantId() + "_" + batchid);
        CommonRequest request = this.createCommonRequest("SendSms", (Map)map);
        SmsResBean result = null;
        try {
            log.info("\u53d1\u9001\u77ed\u4fe1\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)request));
            CommonResponse response = client.getCommonResponse(request);
            log.info("\u53d1\u9001\u77ed\u4fe1\u7684\u7ed3\u679c:{}", (Object)response.getData());
            AliSmsResponse aliSmsResponse = (AliSmsResponse)JSON.parseObject((String)response.getData(), AliSmsResponse.class);
            result = "OK".equals(aliSmsResponse.getCode()) ? SmsResBean.builder().msgId(aliSmsResponse.getBizId()).requestId(aliSmsResponse.getRequestId()).errorCode("0").errorReason("\u53d1\u9001\u6210\u529f").build() : SmsResBean.builder().errorCode(aliSmsResponse.getCode()).errorReason(aliSmsResponse.getMessage()).requestId(aliSmsResponse.getRequestId()).msgId(null).build();
        }
        catch (ServerException e) {
            log.error("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25Server\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.ALI_ERROR.getErrCode()).errCodeDes("\u53d1\u9001\u77ed\u4fe1Server:" + e.getMessage()).build();
        }
        catch (ClientException e) {
            log.error("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25Client\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.ALI_ERROR.getErrCode()).errCodeDes("\u53d1\u9001\u77ed\u4fe1Client:" + e.getMessage()).build();
        }
        return result;
    }

    public SmsResBean callQuerySms(ChannelConfigCache channelConfig, String phone, String sendDate, String pageSize, String currentPage, String requestId) throws MessageException {
        SmsResBean smsResBean = null;
        IAcsClient client = this.getClient(channelConfig.getAccountJson());
        HashMap map = Maps.newHashMap();
        map.put("PhoneNumber", phone);
        map.put("SendDate", sendDate);
        map.put("PageSize", pageSize);
        map.put("CurrentPage", currentPage);
        map.put("BizId", requestId);
        CommonRequest request = this.createCommonRequest("QuerySendDetails", (Map)map);
        try {
            log.info("\u67e5\u8be2\u77ed\u4fe1\u8be6\u60c5\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)request));
            CommonResponse response = client.getCommonResponse(request);
            log.info("\u67e5\u8be2\u77ed\u4fe1\u7ed3\u679c:{}", (Object)response.getData());
            AliSmsResponse aliSmsResponse = (AliSmsResponse)JSON.parseObject((String)response.getData(), AliSmsResponse.class);
            log.info("\u67e5\u8be2\u77ed\u4fe1\u7ed3\u679c\u8f6c\u6362\u540e\u4e3a:{}", (Object)JSON.toJSONString((Object)aliSmsResponse));
            if ("OK".equals(aliSmsResponse.getCode())) {
                smsResBean = SmsResBean.builder().totalCount(aliSmsResponse.getTotalCount()).build();
            }
        }
        catch (ServerException e) {
            log.error("\u67e5\u8be2\u77ed\u4fe1\u5931\u8d25Server\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.ALI_ERROR.getErrCode()).errCodeDes("\u67e5\u8be2\u77ed\u4fe1Server:" + e.getMessage()).build();
        }
        catch (ClientException e) {
            log.error("\u67e5\u8be2\u77ed\u4fe1\u5931\u8d25client\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.ALI_ERROR.getErrCode()).errCodeDes("\u67e5\u8be2\u77ed\u4fe1Client:" + e.getMessage()).build();
        }
        return smsResBean;
    }

    public SmsResBean callSendSmsBatch(ChannelConfigCache channelConfig, String templateCode, String templateContent, List<BatchOperationMessage> list, List<String> phoneList, String batchid) throws MessageException {
        SmsResBean result = null;
        IAcsClient client = this.getClient(channelConfig.getAccountJson());
        ArrayList phones = Lists.newArrayList();
        ArrayList signatures = Lists.newArrayList();
        ArrayList params = Lists.newArrayList();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                phones.add(list.get(i).getPhone());
                signatures.add(list.get(i).getSignature());
                params.add(list.get(i).getParams());
            }
        }
        HashMap map = Maps.newHashMap();
        map.put("PhoneNumberJson", JSON.toJSONString((Object)phones));
        map.put("SignNameJson", JSON.toJSONString((Object)signatures));
        map.put("TemplateCode", templateCode);
        map.put("TemplateParamJson", JSON.toJSONString((Object)params));
        map.put("OutId", channelConfig.getMerchantId() + "_" + batchid);
        CommonRequest request = this.createCommonRequest("SendBatchSms", (Map)map);
        try {
            log.info("\u6279\u91cf\u53d1\u77ed\u4fe1\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)request));
            CommonResponse response = client.getCommonResponse(request);
            log.info("\u6279\u91cf\u53d1\u9001\u77ed\u4fe1\u7ed3\u679c:{}", (Object)response.getData());
            AliSmsResponse aliSmsResponse = (AliSmsResponse)JSON.parseObject((String)response.getData(), AliSmsResponse.class);
            result = "OK".equals(aliSmsResponse.getCode()) ? SmsResBean.builder().msgId(aliSmsResponse.getBizId()).requestId(aliSmsResponse.getRequestId()).errorCode("0").errorReason("\u6279\u91cf\u53d1\u9001\u6210\u529f").build() : SmsResBean.builder().errorCode(aliSmsResponse.getCode()).errorReason(aliSmsResponse.getMessage()).requestId(aliSmsResponse.getRequestId()).msgId(null).build();
        }
        catch (ServerException e) {
            log.error("\u6279\u91cf\u53d1\u9001\u77ed\u4fe1\u5931\u8d25Server\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.ALI_ERROR.getErrCode()).errCodeDes("\u6279\u91cf\u53d1\u9001\u77ed\u4fe1Server:" + e.getMessage()).build();
        }
        catch (ClientException e) {
            log.error("\u6279\u91cf\u53d1\u9001\u77ed\u4fe1\u5931\u8d25Client\u5f02\u5e38:{},{}", (Object)e.getMessage(), (Object)e);
            throw MessageException.newBuilder().errCode(BizvaneExceptionEnum.ALI_ERROR.getErrCode()).errCodeDes("\u6279\u91cf\u53d1\u9001\u77ed\u4fe1Client:" + e.getMessage()).build();
        }
        return result;
    }
}

