/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.mq;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.bizvane.base.common.bean.SmsMqRequest;
import com.bizvane.message.component.BaseComponent;
import com.bizvane.message.component.bean.MessageException;
import com.bizvane.message.component.bean.MessageStrategyEnum;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@RocketMQMessageListener(topic="MESSAGE_SEND_VARCODE_SINGLE_NEW")
public class VerCodeSingleConsumer
implements RocketMQListener<SmsMqRequest> {
    private static final Logger log = LoggerFactory.getLogger(VerCodeSingleConsumer.class);
    @Autowired
    private Map<String, BaseComponent> baseComponentMap;

    public void onMessage(ConsumerMessage<SmsMqRequest> consumerMessage) {
        log.info("\u5355\u4e2a\u9a8c\u8bc1\u7801\u77ed\u4fe1\u8fdb\u5165");
        SmsMqRequest message = (SmsMqRequest)consumerMessage.getMessage();
        String tags = consumerMessage.getTags();
        if (tags.contains("_")) {
            tags = tags.split("_")[0];
        }
        String strategy = MessageStrategyEnum.getStrategyByType((String)tags);
        BaseComponent component = (BaseComponent)this.baseComponentMap.get(strategy);
        try {
            component.sendSms(message.getMerchantId(), message.getType(), message.getChannelTypeSuffix(), String.join((CharSequence)",", message.getPhones()), message.getTemplateCode(), (String)message.getSignatures().get(0), !CollectionUtils.isEmpty((Collection)message.getParams()) ? (Map)message.getParams().get(0) : null, message.getBatchid());
        }
        catch (MessageException e) {
            log.error("\u53d1\u77ed\u4fe1MessageException\u5f02\u5e38:{},{}", (Object)e.getCustomErrorMsg(), (Object)e);
        }
    }
}

