/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.message.service;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bizvane.base.common.bean.ListResultBean;
import com.bizvane.base.common.bean.Pagination;
import com.bizvane.base.remote.dto.TemplateDto;
import com.bizvane.message.dao.TemplateDao;
import com.bizvane.message.entity.Template;
import com.bizvane.message.service.inter.ITemplateService;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TemplateService
implements ITemplateService {
    private static final Logger log = LoggerFactory.getLogger(TemplateService.class);
    @Autowired
    private TemplateDao templateDao;

    public Template getTemplate(String merchantId, String channelId, String templateId) {
        Template template = this.templateDao.getByTemplateId(merchantId, channelId, templateId);
        return template;
    }

    public Template getTemplate(String templateId) {
        Template template = this.templateDao.getByTemplateId(templateId);
        return template;
    }

    public Template save(String channelId, String merchantId, String templateCode, Integer status, String content, String templateName, String templateType, String remark, Integer valid, String sysCode, String originalContent, String attach, String postFix) {
        Template template = Template.builder().merchantId(merchantId).channelId(channelId).templateId(templateCode).status(status).content(content).templateName(templateName).templateType(templateType).remark(remark).createTime(new Date()).updateTime(new Date()).valid(valid).sysCode(sysCode).originalContent(originalContent).attach(attach).postFix(postFix).build();
        try {
            this.templateDao.insert((Object)template);
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u6a21\u677f\u8868\u5931\u8d25:{},{}", (Object)e.getMessage(), (Object)e);
        }
        return template;
    }

    public Template updateTemplate(String templateType, String templateName, String conent, Integer status, String merchantId, String channelId, String templateCode, String remark, Integer valid, String reason) {
        log.info("\u66f4\u65b0\u6a21\u677f\u53c2\u6570templateType:{},templateName:{},conent:{},status:{},merchantId:{},channelId:{},templateCode:{},remark:{},valid:{},reason:{}", new Object[]{templateType, templateName, conent, status, merchantId, channelId, templateCode, remark, valid, reason});
        Template template = Template.builder().templateType(templateType).templateName(templateName).content(conent).updateTime(new Date()).status(status).remark(remark).reason(reason).build();
        UpdateWrapper update = Wrappers.update();
        update.eq((Object)"merchant_id", (Object)merchantId);
        update.eq((Object)"channel_id", (Object)channelId);
        update.eq((Object)"template_id", (Object)templateCode);
        update.eq((Object)"valid", (Object)valid);
        this.templateDao.update((Object)template, (Wrapper)update);
        return template;
    }

    public void updateTemplateValid(String merchantId, String channelId, String templateCode) {
        this.templateDao.updateTemplateValid(merchantId, channelId, templateCode);
    }

    public int updateTemplateStatus(String templateCode, Integer status, String reason) {
        int count = this.templateDao.updateTemplateStatus(templateCode, status, reason);
        return count;
    }

    public ListResultBean<TemplateDto> getPage(String merchantId, String channelId, String templateCode, String templateType, String templateName, String remark, String status, String sysCode, Long pageNum, Long pageSize) {
        QueryWrapper query = Wrappers.query();
        query.eq((Object)"merchant_id", (Object)merchantId);
        query.eq((Object)"valid", (Object)1);
        query.eq(!StringUtils.isBlank((CharSequence)channelId), (Object)"channel_id", (Object)channelId);
        query.like(!StringUtils.isBlank((CharSequence)templateCode), (Object)"template_id", (Object)templateCode);
        query.eq(!StringUtils.isBlank((CharSequence)sysCode), (Object)"sys_code", (Object)sysCode);
        query.eq(!StringUtils.isBlank((CharSequence)templateType), (Object)"template_type", (Object)templateType);
        query.eq(!StringUtils.isBlank((CharSequence)status), (Object)"status", (Object)status);
        query.like(!StringUtils.isBlank((CharSequence)templateName), (Object)"template_name", (Object)templateName);
        query.like(!StringUtils.isBlank((CharSequence)remark), (Object)"remark", (Object)remark);
        query.orderByDesc((Object)"create_time");
        Page pages = (Page)this.templateDao.selectPage((IPage)new Page(pageNum.longValue(), pageSize.longValue()), (Wrapper)query);
        List templateDtos = pages.getRecords().stream().map(e -> {
            TemplateDto dto = new TemplateDto();
            dto.setStatus(e.getStatus() == null ? "" : e.getStatus().toString());
            dto.setContent(e.getContent());
            dto.setRemark(e.getRemark());
            dto.setTemplateType(e.getTemplateType());
            dto.setTemplateName(e.getTemplateName());
            dto.setTemplateCode(e.getTemplateId());
            dto.setAuditReason(e.getReason());
            dto.setOriginalContent(e.getOriginalContent());
            dto.setAttach(e.getAttach());
            dto.setCreateTime(DateUtil.format((Date)e.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            dto.setSysCode(e.getSysCode());
            return dto;
        }).collect(Collectors.toList());
        ListResultBean result = new ListResultBean();
        Pagination pagination = new Pagination();
        pagination.setPageCount(Long.valueOf(pages.getTotal() / pageSize + 1L));
        pagination.setItemCount(Long.valueOf(pages.getTotal()));
        pagination.setPageNo(Integer.valueOf((int)pages.getCurrent()));
        pagination.setPageSize(Integer.valueOf((int)pages.getPages()));
        result.setResult(templateDtos);
        result.setPagination(pagination);
        return result;
    }

    public ListResultBean<TemplateDto> getPageMultiMerchant(List<String> merchantids, String templateCode, String templateType, String templateName, String remark, String status, String sysCode, Long pageNum, Long pageSize) {
        QueryWrapper query = Wrappers.query();
        query.eq((Object)"valid", (Object)1);
        query.in(!CollectionUtils.isEmpty(merchantids), (Object)"merchant_id", merchantids);
        query.like(!StringUtils.isBlank((CharSequence)templateCode), (Object)"template_id", (Object)templateCode);
        query.eq(!StringUtils.isBlank((CharSequence)sysCode), (Object)"sys_code", (Object)sysCode);
        query.eq(!StringUtils.isBlank((CharSequence)templateType), (Object)"template_type", (Object)templateType);
        query.eq(!StringUtils.isBlank((CharSequence)status), (Object)"status", (Object)status);
        query.like(!StringUtils.isBlank((CharSequence)templateName), (Object)"template_name", (Object)templateName);
        query.like(!StringUtils.isBlank((CharSequence)remark), (Object)"remark", (Object)remark);
        query.orderByDesc((Object)"create_time");
        Page pages = (Page)this.templateDao.selectPage((IPage)new Page(pageNum.longValue(), pageSize.longValue()), (Wrapper)query);
        List templateDtos = pages.getRecords().stream().map(e -> {
            TemplateDto dto = new TemplateDto();
            dto.setStatus(e.getStatus() == null ? "" : e.getStatus().toString());
            dto.setContent(e.getContent());
            dto.setRemark(e.getRemark());
            dto.setTemplateType(e.getTemplateType());
            dto.setTemplateName(e.getTemplateName());
            dto.setMerchantId(e.getMerchantId());
            dto.setTemplateCode(e.getTemplateId());
            dto.setAuditReason(e.getReason());
            dto.setOriginalContent(e.getOriginalContent());
            dto.setAttach(e.getAttach());
            dto.setCreateTime(DateUtil.format((Date)e.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            dto.setSysCode(e.getSysCode());
            return dto;
        }).collect(Collectors.toList());
        ListResultBean result = new ListResultBean();
        Pagination pagination = new Pagination();
        pagination.setPageCount(Long.valueOf(pages.getTotal() / pageSize + 1L));
        pagination.setItemCount(Long.valueOf(pages.getTotal()));
        pagination.setPageNo(Integer.valueOf((int)pages.getCurrent()));
        pagination.setPageSize(Integer.valueOf((int)pages.getPages()));
        result.setResult(templateDtos);
        result.setPagination(pagination);
        return result;
    }
}

